/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.rsyntaxtextarea.AbstractTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.PreviewPanel;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.CaretStyle;

public class CaretAndSelectionOptionPanel
extends AbstractTextAreaOptionPanel
implements ChangeListener,
PropertyChangeListener {
    private JComboBox<String> insCaretCombo;
    private JComboBox<String> overCaretCombo;
    private JSpinner blinkRateSpinner;
    private RColorSwatchesButton caretColorButton;
    private RColorSwatchesButton selColorButton;
    private JCheckBox selectedTextColorCB;
    private RColorSwatchesButton selectedTextColorButton;
    private JButton systemSelectionButton;

    public CaretAndSelectionOptionPanel() {
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        this.setName(MSG.getString("Title.CaretAndSelection"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        topPanel.add(this.createOverridePanel());
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createCaretPanel(o));
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createSelectionPanel(o));
        topPanel.add(Box.createVerticalStrut(5));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(new PreviewPanel(MSG, 9, 40));
        bottomPanel.add((Component)this.createRestoreDefaultsPanel(), "South");
        topPanel.add(bottomPanel);
        this.add(topPanel, "North");
        this.applyComponentOrientation(o);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Object source = e.getSource();
        if ("InsertCaretCombo".equals(command)) {
            this.setDirty(true);
        } else if ("OverwriteCaretCombo".equals(command)) {
            this.setDirty(true);
        } else if (this.selectedTextColorCB == source) {
            boolean selected = ((JCheckBox)source).isSelected();
            this.setSelectedTextColorEnabled(selected);
            this.setDirty(true);
        } else if (this.systemSelectionButton == source) {
            JTextArea textArea = new JTextArea();
            Color systemSelectionColor = textArea.getSelectionColor();
            Color selectedTextColor = textArea.getSelectedTextColor();
            if (!(systemSelectionColor.equals(this.selColorButton.getColor()) && this.selectedTextColorCB.isSelected() && this.selectedTextColorButton.getColor().equals(selectedTextColor))) {
                this.selColorButton.setColor(systemSelectionColor);
                this.setSelectedTextColorEnabled(true);
                this.selectedTextColorButton.setColor(selectedTextColor);
                this.setDirty(true);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private static JComboBox<String> createCaretComboBox() {
        JComboBox<String> combo = new JComboBox<String>();
        UIUtil.fixComboOrientation(combo);
        combo.addItem(MSG.getString("CaretVerticalLine"));
        combo.addItem(MSG.getString("CaretUnderline"));
        combo.addItem(MSG.getString("CaretBlock"));
        combo.addItem(MSG.getString("CaretRectangle"));
        combo.addItem(MSG.getString("CaretThickVerticalLine"));
        return combo;
    }

    private Box createCaretPanel(ComponentOrientation o) {
        Box caretPanel = Box.createVerticalBox();
        caretPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("Carets")));
        JPanel temp = new JPanel(new SpringLayout());
        JLabel insLabel = new JLabel(MSG.getString("InsertCaret"));
        this.insCaretCombo = CaretAndSelectionOptionPanel.createCaretComboBox();
        this.insCaretCombo.setActionCommand("InsertCaretCombo");
        this.insCaretCombo.addActionListener(this);
        insLabel.setLabelFor(this.insCaretCombo);
        JLabel overLabel = new JLabel(MSG.getString("OverwriteCaret"));
        this.overCaretCombo = CaretAndSelectionOptionPanel.createCaretComboBox();
        this.overCaretCombo.setActionCommand("OverwriteCaretCombo");
        this.overCaretCombo.addActionListener(this);
        overLabel.setLabelFor(this.overCaretCombo);
        JLabel caretDelayLabel = new JLabel(MSG.getString("BlinkRate"));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(500, 0, 10000, 50);
        this.blinkRateSpinner = new JSpinner(spinnerModel);
        this.blinkRateSpinner.addChangeListener(this);
        caretDelayLabel.setLabelFor(this.blinkRateSpinner);
        JLabel caretColorLabel = new JLabel(MSG.getString("Color"));
        this.caretColorButton = new RColorSwatchesButton();
        this.caretColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        caretColorLabel.setLabelFor((Component)this.caretColorButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.caretColorButton, "Before");
        UIUtil.addLabelValuePairs((Container)temp, (ComponentOrientation)o, (Component[])new Component[]{insLabel, this.insCaretCombo, caretDelayLabel, this.blinkRateSpinner, overLabel, this.overCaretCombo, caretColorLabel, buttonPanel});
        UIUtil.makeSpringCompactGrid((Container)temp, (int)2, (int)4, (int)0, (int)0, (int)20, (int)8);
        caretPanel.add(temp);
        return caretPanel;
    }

    private Box createSelectionPanel(ComponentOrientation o) {
        Box p = Box.createVerticalBox();
        p.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("Selection")));
        this.selColorButton = new RColorSwatchesButton();
        this.selColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        JLabel selLabel = new JLabel(MSG.getString("SelColor"));
        selLabel.setLabelFor((Component)this.selColorButton);
        this.selectedTextColorCB = new JCheckBox(MSG.getString("SelectedTextColor"));
        this.selectedTextColorCB.addActionListener(this);
        this.selectedTextColorButton = new RColorSwatchesButton();
        this.selectedTextColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        JPanel selectionColorsPanel = new JPanel(new SpringLayout());
        UIUtil.addLabelValuePairs((Container)selectionColorsPanel, (ComponentOrientation)o, (Component[])new Component[]{selLabel, this.selColorButton, this.selectedTextColorCB, this.selectedTextColorButton});
        UIUtil.makeSpringCompactGrid((Container)selectionColorsPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        this.addLeftAligned(p, selectionColorsPanel, 0, 20);
        this.systemSelectionButton = new JButton(MSG.getString("SystemSelection"));
        this.systemSelectionButton.addActionListener(this);
        JPanel systemSelectionPanel = new JPanel(new BorderLayout());
        systemSelectionPanel.add((Component)this.systemSelectionButton, "North");
        JPanel mainSelectionPanel = new JPanel(new BorderLayout());
        mainSelectionPanel.add((Component)selectionColorsPanel, "Before");
        mainSelectionPanel.add((Component)systemSelectionPanel, "After");
        p.add(mainSelectionPanel);
        return p;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setOverrideEditorStyles(this.overrideCheckBox.isSelected());
        if (this.overrideCheckBox.isSelected()) {
            mainView.setCaretColor(this.caretColorButton.getColor());
            mainView.setSelectionColor(CaretAndSelectionOptionPanel.getColor(this.selColorButton));
            mainView.setCaretStyle(0, this.getCaretStyle(0));
            mainView.setCaretStyle(1, this.getCaretStyle(1));
            mainView.setCaretBlinkRate((Integer)this.blinkRateSpinner.getValue());
            mainView.setSelectedTextColor(CaretAndSelectionOptionPanel.getColor(this.selectedTextColorButton));
            mainView.setUseSelectedTextColor(this.selectedTextColorCB.isSelected());
        } else {
            Theme editorTheme = EditorOptionsPreviewContext.get().getEditorTheme((AbstractGUIApplication<?>)rtext);
            mainView.setCaretColor(editorTheme.caretColor);
            mainView.setSelectionColor(editorTheme.selectionBG);
            mainView.setCaretStyle(0, CaretStyle.THICK_VERTICAL_LINE_STYLE);
            mainView.setCaretStyle(1, CaretStyle.BLOCK_STYLE);
            mainView.setCaretBlinkRate(500);
            mainView.setSelectedTextColor(editorTheme.selectionFG);
            mainView.setUseSelectedTextColor(editorTheme.useSelectionFG);
        }
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public CaretStyle getCaretStyle(int mode) {
        int ordinal = mode == 0 ? this.insCaretCombo.getSelectedIndex() : this.overCaretCombo.getSelectedIndex();
        return CaretStyle.values()[ordinal];
    }

    private static Color getColor(RColorSwatchesButton button) {
        return new Color(button.getColor().getRGB());
    }

    @Override
    protected void handleRestoreDefaults() {
        RText app = (RText)((Object)this.getOptionsDialog().getParent());
        EditorOptionsPreviewContext editorContext = EditorOptionsPreviewContext.get();
        Theme rstaTheme = editorContext.getEditorTheme((AbstractGUIApplication<?>)app);
        Color defaultCaretColor = rstaTheme.caretColor;
        Color defaultSelectionColor = rstaTheme.selectionBG;
        boolean defaultSelectedTextColorCBChecked = rstaTheme.useSelectionFG;
        Color defaultSelectedTextColor = rstaTheme.selectionFG;
        CaretStyle defaultInsertCaret = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        CaretStyle defaultOverwriteCaret = CaretStyle.BLOCK_STYLE;
        Integer defaultCaretBlinkRate = 500;
        if (!(!this.overrideCheckBox.isSelected() && this.caretColorButton.getColor().equals(defaultCaretColor) && CaretAndSelectionOptionPanel.getColor(this.selColorButton).equals(defaultSelectionColor) && this.getCaretStyle(0) == defaultInsertCaret && this.getCaretStyle(1) == defaultOverwriteCaret && this.blinkRateSpinner.getValue().equals(defaultCaretBlinkRate) && this.selectedTextColorCB.isSelected() == defaultSelectedTextColorCBChecked && this.selectedTextColorButton.getColor().equals(defaultSelectedTextColor))) {
            this.overrideCheckBox.setSelected(false);
            this.setCaretColor(defaultCaretColor);
            this.setSelectionColor(defaultSelectionColor);
            this.setCaretStyle(0, defaultInsertCaret);
            this.setCaretStyle(1, defaultOverwriteCaret);
            this.blinkRateSpinner.setValue(defaultCaretBlinkRate);
            this.setSelectedTextColorEnabled(defaultSelectedTextColorCBChecked);
            this.selectedTextColorButton.setColor(Color.white);
            this.setDirty(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("RColorButton.colorChanged".equals(e.getPropertyName())) {
            this.setDirty(true);
        }
    }

    private void setBlinkRate(int blinkRate) {
        this.blinkRateSpinner.setValue(blinkRate);
    }

    private void setCaretColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.caretColorButton.setColor(color);
    }

    private void setCaretStyle(int mode, CaretStyle style) {
        switch (mode) {
            case 0: {
                this.insCaretCombo.setSelectedIndex(style.ordinal());
                break;
            }
            case 1: {
                this.overCaretCombo.setSelectedIndex(style.ordinal());
                break;
            }
            default: {
                throw new IllegalArgumentException("mode must be 0 or 1");
            }
        }
    }

    @Override
    protected void setComponentsEnabled(boolean enabled, Component ... ignore) {
        super.setComponentsEnabled(enabled, ignore);
        this.selectedTextColorButton.setEnabled(enabled && this.selectedTextColorCB.isSelected());
    }

    private void setSelectionColor(Color color) {
        if (color != null) {
            this.selColorButton.setColor(color);
        }
    }

    private void setSelectedTextColorEnabled(boolean enabled) {
        this.selectedTextColorCB.setSelected(enabled);
        this.selectedTextColorButton.setEnabled(enabled);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setCaretColor(mainView.getCaretColor());
        this.setSelectionColor(mainView.getSelectionColor());
        this.setCaretStyle(0, mainView.getCaretStyle(0));
        this.setCaretStyle(1, mainView.getCaretStyle(1));
        this.setBlinkRate(mainView.getCaretBlinkRate());
        this.setSelectedTextColorEnabled(mainView.getUseSelectedTextColor());
        this.selectedTextColorButton.setColor(mainView.getSelectedTextColor());
        this.overrideCheckBox.setSelected(mainView.getOverrideEditorStyles());
        this.setComponentsEnabled(this.overrideCheckBox.isSelected(), new Component[0]);
        this.syncEditorOptionsPreviewContext();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setDirty(true);
    }

    @Override
    protected void syncEditorOptionsPreviewContext() {
        EditorOptionsPreviewContext context = EditorOptionsPreviewContext.get();
        context.setOverrideEditorTheme(this.overrideCheckBox.isSelected());
        context.setInsertCaret(this.getCaretStyle(0));
        context.setOverwriteCaret(this.getCaretStyle(1));
        context.setCaretBlinkRate((Integer)this.blinkRateSpinner.getValue());
        context.setCaretColor(this.caretColorButton.getColor());
        context.setSelectionColor(CaretAndSelectionOptionPanel.getColor(this.selColorButton));
        context.setSelectedTextColor(CaretAndSelectionOptionPanel.getColor(this.selectedTextColorButton));
        context.setUseSelectedTextColor(this.selectedTextColorCB.isSelected());
        context.possiblyFireChangeEventAndReset();
    }
}

