/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.fife.rtext.RText;
import org.fife.rtext.RTextAppThemes;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContextListener;
import org.fife.ui.rsyntaxtextarea.PreviewPanel;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.FoldIndicatorStyle;

final class EditorOptionsPreviewContext {
    private boolean dirty;
    private boolean overrideEditorTheme;
    private String previewLanguage;
    private boolean wordWrap;
    private boolean highlightCurrentLine;
    private boolean marginLineEnabled;
    private int marginLinePosition;
    private boolean autoInsertClosingCurly;
    private boolean clearWhitespaceLines;
    private boolean antiAliasingEnabled;
    private boolean fractionalFontMetricsEnabled;
    private boolean highlightMatchingBrackets;
    private boolean highlightBothBrackets;
    private Font font;
    private Color fontColor;
    private int tabSize;
    private boolean emulateTabs;
    private boolean showWhitespace;
    private boolean showEolMarkers;
    private boolean showIndentGuides;
    private Color backgroundColor;
    private SyntaxScheme syntaxScheme;
    private CaretStyle insertCaret;
    private CaretStyle overwriteCaret;
    private int caretBlinkRate;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private boolean useSelectedTextColor;
    private Color currentLineHighlightColor;
    private Color markAllHighlightColor;
    private boolean markOccurrences;
    private Color markOccurrencesColor;
    private boolean highlightSecondaryLanguages;
    private Color[] secondaryLanguages;
    private boolean lineNumbersEnabled;
    private Font lineNumberFont;
    private Color lineNumberColor;
    private FoldIndicatorStyle foldIndicatorStyle;
    private Color foldForeground;
    private Color armedFoldForeground;
    private Color foldBackground;
    private Color armedFoldBackground;
    private EventListenerList listeners = new EventListenerList();
    private static final EditorOptionsPreviewContext INSTANCE = new EditorOptionsPreviewContext();

    private EditorOptionsPreviewContext() {
        this.secondaryLanguages = new Color[3];
    }

    void addListener(EditorOptionsPreviewContextListener listener) {
        this.listeners.add(EditorOptionsPreviewContextListener.class, listener);
    }

    public static EditorOptionsPreviewContext get() {
        return INSTANCE;
    }

    public boolean getAntiAliasingEnabled() {
        return this.antiAliasingEnabled;
    }

    public Color getArmedFoldBackground() {
        return this.armedFoldBackground;
    }

    public Color getArmedFoldForeground() {
        return this.armedFoldForeground;
    }

    public boolean getAutoInsertClosingCurly() {
        return this.autoInsertClosingCurly;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getCaretBlinkRate() {
        return this.caretBlinkRate;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public boolean getClearWhitespaceLines() {
        return this.clearWhitespaceLines;
    }

    public Color getCurrentLineHighlightColor() {
        return this.currentLineHighlightColor;
    }

    public Theme getEditorTheme(AbstractGUIApplication<?> app) {
        try {
            return RTextAppThemes.getRstaTheme(app.getTheme(), this.getFont());
        }
        catch (IOException ioe) {
            app.displayException((Throwable)ioe);
            return null;
        }
    }

    public boolean getEmulateTabs() {
        return this.emulateTabs;
    }

    public Color getFoldBackground() {
        return this.foldBackground;
    }

    public Color getFoldForeground() {
        return this.foldForeground;
    }

    public FoldIndicatorStyle getFoldIndicatorStyle() {
        return this.foldIndicatorStyle;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public boolean getFractionalFontMetricsEnabled() {
        return this.fractionalFontMetricsEnabled;
    }

    public boolean getHighlightBothBrackets() {
        return this.highlightBothBrackets;
    }

    public boolean getHighlightCurrentLine() {
        return this.highlightCurrentLine;
    }

    public boolean getHighlightMatchingBrackets() {
        return this.highlightMatchingBrackets;
    }

    public boolean getHighlightSecondaryLanguages() {
        return this.highlightSecondaryLanguages;
    }

    public CaretStyle getInsertCaret() {
        return this.insertCaret;
    }

    public Color getLineNumberColor() {
        return this.lineNumberColor;
    }

    public Font getLineNumberFont() {
        return this.lineNumberFont;
    }

    public boolean getLineNumbersEnabled() {
        return this.lineNumbersEnabled;
    }

    public boolean getMarginLineEnabled() {
        return this.marginLineEnabled;
    }

    public int getMarginLinePosition() {
        return this.marginLinePosition;
    }

    public Color getMarkAllHighlightColor() {
        return this.markAllHighlightColor;
    }

    public boolean getMarkOccurrences() {
        return this.markOccurrences;
    }

    public Color getMarkOccurrencesColor() {
        return this.markOccurrencesColor;
    }

    public boolean getOverrideEditorTheme() {
        return this.overrideEditorTheme;
    }

    public CaretStyle getOverwriteCaret() {
        return this.overwriteCaret;
    }

    public String getPreviewLanguage() {
        return this.previewLanguage;
    }

    public Color getSecondaryLanguageBackground(int index) {
        return this.secondaryLanguages[index];
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public boolean getShowEolMarkers() {
        return this.showEolMarkers;
    }

    public boolean getShowIndentGuides() {
        return this.showIndentGuides;
    }

    public boolean getShowWhitespace() {
        return this.showWhitespace;
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.syntaxScheme;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public boolean getUseSelectedTextColor() {
        return this.useSelectedTextColor;
    }

    public boolean getWordWrap() {
        return this.wordWrap;
    }

    public void initialize(RText rtext) {
        this.lineNumberFont = this.font = rtext.getMainView().getTextAreaFont();
        this.syntaxScheme = rtext.getSyntaxScheme();
        this.previewLanguage = PreviewPanel.DEFAULT_PREVIEW_LANGUAGE;
        this.foldIndicatorStyle = FoldIndicatorStyle.MODERN;
    }

    public void possiblyFireChangeEventAndReset() {
        if (this.dirty) {
            Object[] listeners = this.listeners.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != EditorOptionsPreviewContextListener.class) continue;
                ((EditorOptionsPreviewContextListener)listeners[i + 1]).editorOptionsPreviewContextChanged(this);
            }
            this.dirty = false;
        }
    }

    private void registerChanges() {
        this.dirty = true;
    }

    void removeListener(EditorOptionsPreviewContextListener listener) {
        this.listeners.remove(EditorOptionsPreviewContextListener.class, listener);
    }

    public void setAntiAliasingEnabled(boolean enable) {
        if (this.antiAliasingEnabled != enable) {
            this.antiAliasingEnabled = enable;
            this.registerChanges();
        }
    }

    public void setArmedFoldBackground(Color armedFoldBackground) {
        if (!Objects.equals(this.armedFoldBackground, armedFoldBackground)) {
            this.armedFoldBackground = armedFoldBackground;
            this.registerChanges();
        }
    }

    public void setArmedFoldForeground(Color armedFoldForeground) {
        if (!Objects.equals(this.armedFoldForeground, armedFoldForeground)) {
            this.armedFoldForeground = armedFoldForeground;
            this.registerChanges();
        }
    }

    public void setAutoInsertClosingCurly(boolean autoInsertClosingCurly) {
        if (this.autoInsertClosingCurly != autoInsertClosingCurly) {
            this.autoInsertClosingCurly = autoInsertClosingCurly;
            this.registerChanges();
        }
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (!Objects.equals(this.backgroundColor, backgroundColor)) {
            this.backgroundColor = backgroundColor;
            this.registerChanges();
        }
    }

    public void setCaretBlinkRate(int caretBlinkRate) {
        if (this.caretBlinkRate != caretBlinkRate) {
            this.caretBlinkRate = caretBlinkRate;
            this.registerChanges();
        }
    }

    public void setCaretColor(Color caretColor) {
        if (!Objects.equals(this.caretColor, caretColor)) {
            this.caretColor = caretColor;
            this.registerChanges();
        }
    }

    public void setClearWhitespaceLines(boolean remove) {
        if (this.clearWhitespaceLines != remove) {
            this.clearWhitespaceLines = remove;
            this.registerChanges();
        }
    }

    public void setCurrentLineHighlightColor(Color color) {
        if (this.currentLineHighlightColor != color) {
            this.currentLineHighlightColor = color;
            this.registerChanges();
        }
    }

    public void setEmulateTabs(boolean emulateTabs) {
        if (this.emulateTabs != emulateTabs) {
            this.emulateTabs = emulateTabs;
            this.registerChanges();
        }
    }

    public void setFoldBackground(Color foldBackground) {
        if (!Objects.equals(this.foldBackground, foldBackground)) {
            this.foldBackground = foldBackground;
            this.registerChanges();
        }
    }

    public void setFoldForeground(Color foldForeground) {
        if (!Objects.equals(this.foldForeground, foldForeground)) {
            this.foldForeground = foldForeground;
            this.registerChanges();
        }
    }

    public void setFoldIndicatorStyle(FoldIndicatorStyle style) {
        if (this.foldIndicatorStyle != style) {
            this.foldIndicatorStyle = style;
            this.registerChanges();
        }
    }

    public void setFont(Font font) {
        if (!Objects.equals(this.font, font)) {
            this.font = font;
            this.registerChanges();
        }
    }

    public void setFontColor(Color color) {
        if (!Objects.equals(this.fontColor, color)) {
            this.fontColor = color;
            this.registerChanges();
        }
    }

    public void setFractionalFontMetricsEnabled(boolean enable) {
        if (this.fractionalFontMetricsEnabled != enable) {
            this.fractionalFontMetricsEnabled = enable;
            this.registerChanges();
        }
    }

    public void setHighlightBothBrackets(boolean highlightBothBrackets) {
        if (this.highlightBothBrackets != highlightBothBrackets) {
            this.highlightBothBrackets = highlightBothBrackets;
            this.registerChanges();
        }
    }

    public void setHighlightCurrentLine(boolean highlightCurrentLine) {
        if (this.highlightCurrentLine != highlightCurrentLine) {
            this.highlightCurrentLine = highlightCurrentLine;
            this.registerChanges();
        }
    }

    public void setHighlightMatchingBrackets(boolean highlightMatchingBrackets) {
        if (this.highlightMatchingBrackets != highlightMatchingBrackets) {
            this.highlightMatchingBrackets = highlightMatchingBrackets;
            this.registerChanges();
        }
    }

    public void setHighlightSecondaryLanguages(boolean highlightSecondaryLanguages) {
        if (this.highlightSecondaryLanguages != highlightSecondaryLanguages) {
            this.highlightSecondaryLanguages = highlightSecondaryLanguages;
            this.registerChanges();
        }
    }

    public void setInsertCaret(CaretStyle insertCaret) {
        if (this.insertCaret != insertCaret) {
            this.insertCaret = insertCaret;
            this.registerChanges();
        }
    }

    public void setLineNumberColor(Color lineNumberColor) {
        if (!Objects.equals(this.lineNumberColor, lineNumberColor)) {
            this.lineNumberColor = lineNumberColor;
            this.registerChanges();
        }
    }

    public void setLineNumberFont(Font font) {
        if (!Objects.equals(this.lineNumberFont, font)) {
            this.lineNumberFont = font;
            this.registerChanges();
        }
    }

    public void setLineNumbersEnabled(boolean enabled) {
        if (this.lineNumbersEnabled != enabled) {
            this.lineNumbersEnabled = enabled;
            this.registerChanges();
        }
    }

    public void setMarginLineEnabled(boolean marginLineEnabled) {
        if (this.marginLineEnabled != marginLineEnabled) {
            this.marginLineEnabled = marginLineEnabled;
            this.registerChanges();
        }
    }

    public void setMarginLinePosition(int marginLinePosition) {
        if (this.marginLinePosition != marginLinePosition) {
            this.marginLinePosition = marginLinePosition;
            this.registerChanges();
        }
    }

    public void setMarkAllHighlightColor(Color markAllHighlightColor) {
        if (!Objects.equals(this.markAllHighlightColor, markAllHighlightColor)) {
            this.markAllHighlightColor = markAllHighlightColor;
            this.registerChanges();
        }
    }

    public void setMarkOccurrences(boolean markOccurrences) {
        if (this.markOccurrences != markOccurrences) {
            this.markOccurrences = markOccurrences;
            this.registerChanges();
        }
    }

    public void setMarkOccurrencesColor(Color markOccurrencesColor) {
        if (!Objects.equals(this.markOccurrencesColor, markOccurrencesColor)) {
            this.markOccurrencesColor = markOccurrencesColor;
            this.registerChanges();
        }
    }

    public void setOverrideEditorTheme(boolean overrideEditorTheme) {
        if (this.overrideEditorTheme != overrideEditorTheme) {
            this.overrideEditorTheme = overrideEditorTheme;
            this.registerChanges();
        }
    }

    public void setOverwriteCaret(CaretStyle overwriteCaret) {
        if (this.overwriteCaret != overwriteCaret) {
            this.overwriteCaret = overwriteCaret;
            this.registerChanges();
        }
    }

    public void setPreviewLanguage(String previewLanguage) {
        if (!Objects.equals(this.previewLanguage, previewLanguage)) {
            this.previewLanguage = previewLanguage;
            this.registerChanges();
        }
    }

    public void setSecondaryLanguageBackground(int index, Color color) {
        if (!Objects.equals(this.secondaryLanguages[index], color)) {
            this.secondaryLanguages[index] = color;
            this.registerChanges();
        }
    }

    public void setSelectedTextColor(Color selectedTextColor) {
        if (!Objects.equals(this.selectedTextColor, selectedTextColor)) {
            this.selectedTextColor = selectedTextColor;
            this.registerChanges();
        }
    }

    public void setSelectionColor(Color selectionColor) {
        if (!Objects.equals(this.selectionColor, selectionColor)) {
            this.selectionColor = selectionColor;
            this.registerChanges();
        }
    }

    public void setShowEolMarkers(boolean showEolMarkers) {
        if (this.showEolMarkers != showEolMarkers) {
            this.showEolMarkers = showEolMarkers;
            this.registerChanges();
        }
    }

    public void setShowIndentGuides(boolean showIndentGuides) {
        if (this.showIndentGuides != showIndentGuides) {
            this.showIndentGuides = showIndentGuides;
            this.registerChanges();
        }
    }

    public void setShowWhitespace(boolean showWhitespace) {
        if (this.showWhitespace != showWhitespace) {
            this.showWhitespace = showWhitespace;
            this.registerChanges();
        }
    }

    public void setSyntaxScheme(SyntaxScheme scheme) {
        if (!Objects.equals(this.syntaxScheme, scheme)) {
            this.syntaxScheme = scheme;
            this.registerChanges();
        }
    }

    public void setTabSize(int tabSize) {
        if (this.tabSize != tabSize) {
            this.tabSize = tabSize;
            this.registerChanges();
        }
    }

    public void setUseSelectedTextColor(boolean useSelectedTextColor) {
        if (this.useSelectedTextColor != useSelectedTextColor) {
            this.useSelectedTextColor = useSelectedTextColor;
            this.registerChanges();
        }
    }

    public void setWordWrap(boolean wordWrap) {
        if (this.wordWrap != wordWrap) {
            this.wordWrap = wordWrap;
            this.registerChanges();
        }
    }
}

