/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.FontSelector;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.rsyntaxtextarea.AbstractTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.PreviewPanel;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextArea;

public class FontAndTabsOptionPanel
extends AbstractTextAreaOptionPanel
implements DocumentListener,
PropertyChangeListener {
    public static final String OPTION_PANEL_ID = "FontAndTabsOptionPanel";
    private FontSelector fontSelector;
    private JLabel tabSizeLabel;
    private JTextField tabSizeField;
    private int tabSize;
    private JCheckBox emulateTabsCheckBox;
    private JCheckBox visibleWhitespaceCheckBox;
    private JCheckBox visibleEOLCheckBox;
    private JCheckBox showTabLinesCheckBox;

    public FontAndTabsOptionPanel() {
        this.setId(OPTION_PANEL_ID);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setName(MSG.getString("Title.Font"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        topPanel.add(this.createFontPanel());
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createTabPanel());
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createOtherPanel());
        topPanel.add(Box.createVerticalStrut(5));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(new PreviewPanel(MSG, 9, 40));
        bottomPanel.add((Component)this.createRestoreDefaultsPanel(), "South");
        topPanel.add(bottomPanel);
        this.add(topPanel, "North");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("EmulateTabsCheckBox".equals(command)) {
            this.setDirty(true);
        } else if ("VisibleWhitespace".equals(command)) {
            this.setDirty(true);
        } else if ("VisibleEOL".equals(command)) {
            this.setDirty(true);
        } else if ("ShowIndentGuide".equals(command)) {
            this.setDirty(true);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private JCheckBox createCheckBox(String key) {
        JCheckBox cb = new JCheckBox(MSG.getString(key));
        cb.setActionCommand(key);
        cb.addActionListener(this);
        return cb;
    }

    private JPanel createFontPanel() {
        JPanel fontPanel = new JPanel(new BorderLayout());
        fontPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("Font")));
        this.fontSelector = new FontSelector();
        this.fontSelector.setColorSelectable(true);
        this.fontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        this.fontSelector.addPropertyChangeListener("fontColor", (PropertyChangeListener)this);
        fontPanel.add((Component)this.fontSelector);
        return fontPanel;
    }

    private JComponent createOtherPanel() {
        Box otherPanel = Box.createVerticalBox();
        otherPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(this.getString("OptOtherTitle")));
        this.visibleWhitespaceCheckBox = this.createCheckBox("VisibleWhitespace");
        this.addLeftAligned(otherPanel, this.visibleWhitespaceCheckBox, 3);
        this.visibleEOLCheckBox = this.createCheckBox("VisibleEOL");
        this.addLeftAligned(otherPanel, this.visibleEOLCheckBox, 3);
        this.showTabLinesCheckBox = new JCheckBox(MSG.getString("ShowIndentGuide"));
        this.showTabLinesCheckBox.setActionCommand("ShowIndentGuide");
        this.showTabLinesCheckBox.addActionListener(this);
        Box box = this.createHorizontalBox();
        box.add(this.showTabLinesCheckBox);
        box.add(Box.createHorizontalGlue());
        this.addLeftAligned(otherPanel, box);
        return otherPanel;
    }

    private JComponent createTabPanel() {
        Box tabPanel = Box.createVerticalBox();
        tabPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("Tabs")));
        Box inputPanel = this.createHorizontalBox();
        this.tabSizeLabel = new JLabel(MSG.getString("TabSize"));
        this.tabSizeField = new JTextField();
        this.tabSizeField.getDocument().addDocumentListener(this);
        Dimension size = new Dimension(40, this.tabSizeField.getPreferredSize().height);
        this.tabSizeField.setMaximumSize(size);
        this.tabSizeField.setPreferredSize(size);
        inputPanel.add(this.tabSizeLabel);
        inputPanel.add(Box.createHorizontalStrut(5));
        inputPanel.add(this.tabSizeField);
        inputPanel.add(Box.createHorizontalGlue());
        this.addLeftAligned(tabPanel, inputPanel, 3);
        this.emulateTabsCheckBox = new JCheckBox(MSG.getString("EmulateTabs"));
        this.emulateTabsCheckBox.setActionCommand("EmulateTabsCheckBox");
        this.emulateTabsCheckBox.addActionListener(this);
        this.addLeftAligned(tabPanel, this.emulateTabsCheckBox);
        tabPanel.add(Box.createVerticalGlue());
        return tabPanel;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setTextAreaForeground(this.fontSelector.getFontColor());
        mainView.setTextAreaFont(this.fontSelector.getDisplayedFont(), this.fontSelector.getUnderline());
        rtext.setRowColumnIndicatorVisible(!mainView.getLineWrap());
        mainView.setTabSize(this.getTabSize());
        mainView.setTabsEmulated(this.emulateTabsCheckBox.isSelected());
        mainView.setWhitespaceVisible(this.visibleWhitespaceCheckBox.isSelected());
        mainView.setShowEOLMarkers(this.visibleEOLCheckBox.isSelected());
        mainView.setShowTabLines(this.showTabLinesCheckBox.isSelected());
    }

    private void doDocumentUpdated() {
        this.setDirty(true);
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        int temp;
        try {
            temp = Integer.parseInt(this.tabSizeField.getText());
            if (temp < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            OptionsDialogPanel.OptionsPanelCheckResult res = new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this);
            res.errorMessage = "Invalid number format for tab size;\nPlease input a tab size greater than zero.";
            res.component = this.tabSizeField;
            this.tabSize = -1;
            return res;
        }
        this.tabSize = temp;
        return null;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    @Override
    public JComponent getTopJComponent() {
        return this.tabSizeField;
    }

    @Override
    protected void handleRestoreDefaults() {
        EditorOptionsPreviewContext editorContext = EditorOptionsPreviewContext.get();
        RText app = (RText)((Object)this.getOptionsDialog().getParent());
        Theme rstaTheme = editorContext.getEditorTheme((AbstractGUIApplication<?>)app);
        Font defaultFont = RTextArea.getDefaultFont();
        Color defaultForeground = rstaTheme.scheme.getStyle((int)20).foreground;
        int defaultTabSize = RTextArea.getDefaultTabSize();
        if (!this.fontSelector.getDisplayedFont().equals(defaultFont) || !this.fontSelector.getFontColor().equals(defaultForeground) || this.fontSelector.getUnderline() || this.getTabSize() != defaultTabSize || this.emulateTabsCheckBox.isSelected() || this.visibleWhitespaceCheckBox.isSelected() || this.visibleEOLCheckBox.isSelected() || this.showTabLinesCheckBox.isSelected()) {
            this.fontSelector.setDisplayedFont(defaultFont, false);
            this.fontSelector.setFontColor(defaultForeground);
            this.setTabSize(defaultTabSize);
            this.emulateTabsCheckBox.setSelected(false);
            this.visibleWhitespaceCheckBox.setSelected(false);
            this.visibleEOLCheckBox.setSelected(false);
            this.showTabLinesCheckBox.setSelected(false);
            this.setDirty(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doDocumentUpdated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.setDirty(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doDocumentUpdated();
    }

    private void setTabSize(int tabSize) {
        if (this.tabSize != tabSize && tabSize > 0) {
            this.tabSize = tabSize;
        }
        this.tabSizeField.setText(Integer.toString(tabSize));
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        EditorOptionsPreviewContext previewContext = EditorOptionsPreviewContext.get();
        if (previewContext.getSyntaxScheme() == null) {
            previewContext.initialize(rtext);
        }
        AbstractMainView mainView = rtext.getMainView();
        this.fontSelector.setFontColor(mainView.getTextAreaForeground());
        this.fontSelector.setDisplayedFont(mainView.getTextAreaFont(), mainView.getTextAreaUnderline());
        this.setTabSize(mainView.getTabSize());
        this.emulateTabsCheckBox.setSelected(mainView.areTabsEmulated());
        this.visibleWhitespaceCheckBox.setSelected(mainView.isWhitespaceVisible());
        this.visibleEOLCheckBox.setSelected(mainView.getShowEOLMarkers());
        this.showTabLinesCheckBox.setSelected(mainView.getShowTabLines());
        this.syncEditorOptionsPreviewContext();
    }

    @Override
    protected void syncEditorOptionsPreviewContext() {
        EditorOptionsPreviewContext context = EditorOptionsPreviewContext.get();
        context.getSyntaxScheme().changeBaseFont(context.getFont(), this.fontSelector.getDisplayedFont());
        context.setFont(this.fontSelector.getDisplayedFont());
        context.setFontColor(this.fontSelector.getFontColor());
        context.setTabSize(this.getTabSize());
        context.setEmulateTabs(this.emulateTabsCheckBox.isSelected());
        context.setShowWhitespace(this.visibleWhitespaceCheckBox.isSelected());
        context.setShowEolMarkers(this.visibleEOLCheckBox.isSelected());
        context.setShowIndentGuides(this.showTabLinesCheckBox.isSelected());
        context.possiblyFireChangeEventAndReset();
    }
}

