/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.FontSelector;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.rsyntaxtextarea.AbstractTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.PreviewPanel;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextArea;

public class GutterOptionPanel
extends AbstractTextAreaOptionPanel
implements PropertyChangeListener,
ItemListener {
    private FontSelector fontSelector;
    private RColorSwatchesButton lnColorButton;
    private RColorSwatchesButton foldForegroundButton;
    private RColorSwatchesButton armedFoldForegroundButton;
    private RColorSwatchesButton foldBackgroundButton;
    private RColorSwatchesButton armedFoldBackgroundButton;

    public GutterOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setName(MSG.getString("Title.Gutter"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = new Box(1);
        topPanel.add(this.createOverridePanel());
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createLineNumbersPanel());
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createFoldAreaPanel(orientation));
        topPanel.add(Box.createVerticalStrut(5));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(new PreviewPanel(MSG, 9, 40));
        bottomPanel.add((Component)this.createRestoreDefaultsPanel(), "South");
        topPanel.add(bottomPanel);
        topPanel.add(Box.createVerticalGlue());
        this.add(topPanel, "North");
        this.applyComponentOrientation(orientation);
    }

    private Container createFoldAreaPanel(ComponentOrientation orientation) {
        Box foldPanel = Box.createVerticalBox();
        foldPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("FoldArea")));
        JPanel foldForegroundColorsPanel = new JPanel(new SpringLayout());
        JLabel fgLabel = UIUtil.newLabel((ResourceBundle)MSG, (String)"FoldForeground");
        this.foldForegroundButton = new RColorSwatchesButton();
        this.foldForegroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        fgLabel.setLabelFor((Component)this.foldForegroundButton);
        JLabel armedFgLabel = UIUtil.newLabel((ResourceBundle)MSG, (String)"ArmedFoldForeground");
        this.armedFoldForegroundButton = new RColorSwatchesButton();
        this.armedFoldForegroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        armedFgLabel.setLabelFor((Component)this.armedFoldBackgroundButton);
        UIUtil.addLabelValuePairs((Container)foldForegroundColorsPanel, (ComponentOrientation)orientation, (Component[])new Component[]{fgLabel, this.foldForegroundButton, armedFgLabel, this.armedFoldForegroundButton});
        UIUtil.makeSpringCompactGrid((Container)foldForegroundColorsPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        JPanel foldBackgroundColorsPanel = new JPanel(new SpringLayout());
        JLabel foldBackgroundLabel = UIUtil.newLabel((ResourceBundle)MSG, (String)"FoldBackground");
        this.foldBackgroundButton = new RColorSwatchesButton();
        this.foldBackgroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        foldBackgroundLabel.setLabelFor((Component)this.foldBackgroundButton);
        JLabel armedFoldBackgroundLabel = UIUtil.newLabel((ResourceBundle)MSG, (String)"ArmedFoldBackground");
        this.armedFoldBackgroundButton = new RColorSwatchesButton();
        this.armedFoldBackgroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        armedFoldBackgroundLabel.setLabelFor((Component)this.armedFoldBackgroundButton);
        UIUtil.addLabelValuePairs((Container)foldBackgroundColorsPanel, (ComponentOrientation)orientation, (Component[])new Component[]{foldBackgroundLabel, this.foldBackgroundButton, armedFoldBackgroundLabel, this.armedFoldBackgroundButton});
        UIUtil.makeSpringCompactGrid((Container)foldBackgroundColorsPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        Box colorsPanel = this.createHorizontalBox();
        colorsPanel.add(foldForegroundColorsPanel);
        colorsPanel.add(Box.createHorizontalStrut(20));
        colorsPanel.add(foldBackgroundColorsPanel);
        colorsPanel.add(Box.createHorizontalGlue());
        this.addLeftAligned(foldPanel, colorsPanel);
        return foldPanel;
    }

    private Box createLineNumbersPanel() {
        Box lineNumbersPanel = new Box(1);
        lineNumbersPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("LineNumbers")));
        JPanel fontPanel = new JPanel(new BorderLayout());
        this.fontSelector = new FontSelector();
        this.fontSelector.setColorSelectable(true);
        this.fontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        this.fontSelector.addPropertyChangeListener("fontColor", (PropertyChangeListener)this);
        fontPanel.add((Component)this.fontSelector);
        lineNumbersPanel.add(fontPanel);
        lineNumbersPanel.add(Box.createVerticalStrut(3));
        JLabel lnColorLabel = new JLabel(MSG.getString("Color"));
        this.lnColorButton = new RColorSwatchesButton();
        this.lnColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        lnColorLabel.setLabelFor((Component)this.lnColorButton);
        Box temp = new Box(2);
        temp.add(lnColorLabel);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.lnColorButton);
        temp.add(Box.createHorizontalGlue());
        this.addLeftAligned(lineNumbersPanel, temp);
        return lineNumbersPanel;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setOverrideEditorStyles(this.overrideCheckBox.isSelected());
        if (this.overrideCheckBox.isSelected()) {
            mainView.setLineNumberFont(this.fontSelector.getDisplayedFont());
            mainView.setLineNumberColor(this.lnColorButton.getColor());
            mainView.setFoldForeground(this.foldForegroundButton.getColor());
            mainView.setArmedFoldForeground(this.armedFoldForegroundButton.getColor());
            mainView.setFoldBackground(this.foldBackgroundButton.getColor());
            mainView.setArmedFoldBackground(this.armedFoldBackgroundButton.getColor());
        } else {
            EditorOptionsPreviewContext editorContext = EditorOptionsPreviewContext.get();
            Theme editorTheme = editorContext.getEditorTheme((AbstractGUIApplication<?>)rtext);
            mainView.setLineNumberFont(editorContext.getFont());
            mainView.setLineNumberColor(editorTheme.lineNumberColor);
            mainView.setFoldForeground(editorTheme.foldIndicatorFG);
            mainView.setArmedFoldForeground(editorTheme.foldIndicatorArmedFG);
            mainView.setFoldBackground(editorTheme.foldBG);
            mainView.setArmedFoldBackground(editorTheme.armedFoldBG);
        }
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    @Override
    public void handleRestoreDefaults() {
        RText app = (RText)((Object)this.getOptionsDialog().getParent());
        EditorOptionsPreviewContext editorContext = EditorOptionsPreviewContext.get();
        Theme rstaTheme = editorContext.getEditorTheme((AbstractGUIApplication<?>)app);
        Font defaultFont = RTextArea.getDefaultFont();
        Color defLineNumberColor = rstaTheme.lineNumberColor;
        Color defFoldIconForeground = rstaTheme.foldIndicatorFG;
        Color defArmedFoldIconForeground = rstaTheme.foldIndicatorArmedFG;
        Color defFoldIconBackground = rstaTheme.foldBG;
        Color defArmedFoldIconBackground = rstaTheme.armedFoldBG;
        if (!(!this.overrideCheckBox.isSelected() && defaultFont.equals(this.fontSelector.getDisplayedFont()) && defLineNumberColor.equals(this.lnColorButton.getColor()) && defFoldIconForeground.equals(this.foldForegroundButton.getColor()) && defArmedFoldIconForeground.equals(this.armedFoldForegroundButton.getColor()) && defFoldIconBackground.equals(this.foldBackgroundButton.getColor()) && defArmedFoldIconBackground.equals(this.armedFoldBackgroundButton.getColor()))) {
            this.overrideCheckBox.setSelected(false);
            this.fontSelector.setDisplayedFont(defaultFont, false);
            this.lnColorButton.setColor(defLineNumberColor);
            this.foldForegroundButton.setColor(defFoldIconForeground);
            this.armedFoldForegroundButton.setColor(defArmedFoldIconForeground);
            this.foldBackgroundButton.setColor(defFoldIconBackground);
            this.armedFoldBackgroundButton.setColor(defArmedFoldIconBackground);
            this.setDirty(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setDirty(true);
        super.itemStateChanged(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.setDirty(true);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.fontSelector.setDisplayedFont(mainView.getLineNumberFont(), false);
        this.lnColorButton.setColor(mainView.getLineNumberColor());
        this.foldForegroundButton.setColor(mainView.getFoldForeground());
        this.armedFoldForegroundButton.setColor(mainView.getArmedFoldForeground());
        this.foldBackgroundButton.setColor(mainView.getFoldBackground());
        this.armedFoldBackgroundButton.setColor(mainView.getArmedFoldBackground());
        this.overrideCheckBox.setSelected(mainView.getOverrideEditorStyles());
        this.setComponentsEnabled(this.overrideCheckBox.isSelected(), new Component[0]);
        this.syncEditorOptionsPreviewContext();
    }

    @Override
    protected void syncEditorOptionsPreviewContext() {
        EditorOptionsPreviewContext context = EditorOptionsPreviewContext.get();
        context.setOverrideEditorTheme(this.overrideCheckBox.isSelected());
        context.setLineNumberFont(this.fontSelector.getDisplayedFont());
        context.setLineNumberColor(this.lnColorButton.getColor());
        context.setFoldForeground(this.foldForegroundButton.getColor());
        context.setArmedFoldForeground(this.armedFoldForegroundButton.getColor());
        context.setFoldBackground(this.foldBackgroundButton.getColor());
        context.setArmedFoldBackground(this.armedFoldBackgroundButton.getColor());
        context.possiblyFireChangeEventAndReset();
    }
}

