/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.rsyntaxtextarea.AbstractTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.PreviewPanel;
import org.fife.ui.rsyntaxtextarea.Theme;

public class HighlightsOptionPanel
extends AbstractTextAreaOptionPanel
implements ChangeListener,
PropertyChangeListener {
    private RColorSwatchesButton currentLineColorButton;
    private RColorSwatchesButton markAllColorButton;
    private JCheckBox enableMOCheckBox;
    private RColorSwatchesButton moColorButton;
    private JCheckBox secLangCB;
    private JLabel[] secLangLabels;
    private RColorSwatchesButton[] secLangButtons;
    private static final int SEC_LANG_COUNT = 3;
    private static final Color[] DEFAULT_SECONDARY_LANGUAGE_COLORS = new Color[]{new Color(0xFFF0CC), new Color(14352090), new Color(0xFFE0F0)};

    public HighlightsOptionPanel() {
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        this.setName(MSG.getString("Title.Highlights"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        topPanel.add(this.createOverridePanel());
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createHighlightsPanel(o));
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createSecondaryLanguagesPanel(o));
        topPanel.add(Box.createVerticalStrut(5));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(new PreviewPanel(MSG, 9, 40));
        bottomPanel.add((Component)this.createRestoreDefaultsPanel(), "South");
        topPanel.add(bottomPanel);
        this.add(topPanel, "North");
        this.applyComponentOrientation(o);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Object source = e.getSource();
        if ("MarkOccurrences".equals(command)) {
            boolean selected = this.enableMOCheckBox.isSelected();
            this.moColorButton.setEnabled(selected);
            this.setDirty(true);
        } else if (this.secLangCB == source) {
            boolean selected = ((JCheckBox)source).isSelected();
            this.setHighlightSecondaryLanguages(selected);
            this.setDirty(true);
        } else if (this.currentLineColorButton == source || this.markAllColorButton == source) {
            this.setDirty(true);
        } else {
            super.actionPerformed(e);
        }
    }

    private Box createHighlightsPanel(ComponentOrientation o) {
        Box p = Box.createVerticalBox();
        p.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("Section.Highlights")));
        JPanel temp = new JPanel(new SpringLayout());
        this.currentLineColorButton = new RColorSwatchesButton();
        this.currentLineColorButton.addActionListener((ActionListener)this);
        this.markAllColorButton = new RColorSwatchesButton();
        this.markAllColorButton.addActionListener((ActionListener)this);
        JLabel currentLineColorLabel = UIUtil.newLabel((ResourceBundle)MSG, (String)"CurrentLineHighlightColor", (Component)this.currentLineColorButton);
        JLabel markAllColorLabel = UIUtil.newLabel((ResourceBundle)MSG, (String)"MarkAllColor", (Component)this.markAllColorButton);
        UIUtil.addLabelValuePairs((Container)temp, (ComponentOrientation)o, (Component[])new Component[]{currentLineColorLabel, this.currentLineColorButton, markAllColorLabel, this.markAllColorButton});
        UIUtil.makeSpringCompactGrid((Container)temp, (int)2, (int)2, (int)0, (int)0, (int)5, (int)3);
        this.addLeftAligned(p, temp, 3);
        this.enableMOCheckBox = UIUtil.newCheckBox((ResourceBundle)MSG, (String)"EnableMarkOccurrences");
        this.enableMOCheckBox.setActionCommand("MarkOccurrences");
        this.enableMOCheckBox.addActionListener(this);
        this.moColorButton = new RColorSwatchesButton();
        this.moColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        Box box = this.createHorizontalBox();
        box.add(this.enableMOCheckBox);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)this.moColorButton);
        box.add(Box.createHorizontalGlue());
        p.add(box);
        return p;
    }

    private Box createSecondaryLanguagesPanel(ComponentOrientation o) {
        Box p = Box.createVerticalBox();
        p.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("SecondaryLanguages")));
        this.secLangCB = new JCheckBox(MSG.getString("HighlightSecondaryLanguages"));
        this.secLangCB.addActionListener(this);
        this.addLeftAligned(p, this.secLangCB, 3);
        this.secLangLabels = new JLabel[3];
        this.secLangButtons = new RColorSwatchesButton[3];
        for (int i = 0; i < 3; ++i) {
            this.secLangButtons[i] = new RColorSwatchesButton();
            this.secLangButtons[i].addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
            this.secLangLabels[i] = new JLabel(MSG.getString("HighlightSecondaryLanguages.Color" + (i + 1)));
            this.secLangLabels[i].setLabelFor((Component)this.secLangButtons[i]);
        }
        JPanel temp = new JPanel(new SpringLayout());
        if (o.isLeftToRight()) {
            temp.add(this.secLangLabels[0]);
            temp.add((Component)this.secLangButtons[0]);
            temp.add(Box.createHorizontalStrut(15));
            temp.add(this.secLangLabels[1]);
            temp.add((Component)this.secLangButtons[1]);
            temp.add(Box.createHorizontalStrut(15));
            temp.add(this.secLangLabels[2]);
            temp.add((Component)this.secLangButtons[2]);
        } else {
            temp.add((Component)this.secLangButtons[0]);
            temp.add(this.secLangLabels[0]);
            temp.add(Box.createHorizontalStrut(15));
            temp.add((Component)this.secLangButtons[1]);
            temp.add(this.secLangLabels[1]);
            temp.add(Box.createHorizontalStrut(15));
            temp.add((Component)this.secLangButtons[2]);
            temp.add(this.secLangLabels[2]);
        }
        UIUtil.makeSpringCompactGrid((Container)temp, (int)1, (int)8, (int)0, (int)0, (int)5, (int)5);
        this.addLeftAligned(p, temp, 0, 20);
        return p;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setOverrideEditorStyles(this.overrideCheckBox.isSelected());
        if (this.overrideCheckBox.isSelected()) {
            mainView.setCurrentLineHighlightColor(this.currentLineColorButton.getColor());
            mainView.setMarkAllHighlightColor(this.markAllColorButton.getColor());
            mainView.setMarkOccurrences(this.enableMOCheckBox.isSelected());
            mainView.setMarkOccurrencesColor(this.moColorButton.getColor());
            mainView.setHighlightSecondaryLanguages(this.secLangCB.isSelected());
            for (int i = 0; i < 3; ++i) {
                mainView.setSecondaryLanguageColor(i, this.secLangButtons[i].getColor());
            }
        } else {
            Theme editorTheme = EditorOptionsPreviewContext.get().getEditorTheme((AbstractGUIApplication<?>)rtext);
            mainView.setCurrentLineHighlightColor(editorTheme.currentLineHighlight);
            mainView.setMarkAllHighlightColor(editorTheme.markAllHighlightColor);
            mainView.setMarkOccurrences(true);
            mainView.setMarkOccurrencesColor(editorTheme.markOccurrencesColor);
            mainView.setHighlightSecondaryLanguages(this.secLangCB.isSelected());
            for (int i = 0; i < 3; ++i) {
                mainView.setSecondaryLanguageColor(i, editorTheme.secondaryLanguages[i]);
            }
        }
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    private static Color getColor(RColorSwatchesButton button) {
        return new Color(button.getColor().getRGB());
    }

    @Override
    protected void handleRestoreDefaults() {
        int i;
        RText app = (RText)((Object)this.getOptionsDialog().getParent());
        EditorOptionsPreviewContext editorContext = EditorOptionsPreviewContext.get();
        Theme rstaTheme = editorContext.getEditorTheme((AbstractGUIApplication<?>)app);
        Color defaultCurrentLineColor = rstaTheme.currentLineHighlight;
        Color defaultMarkAllColor = rstaTheme.markAllHighlightColor;
        Color defaultMarkOccurrencesColor = rstaTheme.markOccurrencesColor;
        Color[] defaultSecLangColor = new Color[3];
        for (i = 0; i < defaultSecLangColor.length; ++i) {
            if (rstaTheme.secondaryLanguages != null && rstaTheme.secondaryLanguages.length > i) {
                defaultSecLangColor[i] = rstaTheme.secondaryLanguages[i];
            }
            if (defaultSecLangColor[i] != null) continue;
            defaultSecLangColor[i] = DEFAULT_SECONDARY_LANGUAGE_COLORS[i];
        }
        if (!(!this.overrideCheckBox.isSelected() && this.currentLineColorButton.getColor().equals(defaultCurrentLineColor) && this.markAllColorButton.getColor().equals(defaultMarkAllColor) && this.enableMOCheckBox.isSelected() && this.moColorButton.getColor().equals(defaultMarkOccurrencesColor) && this.secLangCB.isSelected() && defaultSecLangColor[0].equals(this.secLangButtons[0].getColor()) && defaultSecLangColor[1].equals(this.secLangButtons[1].getColor()) && defaultSecLangColor[2].equals(this.secLangButtons[2].getColor()))) {
            this.overrideCheckBox.setSelected(false);
            this.currentLineColorButton.setColor(defaultCurrentLineColor);
            this.markAllColorButton.setColor(defaultMarkAllColor);
            this.enableMOCheckBox.setSelected(true);
            this.moColorButton.setEnabled(true);
            this.moColorButton.setColor(defaultMarkOccurrencesColor);
            this.setHighlightSecondaryLanguages(true);
            for (i = 0; i < 3; ++i) {
                this.secLangButtons[i].setColor(defaultSecLangColor[i]);
            }
            this.setDirty(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("RColorButton.colorChanged".equals(e.getPropertyName())) {
            this.setDirty(true);
        }
    }

    @Override
    protected void setComponentsEnabled(boolean enabled, Component ... ignore) {
        super.setComponentsEnabled(enabled, ignore);
        this.moColorButton.setEnabled(enabled && this.enableMOCheckBox.isSelected());
        boolean secondaryLanguagesConfigurable = enabled && this.secLangCB.isSelected();
        for (int i = 0; i < 3; ++i) {
            this.secLangLabels[i].setEnabled(secondaryLanguagesConfigurable);
            this.secLangButtons[i].setEnabled(secondaryLanguagesConfigurable);
        }
    }

    private void setHighlightSecondaryLanguages(boolean highlight) {
        this.secLangCB.setSelected(highlight);
        for (int i = 0; i < 3; ++i) {
            this.secLangLabels[i].setEnabled(highlight);
            this.secLangButtons[i].setEnabled(highlight);
        }
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.currentLineColorButton.setColor(mainView.getCurrentLineHighlightColor());
        this.markAllColorButton.setColor(mainView.getMarkAllHighlightColor());
        this.enableMOCheckBox.setSelected(mainView.getMarkOccurrences());
        this.moColorButton.setEnabled(this.enableMOCheckBox.isSelected());
        this.moColorButton.setColor(mainView.getMarkOccurrencesColor());
        this.setHighlightSecondaryLanguages(mainView.getHighlightSecondaryLanguages());
        for (int i = 0; i < 3; ++i) {
            this.secLangButtons[i].setColor(mainView.getSecondaryLanguageColor(i));
        }
        this.overrideCheckBox.setSelected(mainView.getOverrideEditorStyles());
        this.setComponentsEnabled(this.overrideCheckBox.isSelected(), new Component[0]);
        this.syncEditorOptionsPreviewContext();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setDirty(true);
    }

    @Override
    protected void syncEditorOptionsPreviewContext() {
        EditorOptionsPreviewContext context = EditorOptionsPreviewContext.get();
        context.setOverrideEditorTheme(this.overrideCheckBox.isSelected());
        context.setCurrentLineHighlightColor(this.currentLineColorButton.getColor());
        context.setMarkAllHighlightColor(this.markAllColorButton.getColor());
        context.setMarkOccurrences(this.enableMOCheckBox.isSelected());
        context.setMarkOccurrencesColor(this.moColorButton.getColor());
        context.setHighlightSecondaryLanguages(this.secLangCB.isSelected());
        for (int i = 0; i < 3; ++i) {
            context.setSecondaryLanguageBackground(i, this.secLangButtons[i].getColor());
        }
        context.possiblyFireChangeEventAndReset();
    }
}

