/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.fife.rtext.RTextAppThemes;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.AppTheme;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContextListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

final class PreviewPanel
extends JPanel
implements EditorOptionsPreviewContextListener,
PropertyChangeListener,
ActionListener {
    private JComboBox<String> sampleCombo;
    private RSyntaxTextArea textArea;
    private RTextScrollPane scrollPane;
    private AbstractGUIApplication<?> app;
    private ResourceBundle msg;
    private boolean firstTime;
    private static final String[] SAMPLE_LANGUAGES = new String[]{"Java", "JavaScript", "Perl", "PHP", "Ruby", "XML"};
    private static final String[] SAMPLES = new String[]{"previewJava.txt", "previewJavaScript.txt", "previewPerl.txt", "previewPhp.txt", "previewRuby.txt", "previewXml.txt"};
    private static final String[] SAMPLE_STYLES = new String[]{"text/java", "text/javascript", "text/perl", "text/php", "text/ruby", "text/xml"};
    static final String DEFAULT_PREVIEW_LANGUAGE = SAMPLE_LANGUAGES[0];

    PreviewPanel(ResourceBundle msg, int rows, int cols) {
        this.msg = msg;
        EditorOptionsPreviewContext.get().addListener(this);
        this.createUI(rows, cols);
        this.firstTime = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.sampleCombo == e.getSource()) {
            this.refreshDisplayedSample();
            EditorOptionsPreviewContext.get().setPreviewLanguage((String)this.sampleCombo.getSelectedItem());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.firstTime) {
            Window optionsDialog = SwingUtilities.getWindowAncestor(this);
            this.app = (AbstractGUIApplication)optionsDialog.getParent();
            this.app.addPropertyChangeListener("appTheme", (PropertyChangeListener)this);
            this.initializeForTheme(this.app.getTheme());
            this.firstTime = false;
        }
    }

    private static Box createHorizontalBox() {
        return new Box(2);
    }

    private void createUI(int rows, int cols) {
        this.setLayout(new BoxLayout(this, 3));
        this.putClientProperty("always.ignore", Boolean.TRUE);
        this.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(this.msg.getString("Preview")));
        Box horizBox = PreviewPanel.createHorizontalBox();
        JLabel sampleTextLabel = new JLabel(this.msg.getString("SampleTextLabel"));
        horizBox.add(sampleTextLabel);
        horizBox.add(Box.createHorizontalStrut(5));
        this.sampleCombo = new JComboBox<String>(SAMPLE_LANGUAGES);
        this.sampleCombo.setEditable(false);
        this.sampleCombo.addActionListener(this);
        horizBox.add(this.sampleCombo);
        horizBox.add(Box.createHorizontalGlue());
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)horizBox, "Before");
        this.add(temp);
        this.add(Box.createVerticalStrut(5));
        this.textArea = new RSyntaxTextArea(rows, cols);
        this.textArea.setSyntaxEditingStyle("text/java");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setPopupMenu(null);
        this.scrollPane = new RTextScrollPane((RTextArea)this.textArea);
        this.add((Component)this.scrollPane);
        this.add(Box.createVerticalStrut(3));
        this.refreshDisplayedSample();
    }

    @Override
    public void editorOptionsPreviewContextChanged(EditorOptionsPreviewContext context) {
        Theme editorTheme = context.getEditorTheme(this.app);
        Gutter gutter = this.scrollPane.getGutter();
        if (!Objects.equals(this.sampleCombo.getSelectedItem(), context.getPreviewLanguage())) {
            this.sampleCombo.setSelectedItem(context.getPreviewLanguage());
            this.refreshDisplayedSample();
        }
        this.scrollPane.setLineNumbersEnabled(context.getLineNumbersEnabled());
        this.textArea.setLineWrap(context.getWordWrap());
        this.textArea.setHighlightCurrentLine(context.getHighlightCurrentLine());
        this.textArea.setMarginLineEnabled(context.getMarginLineEnabled());
        this.textArea.setMarginLinePosition(context.getMarginLinePosition());
        this.textArea.setCloseCurlyBraces(context.getAutoInsertClosingCurly());
        this.textArea.setClearWhitespaceLinesEnabled(context.getClearWhitespaceLines());
        this.textArea.setAntiAliasingEnabled(context.getAntiAliasingEnabled());
        this.textArea.setFractionalFontMetricsEnabled(context.getFractionalFontMetricsEnabled());
        this.textArea.setBracketMatchingEnabled(context.getHighlightMatchingBrackets());
        this.textArea.setPaintMatchedBracketPair(context.getHighlightBothBrackets());
        gutter.setFoldIndicatorStyle(context.getFoldIndicatorStyle());
        this.textArea.setFont(context.getFont());
        this.textArea.setForeground(context.getFontColor());
        this.textArea.setTabSize(context.getTabSize());
        this.textArea.setTabsEmulated(context.getEmulateTabs());
        this.textArea.setWhitespaceVisible(context.getShowWhitespace());
        this.textArea.setEOLMarkersVisible(context.getShowEolMarkers());
        this.textArea.setPaintTabLines(context.getShowIndentGuides());
        if (context.getOverrideEditorTheme()) {
            this.textArea.setBackgroundObject((Object)context.getBackgroundColor());
            this.textArea.setSyntaxScheme(context.getSyntaxScheme());
        } else {
            this.textArea.setBackgroundObject((Object)editorTheme.bgColor);
            this.textArea.setSyntaxScheme(editorTheme.scheme);
        }
        if (context.getOverrideEditorTheme()) {
            this.textArea.setCaretStyle(0, context.getInsertCaret());
            this.textArea.setCaretStyle(1, context.getOverwriteCaret());
            this.textArea.setCaretColor(context.getCaretColor());
            this.textArea.getCaret().setBlinkRate(context.getCaretBlinkRate());
            this.textArea.setSelectionColor(context.getSelectionColor());
            this.textArea.setSelectedTextColor(context.getSelectedTextColor());
            this.textArea.setUseSelectedTextColor(context.getUseSelectedTextColor());
        } else {
            this.textArea.setCaretStyle(0, CaretStyle.THICK_VERTICAL_LINE_STYLE);
            this.textArea.setCaretStyle(1, CaretStyle.BLOCK_STYLE);
            this.textArea.setCaretColor(editorTheme.caretColor);
            this.textArea.getCaret().setBlinkRate(500);
            this.textArea.setSelectionColor(editorTheme.selectionBG);
            this.textArea.setSelectedTextColor(editorTheme.selectionFG);
            this.textArea.setUseSelectedTextColor(editorTheme.useSelectionFG);
        }
        if (context.getOverrideEditorTheme()) {
            if (context.getCurrentLineHighlightColor() != null) {
                this.textArea.setCurrentLineHighlightColor(context.getCurrentLineHighlightColor());
            }
            this.textArea.setMarkAllHighlightColor(context.getMarkAllHighlightColor());
            this.textArea.setMarkOccurrences(context.getMarkOccurrences());
            this.textArea.setMarkOccurrencesColor(context.getMarkOccurrencesColor());
            this.textArea.setHighlightSecondaryLanguages(context.getHighlightSecondaryLanguages());
            for (int i = 0; i < this.textArea.getSecondaryLanguageCount(); ++i) {
                this.textArea.setSecondaryLanguageBackground(i + 1, context.getSecondaryLanguageBackground(i));
            }
        } else {
            this.textArea.setCurrentLineHighlightColor(editorTheme.currentLineHighlight);
            this.textArea.setMarkAllHighlightColor(editorTheme.markAllHighlightColor);
            this.textArea.setMarkOccurrences(true);
            this.textArea.setMarkOccurrencesColor(editorTheme.markOccurrencesColor);
            this.textArea.setHighlightSecondaryLanguages(true);
            for (int i = 0; i < this.textArea.getSecondaryLanguageCount(); ++i) {
                this.textArea.setSecondaryLanguageBackground(i + 1, editorTheme.secondaryLanguages[i]);
            }
        }
        if (context.getOverrideEditorTheme()) {
            gutter.setLineNumberFont(context.getLineNumberFont());
            gutter.setLineNumberColor(context.getLineNumberColor());
            gutter.setFoldIndicatorForeground(context.getFoldForeground());
            gutter.setFoldIndicatorArmedForeground(context.getArmedFoldForeground());
            gutter.setFoldBackground(context.getFoldBackground());
            gutter.setArmedFoldBackground(context.getArmedFoldBackground());
        } else {
            gutter.setLineNumberFont(RTextArea.getDefaultFont());
            gutter.setLineNumberColor(editorTheme.lineNumberColor);
            gutter.setFoldIndicatorForeground(editorTheme.foldIndicatorFG);
            gutter.setFoldIndicatorArmedForeground(editorTheme.foldIndicatorArmedFG);
            gutter.setFoldBackground(editorTheme.foldBG);
            gutter.setArmedFoldBackground(editorTheme.armedFoldBG);
        }
    }

    private void initializeForTheme(AppTheme theme) {
        try {
            Theme rstaTheme = RTextAppThemes.getRstaTheme(theme, this.textArea.getFont());
            rstaTheme.apply(this.textArea);
        }
        catch (IOException ioe) {
            this.app.displayException((Throwable)ioe);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("appTheme".equals(propertyName)) {
            this.initializeForTheme((AppTheme)e.getNewValue());
        }
    }

    private void refreshDisplayedSample() {
        int index = this.sampleCombo.getSelectedIndex();
        if (index < 0 || index > SAMPLES.length) {
            index = 0;
        }
        InputStream in = this.getClass().getResourceAsStream(SAMPLES[index]);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            this.textArea.read((Reader)br, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.textArea.setCaretPosition(0);
        this.textArea.setSyntaxEditingStyle(SAMPLE_STYLES[index]);
        this.textArea.discardAllEdits();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.app.removePropertyChangeListener("appTheme", (PropertyChangeListener)this);
        this.app = null;
    }
}

