/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.FontSelector;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.rsyntaxtextarea.AbstractTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContextListener;
import org.fife.ui.rsyntaxtextarea.PreviewPanel;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;

public class RSyntaxTextAreaOptionPanel
extends AbstractTextAreaOptionPanel
implements PropertyChangeListener,
ListSelectionListener,
EditorOptionsPreviewContextListener {
    public static final String OPTION_PANEL_ID = "RTextAreaOptionPanel";
    private RColorSwatchesButton mainBackgroundButton;
    private JList<String> syntaxList;
    private FontSelector fontSelector;
    private RColorSwatchesButton foregroundButton;
    private JCheckBox fgCheckBox;
    private JCheckBox bgCheckBox;
    private RColorSwatchesButton backgroundButton;
    private SyntaxScheme colorScheme;
    private boolean isSettingStyle;

    public RSyntaxTextAreaOptionPanel() {
        this.setId(OPTION_PANEL_ID);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setName(MSG.getString("Title.SyntaxHighlighting"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box cp = Box.createVerticalBox();
        this.add(cp, "North");
        cp.add(this.createOverridePanel());
        cp.add(Box.createVerticalStrut(5));
        cp.add(this.createBackgroundPanel(orientation));
        cp.add(Box.createVerticalStrut(5));
        cp.add(this.createSyntaxPanel(orientation));
        cp.add(Box.createVerticalStrut(5));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(new PreviewPanel(MSG, 9, 40));
        bottomPanel.add((Component)this.createRestoreDefaultsPanel(), "South");
        cp.add(bottomPanel);
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("fgCheckBox".equals(command) && !this.isSettingStyle) {
            boolean selected = this.fgCheckBox.isSelected();
            this.foregroundButton.setEnabled(selected);
            int i = this.syntaxList.getSelectedIndex();
            this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).foreground = selected ? this.foregroundButton.getColor() : null;
            this.setDirty(true);
        } else if ("bgCheckBox".equals(command) && !this.isSettingStyle) {
            boolean selected = this.bgCheckBox.isSelected();
            this.backgroundButton.setEnabled(selected);
            int i = this.syntaxList.getSelectedIndex();
            this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).background = selected ? this.backgroundButton.getColor() : null;
            this.setDirty(true);
        } else {
            super.actionPerformed(e);
        }
    }

    private JComponent createBackgroundPanel(ComponentOrientation orientation) {
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("Background")));
        JLabel bgLabel = new JLabel(MSG.getString("Background"));
        this.mainBackgroundButton = new RColorSwatchesButton();
        this.mainBackgroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        bgLabel.setLabelFor((Component)this.mainBackgroundButton);
        JPanel bgRestPanel = new JPanel(new BorderLayout());
        bgRestPanel.add((Component)this.mainBackgroundButton, "Before");
        UIUtil.addLabelValuePairs((Container)springPanel, (ComponentOrientation)orientation, (Component[])new Component[]{bgLabel, bgRestPanel});
        UIUtil.makeSpringCompactGrid((Container)springPanel, (int)1, (int)2, (int)0, (int)0, (int)5, (int)5);
        return springPanel;
    }

    private JPanel createSyntaxPanel(ComponentOrientation orientation) {
        JPanel syntaxPanel = new JPanel(new BorderLayout());
        syntaxPanel.setBorder(BorderFactory.createCompoundBorder((Border)new OptionsDialogPanel.OptionPanelBorder(MSG.getString("FontsAndColors")), BorderFactory.createEmptyBorder(5, 0, 0, 0)));
        DefaultListModel<Object> syntaxListModel = new DefaultListModel<Object>();
        this.syntaxList = new JList(syntaxListModel);
        this.syntaxList.setSelectionModel((ListSelectionModel)new RListSelectionModel());
        this.syntaxList.addListSelectionListener(this);
        this.syntaxList.setVisibleRowCount(8);
        syntaxListModel.addElement(MSG.getString("Style.Comment.EndOfLine"));
        syntaxListModel.addElement(MSG.getString("Style.Comment.Multiline"));
        syntaxListModel.addElement(MSG.getString("Style.Comment.Documentation"));
        syntaxListModel.addElement(MSG.getString("Style.Comment.Keyword"));
        syntaxListModel.addElement(MSG.getString("Style.Comment.Markup"));
        syntaxListModel.addElement(MSG.getString("Style.ReservedWord"));
        syntaxListModel.addElement(MSG.getString("Style.ReservedWord2"));
        syntaxListModel.addElement(MSG.getString("Style.Function"));
        syntaxListModel.addElement(MSG.getString("Style.Literal.Boolean"));
        syntaxListModel.addElement(MSG.getString("Style.Literal.Integer"));
        syntaxListModel.addElement(MSG.getString("Style.Literal.Float"));
        syntaxListModel.addElement(MSG.getString("Style.Literal.Hex"));
        syntaxListModel.addElement(MSG.getString("Style.Literal.String"));
        syntaxListModel.addElement(MSG.getString("Style.Literal.Char"));
        syntaxListModel.addElement(MSG.getString("Style.Literal.Backquote"));
        syntaxListModel.addElement(MSG.getString("Style.DataType"));
        syntaxListModel.addElement(MSG.getString("Style.Variable"));
        syntaxListModel.addElement(MSG.getString("Style.RegularExpression"));
        syntaxListModel.addElement(MSG.getString("Style.Annotation"));
        syntaxListModel.addElement("<html><b>" + MSG.getString("Style.Identifier.PlainText"));
        syntaxListModel.addElement(MSG.getString("Style.Whitespace"));
        syntaxListModel.addElement(MSG.getString("Style.Separator"));
        syntaxListModel.addElement(MSG.getString("Style.Operator"));
        syntaxListModel.addElement(MSG.getString("Style.Preprocessor"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.Delimiter"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.TagName"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.Attribute"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.AttributeValue"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.Comment"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.DTD"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.ProcessingInstruction"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.CDataDelimiter"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.CData"));
        syntaxListModel.addElement(MSG.getString("Style.MarkupTag.EntityReference"));
        syntaxListModel.addElement(MSG.getString("Style.Error.Identifier"));
        syntaxListModel.addElement(MSG.getString("Style.Error.Number"));
        syntaxListModel.addElement(MSG.getString("Style.Error.String"));
        syntaxListModel.addElement(MSG.getString("Style.Error.Char"));
        syntaxPanel.add((Component)new RScrollPane(this.syntaxList), "Before");
        Box propertiesPanel = Box.createVerticalBox();
        this.fontSelector = new FontSelector(2);
        this.fontSelector.setUnderlineSelectable(true);
        this.fontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        this.fontSelector.addPropertyChangeListener("toggledOn", (PropertyChangeListener)this);
        this.fontSelector.putClientProperty((Object)"always.ignore", (Object)Boolean.TRUE);
        Box temp = this.createHorizontalBox();
        temp.add((Component)this.fontSelector);
        temp.add(Box.createHorizontalStrut(5));
        propertiesPanel.add(temp);
        propertiesPanel.add(Box.createVerticalStrut(8));
        temp = this.createHorizontalBox();
        this.fgCheckBox = new JCheckBox(MSG.getString("Foreground"));
        this.fgCheckBox.setActionCommand("fgCheckBox");
        this.fgCheckBox.addActionListener(this);
        this.foregroundButton = new RColorSwatchesButton(Color.BLACK);
        this.foregroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        this.foregroundButton.putClientProperty((Object)"always.ignore", (Object)Boolean.TRUE);
        temp.add(this.fgCheckBox);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.foregroundButton);
        temp.add(Box.createHorizontalGlue());
        this.addLeftAligned(propertiesPanel, temp, 8);
        temp = this.createHorizontalBox();
        this.bgCheckBox = new JCheckBox(MSG.getString("Background"));
        this.bgCheckBox.setActionCommand("bgCheckBox");
        this.bgCheckBox.addActionListener(this);
        this.backgroundButton = new RColorSwatchesButton(Color.BLACK);
        this.backgroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        this.backgroundButton.putClientProperty((Object)"always.ignore", (Object)Boolean.TRUE);
        temp.add(this.bgCheckBox);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.backgroundButton);
        temp.add(Box.createHorizontalGlue());
        this.addLeftAligned(propertiesPanel, temp);
        propertiesPanel.add(Box.createVerticalGlue());
        JPanel temp2 = new JPanel(new BorderLayout());
        if (orientation.isLeftToRight()) {
            temp2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        } else {
            temp2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        temp2.add((Component)propertiesPanel, "North");
        syntaxPanel.add(temp2);
        return syntaxPanel;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setOverrideEditorStyles(this.overrideCheckBox.isSelected());
        if (this.overrideCheckBox.isSelected()) {
            mainView.setTextAreaBackgroundColor(this.mainBackgroundButton.getColor());
            rtext.setSyntaxScheme(this.colorScheme);
        } else {
            Theme editorTheme = EditorOptionsPreviewContext.get().getEditorTheme((AbstractGUIApplication<?>)rtext);
            mainView.setTextAreaBackgroundColor(editorTheme.bgColor);
            rtext.setSyntaxScheme(editorTheme.scheme);
        }
    }

    @Override
    protected void editorOptionsPreviewContextChangedImpl(EditorOptionsPreviewContext context) {
        SyntaxScheme newScheme = context.getSyntaxScheme();
        if (!newScheme.equals((Object)this.colorScheme)) {
            this.setSyntaxScheme(newScheme);
            this.setDirty(true);
        }
        super.editorOptionsPreviewContextChangedImpl(context);
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    @Override
    protected void handleRestoreDefaults() {
        RText app = (RText)((Object)this.getOptionsDialog().getParent());
        EditorOptionsPreviewContext editorContext = EditorOptionsPreviewContext.get();
        Theme rstaTheme = editorContext.getEditorTheme((AbstractGUIApplication<?>)app);
        Color defaultBackground = rstaTheme.bgColor;
        SyntaxScheme currentScheme = this.colorScheme;
        SyntaxScheme defaultScheme = rstaTheme.scheme;
        if (this.overrideCheckBox.isSelected() || !defaultBackground.equals(this.mainBackgroundButton.getColor()) || !currentScheme.equals((Object)defaultScheme)) {
            this.overrideCheckBox.setSelected(false);
            this.mainBackgroundButton.setColor(defaultBackground);
            this.setSyntaxScheme(defaultScheme);
            this.setDirty(true);
            this.valueChanged(null);
            this.setComponentsEnabled(false, new Component[0]);
        }
    }

    private static int indexToStyle(int index) {
        return index + 1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.isSettingStyle) {
            return;
        }
        Object source = e.getSource();
        if (source == this.fontSelector && this.colorScheme != null) {
            int i = this.syntaxList.getSelectedIndex();
            Style style = this.colorScheme.getStyle(RSyntaxTextAreaOptionPanel.indexToStyle(i));
            style.fontMetrics = null;
            if (this.fontSelector.isToggledOn()) {
                style.font = this.fontSelector.getDisplayedFont();
                style.underline = this.fontSelector.getUnderline();
            } else {
                style.font = null;
                style.underline = false;
            }
            this.setDirty(true);
        } else if (source == this.foregroundButton && this.colorScheme != null) {
            Color fg = null;
            if (this.foregroundButton.isEnabled()) {
                fg = this.foregroundButton.getColor();
            }
            if (!this.isSettingStyle) {
                int i = this.syntaxList.getSelectedIndex();
                this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).foreground = fg;
                this.setDirty(true);
            }
        } else if (source == this.backgroundButton && this.colorScheme != null) {
            Color bg = this.backgroundButton.isEnabled() ? this.backgroundButton.getColor() : this.mainBackgroundButton.getColor();
            if (!this.isSettingStyle) {
                int i = this.syntaxList.getSelectedIndex();
                this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).background = bg;
                this.setDirty(true);
            }
        } else {
            this.setDirty(true);
        }
    }

    @Override
    protected void setComponentsEnabled(boolean enabled, Component ... ignore) {
        super.setComponentsEnabled(enabled, ignore);
        this.fontSelector.setEnabled(enabled);
        this.foregroundButton.setEnabled(enabled && this.fgCheckBox.isSelected());
        this.backgroundButton.setEnabled(enabled && this.bgCheckBox.isSelected());
    }

    public void setSyntaxScheme(SyntaxScheme ss) {
        this.colorScheme = (SyntaxScheme)ss.clone();
        this.syntaxList.setSelectedIndex(0);
        this.valueChanged(null);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.mainBackgroundButton.setColor(mainView.getTextAreaBackgroundColor());
        this.setSyntaxScheme(rtext.getSyntaxScheme());
        this.overrideCheckBox.setSelected(mainView.getOverrideEditorStyles());
        this.setComponentsEnabled(this.overrideCheckBox.isSelected(), new Component[0]);
        this.syncEditorOptionsPreviewContext();
    }

    @Override
    protected void syncEditorOptionsPreviewContext() {
        EditorOptionsPreviewContext context = EditorOptionsPreviewContext.get();
        context.setOverrideEditorTheme(this.overrideCheckBox.isSelected());
        context.setBackgroundColor(this.mainBackgroundButton.getColor());
        context.setSyntaxScheme((SyntaxScheme)this.colorScheme.clone());
        context.possiblyFireChangeEventAndReset();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean underline;
        Font font;
        int index = this.syntaxList.getSelectedIndex();
        index = RSyntaxTextAreaOptionPanel.indexToStyle(index);
        this.isSettingStyle = true;
        Style style = this.colorScheme.getStyle(index);
        if (style.font != null) {
            font = style.font;
            underline = style.underline;
        } else {
            font = EditorOptionsPreviewContext.get().getFont();
            underline = false;
        }
        this.fontSelector.setToggledOn(style.font != null);
        this.fontSelector.setDisplayedFont(font, underline);
        boolean notNull = style.foreground != null;
        this.fgCheckBox.setSelected(notNull);
        this.foregroundButton.setEnabled(notNull);
        this.foregroundButton.setColor(notNull ? style.foreground : EditorOptionsPreviewContext.get().getFontColor());
        notNull = style.background != null;
        this.bgCheckBox.setSelected(notNull);
        this.backgroundButton.setEnabled(notNull);
        if (notNull) {
            this.backgroundButton.setColor(style.background);
        } else {
            this.backgroundButton.setColor(this.mainBackgroundButton.getColor());
        }
        this.isSettingStyle = false;
    }
}

