/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.AbstractTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.PreviewPanel;
import org.fife.ui.rtextarea.FoldIndicatorStyle;
import org.fife.ui.rtextarea.RTextArea;

public class RTextAreaOptionPanel
extends AbstractTextAreaOptionPanel
implements DocumentListener,
PropertyChangeListener {
    public static final String OPTION_PANEL_ID = "RTextAreaOptionPanel";
    private JCheckBox lnEnabledCB;
    private JCheckBox wordWrapCheckBox;
    private JCheckBox highlightCurrentLineCheckBox;
    private JCheckBox marginLineCheckBox;
    private JTextField marginLinePositionField;
    private int marginLinePosition;
    private JCheckBox remWhitespaceLinesCheckBox;
    private JCheckBox autoInsertClosingCurlyCheckBox;
    private JCheckBox aaCheckBox;
    private JCheckBox fractionalMetricsCheckBox;
    private JCheckBox bracketMatchCheckBox;
    private JCheckBox bothBracketsCB;
    private LabelValueComboBox<String, FoldIndicatorStyle> foldIndicatorStyleCombo;

    public RTextAreaOptionPanel() {
        this.setId(OPTION_PANEL_ID);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setName(MSG.getString("Title"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        topPanel.add(this.createGeneralPanel());
        topPanel.add(Box.createVerticalStrut(5));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(new PreviewPanel(MSG, 9, 40));
        bottomPanel.add((Component)this.createRestoreDefaultsPanel(), "South");
        topPanel.add(bottomPanel);
        this.add(topPanel, "North");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Object source = e.getSource();
        if ("ShowLineNumbers".equals(command)) {
            this.setDirty(true);
        } else if ("WordWrap".equals(command)) {
            this.setDirty(true);
        } else if ("HighlightCL".equals(command)) {
            this.setDirty(true);
        } else if ("EmulateTabsCheckBox".equals(command)) {
            this.setDirty(true);
        } else if ("MarginLineCheckBox".equals(command)) {
            this.marginLinePositionField.setEnabled(this.marginLineCheckBox.isSelected());
            this.setDirty(true);
        } else if ("VisibleWhitespace".equals(command)) {
            this.setDirty(true);
        } else if ("VisibleEOL".equals(command)) {
            this.setDirty(true);
        } else if (!"AutoIndent".equals(command)) {
            if ("RemWhitespaceLines".equals(command)) {
                this.setDirty(true);
            } else if ("AutoCloseCurlys".equals(command)) {
                this.setDirty(true);
            } else if ("aaCB".equals(command)) {
                this.setDirty(true);
            } else if ("FracFM".equals(command)) {
                this.setDirty(true);
            } else if ("BracketMatchCheckBox".equals(command)) {
                this.bothBracketsCB.setEnabled(this.bracketMatchCheckBox.isSelected());
                this.setDirty(true);
            } else if ("BothBracketsCB".equals(command)) {
                this.setDirty(true);
            } else if ("ShowIndentGuide".equals(command)) {
                this.setDirty(true);
            } else if (this.foldIndicatorStyleCombo == source) {
                this.setDirty(true);
            } else {
                super.actionPerformed(e);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private JCheckBox createCheckBox(String key) {
        JCheckBox cb = new JCheckBox(MSG.getString(key));
        cb.setActionCommand(key);
        cb.addActionListener(this);
        return cb;
    }

    private Container createGeneralPanel() {
        Box generalPanel = Box.createVerticalBox();
        generalPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(this.getString("OptGenTitle")));
        this.lnEnabledCB = this.createCheckBox("ShowLineNumbers");
        this.addLeftAligned(generalPanel, this.lnEnabledCB, 3);
        this.wordWrapCheckBox = this.createCheckBox("WordWrap");
        this.addLeftAligned(generalPanel, this.wordWrapCheckBox, 3);
        this.highlightCurrentLineCheckBox = this.createCheckBox("HighlightCL");
        this.addLeftAligned(generalPanel, this.highlightCurrentLineCheckBox, 3);
        Box otherPanel = new Box(2);
        this.marginLineCheckBox = new JCheckBox(MSG.getString("DrawML"));
        this.marginLineCheckBox.setActionCommand("MarginLineCheckBox");
        this.marginLineCheckBox.addActionListener(this);
        this.marginLinePositionField = new JTextField();
        this.marginLinePositionField.getDocument().addDocumentListener(this);
        Dimension size = new Dimension(40, this.marginLinePositionField.getPreferredSize().height);
        this.marginLinePositionField.setMaximumSize(size);
        this.marginLinePositionField.setPreferredSize(size);
        otherPanel.add(this.marginLineCheckBox);
        otherPanel.add(this.marginLinePositionField);
        otherPanel.add(Box.createHorizontalGlue());
        this.addLeftAligned(generalPanel, otherPanel, 3);
        this.autoInsertClosingCurlyCheckBox = this.createCheckBox("AutoCloseCurlys");
        this.addLeftAligned(generalPanel, this.autoInsertClosingCurlyCheckBox, 3);
        this.remWhitespaceLinesCheckBox = this.createCheckBox("RemWhitespaceLines");
        this.addLeftAligned(generalPanel, this.remWhitespaceLinesCheckBox, 3);
        this.aaCheckBox = new JCheckBox(MSG.getString("SmoothText"));
        this.aaCheckBox.setActionCommand("aaCB");
        this.aaCheckBox.addActionListener(this);
        this.addLeftAligned(generalPanel, this.aaCheckBox, 3);
        this.fractionalMetricsCheckBox = this.createCheckBox("FracFM");
        this.addLeftAligned(generalPanel, this.fractionalMetricsCheckBox, 3);
        Box bracketMatchingPanel = this.createHorizontalBox();
        this.bracketMatchCheckBox = new JCheckBox(MSG.getString("HighlightMB"));
        this.bracketMatchCheckBox.setActionCommand("BracketMatchCheckBox");
        this.bracketMatchCheckBox.addActionListener(this);
        bracketMatchingPanel.add(this.bracketMatchCheckBox);
        bracketMatchingPanel.add(Box.createHorizontalGlue());
        this.addLeftAligned(generalPanel, bracketMatchingPanel, 3);
        this.bothBracketsCB = new JCheckBox(MSG.getString("HighlightBothBrackets"));
        this.bothBracketsCB.setActionCommand("BothBracketsCB");
        this.bothBracketsCB.addActionListener(this);
        this.addLeftAligned(generalPanel, this.bothBracketsCB, 3, 20);
        this.foldIndicatorStyleCombo = new LabelValueComboBox();
        String label = MSG.getString("FoldIconStyle.Modern");
        this.foldIndicatorStyleCombo.addLabelValuePair((Object)label, (Object)FoldIndicatorStyle.MODERN);
        label = MSG.getString("FoldIconStyle.Classic");
        this.foldIndicatorStyleCombo.addLabelValuePair((Object)label, (Object)FoldIndicatorStyle.CLASSIC);
        this.foldIndicatorStyleCombo.addActionListener((ActionListener)this);
        JLabel foldStyleLabel = UIUtil.newLabel((ResourceBundle)MSG, (String)"FoldIconStyle", this.foldIndicatorStyleCombo);
        Box temp = this.createHorizontalBox();
        temp.add(foldStyleLabel);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.foldIndicatorStyleCombo);
        temp.add(Box.createHorizontalGlue());
        this.addLeftAligned(generalPanel, temp);
        return generalPanel;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setLineNumbersEnabled(this.lnEnabledCB.isSelected());
        mainView.setLineWrap(this.wordWrapCheckBox.isSelected());
        rtext.setRowColumnIndicatorVisible(!mainView.getLineWrap());
        mainView.setCurrentLineHighlightEnabled(this.highlightCurrentLineCheckBox.isSelected());
        mainView.setMarginLineEnabled(this.marginLineCheckBox.isSelected());
        mainView.setMarginLinePosition(this.getMarginLinePosition());
        mainView.setRememberWhitespaceLines(!this.remWhitespaceLinesCheckBox.isSelected());
        mainView.setAutoInsertClosingCurlys(this.autoInsertClosingCurlyCheckBox.isSelected());
        mainView.setAntiAliasEnabled(this.aaCheckBox.isSelected());
        mainView.setFractionalFontMetricsEnabled(this.fractionalMetricsCheckBox.isSelected());
        mainView.setBracketMatchingEnabled(this.bracketMatchCheckBox.isSelected());
        mainView.setMatchBothBrackets(this.bothBracketsCB.isSelected());
        mainView.setFoldIndicatorStyle((FoldIndicatorStyle)this.foldIndicatorStyleCombo.getSelectedValue());
    }

    private void doDocumentUpdated() {
        this.setDirty(true);
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        int temp;
        try {
            temp = Integer.parseInt(this.marginLinePositionField.getText());
            if (temp < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            OptionsDialogPanel.OptionsPanelCheckResult res = new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this);
            res.errorMessage = "Invalid margin line position;\nPlease input a position greater than zero.";
            res.component = this.marginLinePositionField;
            this.marginLinePosition = -1;
            return res;
        }
        this.marginLinePosition = temp;
        return null;
    }

    public int getMarginLinePosition() {
        return this.marginLinePosition;
    }

    @Override
    public JComponent getTopJComponent() {
        return this.wordWrapCheckBox;
    }

    @Override
    protected void handleRestoreDefaults() {
        int defaultMarginLinePosition = RTextArea.getDefaultMarginLinePosition();
        boolean defaultAA = File.separatorChar == '\\';
        FoldIndicatorStyle defaultFoldIndicatorStyle = FoldIndicatorStyle.MODERN;
        if (!this.lnEnabledCB.isSelected() || this.wordWrapCheckBox.isSelected() || !this.highlightCurrentLineCheckBox.isSelected() || !this.marginLineCheckBox.isSelected() || this.getMarginLinePosition() != defaultMarginLinePosition || this.autoInsertClosingCurlyCheckBox.isSelected() || this.remWhitespaceLinesCheckBox.isSelected() || this.aaCheckBox.isSelected() != defaultAA || this.fractionalMetricsCheckBox.isSelected() || !this.bracketMatchCheckBox.isSelected() || !this.bothBracketsCB.isSelected() || !defaultFoldIndicatorStyle.equals(this.foldIndicatorStyleCombo.getSelectedValue())) {
            this.lnEnabledCB.setSelected(true);
            this.wordWrapCheckBox.setSelected(false);
            this.highlightCurrentLineCheckBox.setSelected(true);
            this.setMarginLineEnabled(true);
            this.setMarginLinePosition(defaultMarginLinePosition);
            this.autoInsertClosingCurlyCheckBox.setSelected(false);
            this.remWhitespaceLinesCheckBox.setSelected(false);
            this.aaCheckBox.setSelected(defaultAA);
            this.fractionalMetricsCheckBox.setSelected(false);
            this.setBracketMatchCheckboxSelected(true);
            this.bothBracketsCB.setSelected(true);
            this.foldIndicatorStyleCombo.setSelectedValue((Object)defaultFoldIndicatorStyle);
            this.setDirty(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doDocumentUpdated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.setDirty(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doDocumentUpdated();
    }

    public void setBracketMatchCheckboxSelected(boolean selected) {
        this.bracketMatchCheckBox.setSelected(selected);
        this.bothBracketsCB.setEnabled(selected);
    }

    private void setMarginLineEnabled(boolean enabled) {
        this.marginLineCheckBox.setSelected(enabled);
        this.marginLinePositionField.setEnabled(enabled);
    }

    private void setMarginLinePosition(int position) {
        if (this.marginLinePosition != position && position > 0) {
            this.marginLinePosition = position;
        }
        this.marginLinePositionField.setText(Integer.toString(this.marginLinePosition));
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        EditorOptionsPreviewContext previewContext = EditorOptionsPreviewContext.get();
        if (previewContext.getSyntaxScheme() == null) {
            previewContext.initialize(rtext);
        }
        AbstractMainView mainView = rtext.getMainView();
        this.lnEnabledCB.setSelected(mainView.getLineNumbersEnabled());
        this.wordWrapCheckBox.setSelected(mainView.getLineWrap());
        this.highlightCurrentLineCheckBox.setSelected(mainView.isCurrentLineHighlightEnabled());
        this.setMarginLineEnabled(mainView.isMarginLineEnabled());
        this.setMarginLinePosition(mainView.getMarginLinePosition());
        this.remWhitespaceLinesCheckBox.setSelected(!mainView.getRememberWhitespaceLines());
        this.autoInsertClosingCurlyCheckBox.setSelected(mainView.getAutoInsertClosingCurlys());
        this.aaCheckBox.setSelected(mainView.isAntiAliasEnabled());
        this.fractionalMetricsCheckBox.setSelected(mainView.isFractionalFontMetricsEnabled());
        this.setBracketMatchCheckboxSelected(mainView.isBracketMatchingEnabled());
        this.bothBracketsCB.setSelected(mainView.getMatchBothBrackets());
        this.foldIndicatorStyleCombo.setSelectedValue((Object)mainView.getFoldIndicatorStyle());
        this.syncEditorOptionsPreviewContext();
    }

    @Override
    protected void syncEditorOptionsPreviewContext() {
        EditorOptionsPreviewContext context = EditorOptionsPreviewContext.get();
        context.setLineNumbersEnabled(this.lnEnabledCB.isSelected());
        context.setWordWrap(this.wordWrapCheckBox.isSelected());
        context.setHighlightCurrentLine(this.highlightCurrentLineCheckBox.isSelected());
        context.setMarginLineEnabled(this.marginLineCheckBox.isSelected());
        context.setMarginLinePosition(this.getMarginLinePosition());
        context.setAutoInsertClosingCurly(this.autoInsertClosingCurlyCheckBox.isSelected());
        context.setClearWhitespaceLines(this.remWhitespaceLinesCheckBox.isSelected());
        context.setAntiAliasingEnabled(this.aaCheckBox.isSelected());
        context.setFractionalFontMetricsEnabled(this.fractionalMetricsCheckBox.isSelected());
        context.setHighlightMatchingBrackets(this.bracketMatchCheckBox.isSelected());
        context.setHighlightBothBrackets(this.bothBracketsCB.isSelected());
        FoldIndicatorStyle foldIndicatorStyle = (FoldIndicatorStyle)this.foldIndicatorStyleCombo.getSelectedValue();
        context.setFoldIndicatorStyle(foldIndicatorStyle);
        context.possiblyFireChangeEventAndReset();
    }
}

