/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.fife.ui.EscapableDialog;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.PickyDocumentFilter;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;
import org.fife.ui.modifiabletable.ModifiableTable;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.modifiabletable.RowHandler;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;
import org.fife.ui.rsyntaxtextarea.templates.StaticCodeTemplate;
import org.fife.ui.rtextarea.RTextArea;

public class TemplateOptionPanel
extends OptionsDialogPanel {
    private ModifiableTable templateTable;
    private DefaultTableModel tableModel;
    private ResourceBundle msg;

    public TemplateOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.TemplateOptionPanel");
        this.setName(this.msg.getString("Title"));
        Listener listener = new Listener();
        this.setLayout(new BorderLayout());
        this.setBorder(UIUtil.getEmpty5Border());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(this.msg.getString("Templates")));
        this.add(contentPane);
        this.tableModel = new DefaultTableModel(new Object[]{this.msg.getString("Template"), this.msg.getString("Expansion")}, 0);
        this.templateTable = new ModifiableTable(this.tableModel);
        JTable table = this.templateTable.getTable();
        table.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.templateTable.addModifiableTableListener((ModifiableTableListener)listener);
        contentPane.add((Component)this.templateTable);
        this.applyComponentOrientation(orientation);
        SwingUtilities.invokeLater(() -> {
            TemplateDialog rowHandler = new TemplateDialog();
            this.templateTable.setRowHandler((RowHandler)rowHandler);
        });
    }

    protected void doApplyImpl(Frame owner) {
        this.updateCodeTemplateManager();
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public JComponent getTopJComponent() {
        return this.templateTable.getTable();
    }

    private void setTemplates(CodeTemplateManager manager) {
        this.tableModel.setRowCount(0);
        if (manager != null) {
            CodeTemplate[] templates;
            for (CodeTemplate template : templates = manager.getTemplates()) {
                this.tableModel.addRow(new Object[]{template.getID(), new TemplateWrapper((CodeTemplate)template.clone())});
            }
        }
    }

    protected void setValuesImpl(Frame owner) {
        CodeTemplateManager ctm = RSyntaxTextArea.getCodeTemplateManager();
        this.setTemplates(ctm);
    }

    private void updateCodeTemplateManager() {
        CodeTemplateManager ctm = RSyntaxTextArea.getCodeTemplateManager();
        if (ctm != null) {
            int count = this.tableModel.getRowCount();
            CodeTemplate[] templates = new CodeTemplate[count];
            for (int i = 0; i < count; ++i) {
                TemplateWrapper w = (TemplateWrapper)this.tableModel.getValueAt(i, 1);
                templates[i] = (CodeTemplate)w.template.clone();
            }
            ctm.replaceTemplates(templates);
        }
    }

    private final class Listener
    implements ModifiableTableListener {
        private Listener() {
        }

        public void modifiableTableChanged(ModifiableTableChangeEvent e) {
            TemplateOptionPanel.this.setDirty(true);
        }
    }

    private static class TemplateWrapper {
        private CodeTemplate template;

        TemplateWrapper(CodeTemplate template) {
            this.template = template;
        }

        public String toString() {
            StaticCodeTemplate template = (StaticCodeTemplate)this.template;
            String temp = template.getBeforeCaretText() + template.getAfterCaretText();
            return temp.replaceAll("\\n", "\\\\n").replaceAll("\\t", "\\\\t");
        }
    }

    class TemplateDialog
    extends EscapableDialog
    implements ActionListener,
    DocumentListener,
    RowHandler {
        private JTextField idField;
        private RTextArea bcTextArea;
        private RTextArea acTextArea;
        private JButton okButton;
        private JButton cancelButton;
        private char[] id;
        private String beforeCaret;
        private String afterCaret;

        TemplateDialog() {
            super((Window)TemplateOptionPanel.this.getOptionsDialog());
            ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
            ResizableFrameContentPane contentPane = new ResizableFrameContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.setBorder(UIUtil.getEmpty5Border());
            JLabel idLabel = UIUtil.newLabel((ResourceBundle)TemplateOptionPanel.this.msg, (String)"ID");
            this.idField = new JTextField(20);
            Document doc = this.idField.getDocument();
            doc.addDocumentListener(this);
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).setDocumentFilter((DocumentFilter)((Object)new TemplateNameDocumentFilter()));
            }
            idLabel.setLabelFor(this.idField);
            Box box = TemplateOptionPanel.this.createHorizontalBox();
            box.add(idLabel);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.idField);
            box.add(Box.createHorizontalGlue());
            contentPane.add((Component)box, "North");
            JPanel temp = new JPanel(new GridLayout(2, 1, 5, 5));
            temp.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            JLabel label = UIUtil.newLabel((ResourceBundle)TemplateOptionPanel.this.msg, (String)"BeforeCaret");
            this.bcTextArea = this.createTextArea();
            label.setLabelFor((Component)this.bcTextArea);
            RScrollPane sp = new RScrollPane((Component)this.bcTextArea);
            JPanel temp2 = new JPanel(new BorderLayout());
            temp2.add((Component)label, "North");
            temp2.add((Component)sp);
            temp.add(temp2);
            label = UIUtil.newLabel((ResourceBundle)TemplateOptionPanel.this.msg, (String)"AfterCaret");
            this.acTextArea = this.createTextArea();
            label.setLabelFor((Component)this.acTextArea);
            sp = new RScrollPane((Component)this.acTextArea);
            temp2 = new JPanel(new BorderLayout());
            temp2.add((Component)label, "North");
            temp2.add((Component)sp);
            temp.add(temp2);
            contentPane.add(temp);
            this.okButton = UIUtil.newButton((ResourceBundle)TemplateOptionPanel.this.msg, (String)"OK", (String)"OKMnemonic");
            this.okButton.addActionListener(this);
            this.okButton.setEnabled(false);
            this.cancelButton = UIUtil.newButton((ResourceBundle)TemplateOptionPanel.this.msg, (String)"Cancel", (String)"CancelMnemonic");
            this.cancelButton.addActionListener(this);
            Container buttons = UIUtil.createButtonFooter((JButton)this.okButton, (JButton)this.cancelButton);
            contentPane.add((Component)buttons, "South");
            this.setContentPane((Container)contentPane);
            this.setLocationRelativeTo((Component)((Object)TemplateOptionPanel.this));
            this.setModal(true);
            this.getRootPane().setDefaultButton(this.okButton);
            this.applyComponentOrientation(orientation);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
            Object source = e.getSource();
            if (source == this.okButton) {
                this.id = this.idField.getText().toCharArray();
                this.beforeCaret = this.bcTextArea.getText();
                this.afterCaret = this.acTextArea.getText();
            } else if (source == this.cancelButton) {
                this.id = null;
                this.afterCaret = null;
                this.beforeCaret = null;
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private RTextArea createTextArea() {
            JTextArea defaults = new JTextArea();
            RTextArea textArea = new RTextArea(4, 30);
            textArea.setHighlightCurrentLine(false);
            textArea.setBackground(defaults.getBackground());
            textArea.setForeground(defaults.getForeground());
            textArea.setCaretColor(defaults.getCaretColor());
            return textArea;
        }

        protected void escapePressed() {
            this.id = null;
            this.afterCaret = null;
            this.beforeCaret = null;
            this.setVisible(false);
        }

        public String getAfterCaretText() {
            return this.afterCaret;
        }

        public String getBeforeCaretText() {
            return this.beforeCaret;
        }

        public char[] getID() {
            return this.id;
        }

        public Object[] getNewRowInfo(Object[] oldData) {
            if (oldData == null) {
                this.setTitle(TemplateOptionPanel.this.msg.getString("AddTemplateTitle"));
                this.setID(null);
                this.setBeforeCaretText(null);
                this.setAfterCaretText(null);
            } else {
                this.setTitle(TemplateOptionPanel.this.msg.getString("ModifyTemplateTitle"));
                this.setID((String)oldData[0]);
                TemplateWrapper wrapper = (TemplateWrapper)oldData[1];
                StaticCodeTemplate template = (StaticCodeTemplate)wrapper.template;
                this.setBeforeCaretText(template.getBeforeCaretText());
                this.setAfterCaretText(template.getAfterCaretText());
            }
            this.setVisible(true);
            char[] id = this.getID();
            Object[] objs = null;
            if (id != null) {
                String idString = new String(id);
                StaticCodeTemplate template = new StaticCodeTemplate(idString, this.getBeforeCaretText(), this.getAfterCaretText());
                objs = new Object[]{idString, new TemplateWrapper((CodeTemplate)template)};
            }
            return objs;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!this.okButton.isEnabled()) {
                this.okButton.setEnabled(true);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            int length = this.idField.getDocument().getLength();
            if (length == 0) {
                this.okButton.setEnabled(false);
            }
        }

        public void setAfterCaretText(String text) {
            this.acTextArea.setText(text);
        }

        public void setBeforeCaretText(String text) {
            this.bcTextArea.setText(text);
        }

        public void setID(String id) {
            this.idField.setText(id);
        }

        public boolean canModifyRow(int row) {
            return true;
        }

        public boolean canRemoveRow(int row) {
            return true;
        }

        public void updateUI() {
            SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        }
    }

    private static final class TemplateNameDocumentFilter
    extends PickyDocumentFilter {
        private TemplateNameDocumentFilter() {
        }

        protected String cleanseImpl(String text) {
            int length = ((String)text).length();
            for (int i = 0; i < length; ++i) {
                if (RSyntaxUtilities.isLetterOrDigit((char)((String)text).charAt(i)) || ((String)text).charAt(i) == '_') continue;
                text = ((String)text).substring(0, i) + ((String)text).substring(i + 1);
                --i;
                --length;
            }
            return text;
        }
    }
}

