/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.AssistanceIconPanel;
import org.fife.rsta.ui.DecorativeIconPanel;
import org.fife.rsta.ui.RComboBoxModel;
import org.fife.rsta.ui.search.AbstractSearchDialog;
import org.fife.rsta.ui.search.FindReplaceButtonsEnableResult;
import org.fife.rtext.RText;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.FSATextField;
import org.fife.ui.RScrollPane;
import org.fife.ui.StatusBar;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextfilechooser.RDirectoryChooser;
import org.fife.ui.search.FindInFilesEvent;
import org.fife.ui.search.FindInFilesListener;
import org.fife.ui.search.FindInFilesSearchContext;
import org.fife.ui.search.FindInFilesTable;
import org.fife.ui.search.FindInFilesThread;
import org.fife.ui.search.MatchData;
import org.fife.ui.search.ResultsComponent;

public class FindInFilesDialog
extends AbstractSearchDialog {
    protected JComboBox<String> inFilesComboBox;
    protected FSATextField inFolderTextField;
    protected JComboBox<String> skipFoldersComboBox;
    protected JCheckBox subfoldersCheckBox;
    protected JButton findButton;
    private JButton browseButton;
    private JRadioButton matchingLinesRadioButton;
    protected JCheckBox verboseCheckBox;
    private StatusBar statusBar;
    private ResultsComponent resultsComponent;
    private String lastSearchString;
    private String lastInFilesString;
    private String lastSkipFoldersString;
    private EventListenerList eventListenerList;
    private FindInFilesThread workerThread;
    private FindInFilesDocumentListener docListener;
    private String defaultStatusText;
    private String searchingCompleteString;
    private DecorativeIconPanel inFilesDecorativeIconPanel;
    private DecorativeIconPanel inFolderDecorativeIconPanel;
    private DecorativeIconPanel skipFoldersDecorativeIconPanel;
    static final int DECORATIVE_ICON_WIDTH = 12;
    private static final String MSG_BUNDLE = "org.fife.ui.search.Search";
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.search.Search");

    public FindInFilesDialog(Frame owner) {
        super(owner);
        this.setTitle(this.getString2("FindInFilesDialogTitle"));
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.docListener = new FindInFilesDocumentListener();
        FindInFilesFocusAdapter focusAdapter = new FindInFilesFocusAdapter();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        JTextComponent textField = FindInFilesDialog.getTextComponent(this.findTextCombo);
        textField.addFocusListener(focusAdapter);
        textField.getDocument().addDocumentListener(this.docListener);
        this.inFilesComboBox = new JComboBox(new RComboBoxModel());
        this.inFilesComboBox.setEditable(true);
        textField = FindInFilesDialog.getTextComponent(this.inFilesComboBox);
        textField.addFocusListener(focusAdapter);
        textField.getDocument().addDocumentListener(this.docListener);
        this.inFolderTextField = new FSATextField();
        this.inFolderTextField.setText(System.getProperty("user.home"));
        this.inFolderTextField.addFocusListener((FocusListener)focusAdapter);
        this.inFolderTextField.getDocument().addDocumentListener(this.docListener);
        this.skipFoldersComboBox = new JComboBox(new RComboBoxModel());
        textField = FindInFilesDialog.getTextComponent(this.skipFoldersComboBox);
        textField.addFocusListener(focusAdapter);
        this.skipFoldersComboBox.addItem(FindInFilesDialog.getDefaultFoldersToSkip());
        this.skipFoldersComboBox.setSelectedIndex(0);
        this.skipFoldersComboBox.setEditable(true);
        JPanel inputPanel = this.createInputPanel();
        this.updateIcons();
        Box conditionsPanel = Box.createVerticalBox();
        conditionsPanel.setBorder(this.createTitledBorder(this.getString2("Conditions")));
        conditionsPanel.add(this.caseCheckBox);
        conditionsPanel.add(this.wholeWordCheckBox);
        conditionsPanel.add(this.regexCheckBox);
        Box detailEtcPanel = this.createDetailsPanel();
        Box bottomLeftPanel = new Box(2);
        bottomLeftPanel.add(conditionsPanel);
        bottomLeftPanel.add(Box.createHorizontalStrut(10));
        bottomLeftPanel.add(detailEtcPanel);
        bottomLeftPanel.add(Box.createHorizontalGlue());
        Box leftPanel = Box.createVerticalBox();
        leftPanel.add(inputPanel);
        leftPanel.add(bottomLeftPanel);
        JPanel rightPanel2 = new JPanel(new GridLayout(3, 1, 5, 5));
        this.findButton = UIUtil.newButton((ResourceBundle)this.getBundle(), (String)"Find");
        this.findButton.setActionCommand("FindInFiles");
        this.findButton.addActionListener((ActionListener)((Object)this));
        this.browseButton = UIUtil.newButton((ResourceBundle)MSG, (String)"Browse");
        this.browseButton.setActionCommand("Browse");
        this.browseButton.addActionListener((ActionListener)((Object)this));
        this.cancelButton = UIUtil.newButton((ResourceBundle)MSG, (String)"Close");
        this.cancelButton.setActionCommand("Close");
        this.cancelButton.addActionListener((ActionListener)((Object)this));
        rightPanel2.add(this.findButton);
        rightPanel2.add(this.browseButton);
        rightPanel2.add(this.cancelButton);
        JPanel rightPanel = new JPanel(new BorderLayout());
        if (orientation.isLeftToRight()) {
            rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        } else {
            rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        rightPanel.add((Component)rightPanel2, "North");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add(leftPanel);
        topPanel.add((Component)rightPanel, "After");
        Box extraOptionsPanel = this.createExtraOptionsPanel();
        JPanel resultsPanel = new JPanel(new GridLayout(1, 1, 3, 3));
        Border empty5Border = UIUtil.getEmpty5Border();
        resultsPanel.setBorder(BorderFactory.createCompoundBorder(empty5Border, BorderFactory.createCompoundBorder(this.createTitledBorder(this.getString2("Results")), BorderFactory.createEmptyBorder(3, 3, 3, 3))));
        this.resultsComponent = this.createResultsComponent();
        RScrollPane resultsScrollPane = new RScrollPane((Component)((JComponent)((Object)this.resultsComponent)));
        resultsScrollPane.setHorizontalScrollBarPolicy(32);
        resultsScrollPane.setVerticalScrollBarPolicy(22);
        resultsPanel.add((Component)resultsScrollPane);
        this.statusBar = new StatusBar();
        this.eventListenerList = new EventListenerList();
        this.defaultStatusText = this.getString2("DefaultStatusText");
        this.searchingCompleteString = this.getString2("SearchingComplete");
        this.setStatusText(this.defaultStatusText);
        Box temp = Box.createVerticalBox();
        temp.setBorder(empty5Border);
        temp.add(topPanel);
        temp.add(Box.createVerticalStrut(5));
        if (extraOptionsPanel != null) {
            temp.add(extraOptionsPanel);
        }
        contentPane.add((Component)temp, "North");
        contentPane.add(resultsPanel);
        contentPane.add((Component)this.statusBar, "South");
        this.getRootPane().setDefaultButton(this.findButton);
        this.setModal(false);
        this.applyComponentOrientation(orientation);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("FindInFiles".equals(command)) {
            String item = FindInFilesDialog.getTextComponent(this.findTextCombo).getText();
            this.findTextCombo.addItem(item);
            this.context.setSearchFor(this.getSearchString());
            item = FindInFilesDialog.getTextComponent(this.inFilesComboBox).getText();
            this.inFilesComboBox.addItem(item);
            item = FindInFilesDialog.getTextComponent(this.skipFoldersComboBox).getText();
            this.skipFoldersComboBox.addItem(item);
            this.doFindInFiles();
        } else if ("Browse".equals(command)) {
            RDirectoryChooser chooser = new RDirectoryChooser((Dialog)((Object)this));
            String dirName = this.inFolderTextField.getText().trim();
            if (dirName.length() > 0) {
                File dir = new File(dirName);
                chooser.setChosenDirectory(dir);
            }
            chooser.setVisible(true);
            String directory = chooser.getChosenDirectory();
            if (directory != null) {
                this.inFolderTextField.setFileSystemAware(false);
                this.inFolderTextField.setText(directory);
                this.inFolderTextField.setFileSystemAware(true);
            }
        } else if ("Close".equals(command)) {
            FindInFilesThread workerThread = this.getWorkerThread();
            if (workerThread != null) {
                workerThread.interrupt();
                this.setSearching(false);
            } else {
                this.setVisible(false);
            }
        } else if ("Subfolders".equals(command)) {
            boolean search = this.subfoldersCheckBox.isSelected();
            ((FindInFilesSearchContext)this.context).setSearchSubfolders(search);
        } else if ("Verbose".equals(command)) {
            boolean verbose = this.verboseCheckBox.isSelected();
            ((FindInFilesSearchContext)this.context).setVerbose(verbose);
        } else {
            super.actionPerformed(e);
        }
    }

    void addMatchData(MatchData matchData) {
        String dirName = this.inFolderTextField.getText();
        SwingUtilities.invokeLater(() -> this.getResultsComponent().addMatchData(matchData, dirName));
    }

    public void addFindInFilesListener(FindInFilesListener listener) {
        this.eventListenerList.add(FindInFilesListener.class, listener);
    }

    public void addInFilesComboBoxFilter(String filter) {
        this.inFilesComboBox.addItem(filter);
    }

    void clearSearchResults() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getResultsComponent().clear();
        } else {
            SwingUtilities.invokeLater(() -> this.getResultsComponent().clear());
        }
    }

    protected Box createDetailsPanel() {
        Box detailPanel = Box.createVerticalBox();
        detailPanel.setBorder(this.createTitledBorder(this.getString2("ReportDetail")));
        this.matchingLinesRadioButton = new JRadioButton(this.getString2("MatchingLines"));
        this.matchingLinesRadioButton.setMnemonic((int)this.getString2("MatchingLinesMnemonic").charAt(0));
        this.matchingLinesRadioButton.setSelected(true);
        detailPanel.add(this.matchingLinesRadioButton);
        JRadioButton fileCountsOnlyRadioButton = new JRadioButton(this.getString2("FileCounts"));
        fileCountsOnlyRadioButton.setMnemonic((int)this.getString2("FileCountsMnemonic").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.matchingLinesRadioButton);
        bg.add(fileCountsOnlyRadioButton);
        detailPanel.add(fileCountsOnlyRadioButton);
        Box panel = Box.createVerticalBox();
        this.subfoldersCheckBox = new JCheckBox(this.getString2("SearchSubfolders"), true);
        this.subfoldersCheckBox.setMnemonic((int)this.getString2("SearchSubfoldersMnemonic").charAt(0));
        this.subfoldersCheckBox.setActionCommand("Subfolders");
        this.subfoldersCheckBox.addActionListener((ActionListener)((Object)this));
        panel.add(detailPanel);
        panel.add(this.subfoldersCheckBox);
        return panel;
    }

    protected Box createExtraOptionsPanel() {
        Box temp = new Box(2);
        this.verboseCheckBox = new JCheckBox(this.getString2("Verbose"));
        this.verboseCheckBox.setActionCommand("Verbose");
        this.verboseCheckBox.addActionListener((ActionListener)((Object)this));
        this.verboseCheckBox.setMnemonic((int)this.getString2("VerboseMnemonic").charAt(0));
        temp.add(this.verboseCheckBox);
        temp.add(Box.createHorizontalGlue());
        return temp;
    }

    protected JPanel createInputPanel() {
        JPanel inputPanel = new JPanel(new SpringLayout());
        JLabel findLabel = UIUtil.newLabel((ResourceBundle)this.getBundle(), (String)"FindWhat", (Component)this.findTextCombo);
        JLabel inLabel = new JLabel(this.getString2("InFiles"));
        inLabel.setLabelFor(this.inFilesComboBox);
        inLabel.setDisplayedMnemonic((int)this.getString2("InFilesMnemonic").charAt(0));
        JLabel dirLabel = new JLabel(this.getString2("InDirectory"));
        dirLabel.setLabelFor((Component)this.inFolderTextField);
        dirLabel.setDisplayedMnemonic((int)this.getString2("InDirectoryMnemonic").charAt(0));
        JLabel skipLabel = new JLabel(this.getString2("SkipFolders"));
        skipLabel.setLabelFor(this.skipFoldersComboBox);
        skipLabel.setDisplayedMnemonic((int)this.getString2("SkipFoldersMnemonic").charAt(0));
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.findTextCombo);
        AssistanceIconPanel aip = new AssistanceIconPanel((JComponent)this.findTextCombo, 12);
        temp.add((Component)aip, "Before");
        JPanel temp2 = new JPanel(new BorderLayout());
        JPanel assistancePanel = RTextUtilities.createAssistancePanel(this.inFilesComboBox, 12);
        this.inFilesDecorativeIconPanel = (DecorativeIconPanel)assistancePanel.getComponent(0);
        temp2.add(assistancePanel);
        temp2.add(Box.createHorizontalStrut(1), "Before");
        JPanel temp3 = new JPanel(new BorderLayout());
        assistancePanel = RTextUtilities.createAssistancePanel((JComponent)this.inFolderTextField, 12);
        this.inFolderDecorativeIconPanel = (DecorativeIconPanel)assistancePanel.getComponent(0);
        temp3.add(assistancePanel);
        temp3.add(Box.createHorizontalStrut(1), "Before");
        JPanel temp4 = new JPanel(new BorderLayout());
        assistancePanel = RTextUtilities.createAssistancePanel(this.skipFoldersComboBox, 12);
        this.skipFoldersDecorativeIconPanel = (DecorativeIconPanel)assistancePanel.getComponent(0);
        temp4.add(assistancePanel);
        temp4.add(Box.createHorizontalStrut(1), "Before");
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        UIUtil.addLabelValuePairs((Container)inputPanel, (ComponentOrientation)orientation, (Component[])new Component[]{findLabel, temp, inLabel, temp2, dirLabel, temp3, skipLabel, temp4});
        UIUtil.makeSpringCompactGrid((Container)inputPanel, (int)4, (int)2, (int)0, (int)0, (int)0, (int)5);
        return inputPanel;
    }

    protected ResultsComponent createResultsComponent() {
        FindInFilesTable table = new FindInFilesTable();
        table.addMouseListener(new FindInFilesDialogMouseListener(table));
        return table;
    }

    protected SearchContext createDefaultSearchContext() {
        return new FindInFilesSearchContext();
    }

    protected FindInFilesThread createWorkerThread(File directory) {
        return new FindInFilesThread(this, directory);
    }

    private void doFindInFiles() {
        String dirPath = this.inFolderTextField.getText();
        File directory = new File(dirPath);
        if (!directory.isDirectory()) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getString2("ErrorDirNotExist") + dirPath, this.getString2("ErrorDialogTitle"), 0);
            this.inFolderTextField.selectAll();
            this.inFolderTextField.requestFocusInWindow();
            return;
        }
        if (this.regexCheckBox.isSelected()) {
            try {
                Pattern.compile(this.getSearchString());
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                JOptionPane.showMessageDialog((Component)((Object)this), "Invalid regular expression:\n" + text + "\nPlease check your regular expression search string.", this.getString2("ErrorDialogTitle"), 0);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setSearching(true);
        this.setWorkerThread(this.createWorkerThread(directory));
        this.getWorkerThread().start();
    }

    protected void fireFindInFilesEvent(FindInFilesEvent e) {
        Object[] listeners = this.eventListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FindInFilesListener.class) continue;
            ((FindInFilesListener)listeners[i + 1]).findInFilesFileSelected(e);
        }
    }

    String getString2(String key) {
        return MSG.getString(key);
    }

    protected static JTextComponent getTextComponent(JComboBox<?> combo) {
        return org.fife.rsta.ui.UIUtil.getTextComponent(combo);
    }

    boolean getCheckSubfolders() {
        return this.subfoldersCheckBox.isSelected();
    }

    private static String getDefaultFoldersToSkip() {
        return ".git, CVS, .svn, bower_components, node_modules";
    }

    boolean getDoVerboseOutput() {
        return this.verboseCheckBox.isSelected();
    }

    String[] getInFilesPatterns() {
        return UIUtil.getCommaSeparatedValues(this.inFilesComboBox);
    }

    protected static int getLength(JTextComponent c) {
        return c.getDocument().getLength();
    }

    boolean getMatchCase() {
        return this.caseCheckBox.isSelected();
    }

    boolean getMatchWholeWord() {
        return this.wholeWordCheckBox.isSelected();
    }

    protected ResultsComponent getResultsComponent() {
        return this.resultsComponent;
    }

    boolean getShowMatchingLines() {
        return this.matchingLinesRadioButton.isSelected();
    }

    String[] getSkipFolders() {
        return UIUtil.getCommaSeparatedValues(this.skipFoldersComboBox);
    }

    boolean getUseRegEx() {
        return this.regexCheckBox.isSelected();
    }

    protected synchronized FindInFilesThread getWorkerThread() {
        return this.workerThread;
    }

    protected FindReplaceButtonsEnableResult handleToggleButtons() {
        FindReplaceButtonsEnableResult er = super.handleToggleButtons();
        boolean enable = er.getEnable();
        this.findButton.setEnabled(enable && this.isEverythingFilledIn());
        JTextComponent tc = FindInFilesDialog.getTextComponent(this.findTextCombo);
        tc.setForeground(enable ? UIManager.getColor("TextField.foreground") : Color.RED);
        Object tooltip = er.getError();
        String status = this.defaultStatusText;
        if (tooltip != null && (status = tooltip).contains("\n")) {
            status = status.substring(0, status.indexOf(10));
        }
        this.setStatusText(status);
        if (tooltip != null && ((String)tooltip).contains("\n")) {
            tooltip = ((String)tooltip).replaceFirst("\\\n", "</b><br><pre>");
            tooltip = "<html><b>" + (String)tooltip;
        }
        tc.setToolTipText((String)tooltip);
        return er;
    }

    protected boolean isEverythingFilledIn() {
        return this.getWorkerThread() == null && FindInFilesDialog.getLength(FindInFilesDialog.getTextComponent(this.findTextCombo)) > 0 && FindInFilesDialog.getLength(FindInFilesDialog.getTextComponent(this.inFilesComboBox)) > 0 && FindInFilesDialog.getLength((JTextComponent)this.inFolderTextField) > 0;
    }

    protected void refreshUIFromContext() {
        super.refreshUIFromContext();
        if (this.caseCheckBox == null) {
            return;
        }
        FindInFilesSearchContext fifsc = (FindInFilesSearchContext)this.context;
        this.subfoldersCheckBox.setSelected(fifsc.getSearchSubfolders());
        this.verboseCheckBox.setSelected(fifsc.getVerbose());
    }

    public void removeFindInFilesListener(FindInFilesListener listener) {
        this.eventListenerList.remove(FindInFilesListener.class, listener);
    }

    void searchCompleted(String message) {
        this.setStatusText(message);
        this.searchCompleted(-1L);
    }

    void searchCompleted(long time) {
        SwingUtilities.invokeLater(() -> {
            this.setWorkerThread(null);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setSearching(false);
            if (time != -1L) {
                String temp = MessageFormat.format(this.searchingCompleteString, "" + (float)time / 1000.0f);
                this.setStatusText(temp);
                if (this.getResultsComponent().getRowCount() == 0) {
                    String searchString = (String)this.findTextCombo.getSelectedItem();
                    JOptionPane.showMessageDialog((Component)((Object)this), this.getString2("SearchStringNotFound") + searchString + "'.", this.getString2("InfoDialogTitle"), 1);
                }
            }
            this.getResultsComponent().prettyUp();
        });
    }

    public void setContentAssistImage(Image image) {
        super.setContentAssistImage(image);
        int imageWidth = image.getWidth(null);
        this.inFilesDecorativeIconPanel.setIconWidth(imageWidth);
        this.inFolderDecorativeIconPanel.setIconWidth(imageWidth);
        this.skipFoldersDecorativeIconPanel.setIconWidth(imageWidth);
    }

    public void setSearchIn(File dir) {
        this.inFolderTextField.setFileSystemAware(false);
        this.inFolderTextField.setText(dir.getAbsolutePath());
        this.inFolderTextField.setFileSystemAware(true);
    }

    protected void setSearching(boolean searching) {
        boolean enabled = !searching;
        this.findButton.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        if (searching) {
            this.cancelButton.setText(this.getString2("Stop"));
            this.cancelButton.setMnemonic((int)this.getString2("Stop.Mnemonic").charAt(0));
        } else {
            this.cancelButton.setText(this.getString2("Close"));
            this.cancelButton.setMnemonic((int)this.getString2("Close.Mnemonic").charAt(0));
        }
        this.findTextCombo.setEnabled(enabled);
        this.inFilesComboBox.setEnabled(enabled);
        this.inFolderTextField.setEnabled(enabled);
    }

    public void setStatusText(String text) {
        if (this.isVisible()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.statusBar.setStatusMessage(text);
            } else {
                SwingUtilities.invokeLater(() -> this.statusBar.setStatusMessage(text));
            }
        }
    }

    public void setVisible(boolean visible) {
        this.refreshUIFromContext();
        super.setVisible(visible);
        if (visible) {
            this.setStatusText(this.defaultStatusText);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.handleToggleButtons();
            this.findTextCombo.requestFocusInWindow();
            JTextComponent editor = FindInFilesDialog.getTextComponent(this.findTextCombo);
            editor.selectAll();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.handleToggleButtons();
                this.findTextCombo.requestFocusInWindow();
                JTextComponent editor = FindInFilesDialog.getTextComponent(this.findTextCombo);
                editor.selectAll();
            });
        }
    }

    private synchronized void setWorkerThread(FindInFilesThread thread) {
        this.workerThread = thread;
    }

    private void updateIcons() {
        RText rtext = (RText)((Object)this.getParent());
        Image image = rtext.getMainView().getSearchManager().getLookAndFeelContentAssistImage();
        this.setContentAssistImage(image);
    }

    public void updateUI() {
        FindInFilesFocusAdapter focusAdapter = new FindInFilesFocusAdapter();
        JTextComponent textField = FindInFilesDialog.getTextComponent(this.findTextCombo);
        textField.addFocusListener(focusAdapter);
        textField.getDocument().addDocumentListener(this.docListener);
        textField = FindInFilesDialog.getTextComponent(this.inFilesComboBox);
        textField.addFocusListener(focusAdapter);
        textField.getDocument().addDocumentListener(this.docListener);
        this.inFolderTextField.addFocusListener((FocusListener)focusAdapter);
        this.inFolderTextField.getDocument().addDocumentListener(this.docListener);
        this.updateIcons();
    }

    private final class FindInFilesDocumentListener
    implements DocumentListener {
        private FindInFilesDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FindInFilesDialog.this.handleToggleButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FindInFilesDialog.this.handleToggleButtons();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    protected class FindInFilesFocusAdapter
    extends FocusAdapter {
        protected FindInFilesFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component component = e.getComponent();
            ((JTextField)component).selectAll();
            if (component == FindInFilesDialog.getTextComponent(FindInFilesDialog.this.findTextCombo)) {
                FindInFilesDialog.this.lastSearchString = (String)FindInFilesDialog.this.findTextCombo.getSelectedItem();
            } else if (component == FindInFilesDialog.getTextComponent(FindInFilesDialog.this.inFilesComboBox)) {
                FindInFilesDialog.this.lastInFilesString = (String)FindInFilesDialog.this.inFilesComboBox.getSelectedItem();
            } else if (component == FindInFilesDialog.getTextComponent(FindInFilesDialog.this.skipFoldersComboBox)) {
                FindInFilesDialog.this.lastSkipFoldersString = (String)FindInFilesDialog.this.skipFoldersComboBox.getSelectedItem();
            }
        }
    }

    class FindInFilesDialogMouseListener
    extends MouseAdapter {
        ResultsComponent comp;

        FindInFilesDialogMouseListener(ResultsComponent comp) {
            this.comp = comp;
        }

        private void handleOpenSearchResult() {
            int row = this.comp.getSelectedRow();
            if (row == -1) {
                return;
            }
            MatchData data = this.comp.getMatchDataForRow(row);
            String fileName = data.getFileName();
            if (!new File(fileName).isFile()) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            String lineStr = data.getLineNumber();
            int line = -1;
            if (!"--".equals(lineStr)) {
                if (lineStr.contains("-")) {
                    lineStr = lineStr.substring(0, lineStr.indexOf(45));
                }
                try {
                    line = Integer.parseInt(lineStr);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
            FindInFilesDialog.this.fireFindInFilesEvent(new FindInFilesEvent((Object)FindInFilesDialog.this, fileName, line));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.handleOpenSearchResult();
            }
        }
    }
}

