/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.fife.ui.FileExplorerTableModel;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rtextfilechooser.Actions;
import org.fife.ui.rtextfilechooser.FileSelector;
import org.fife.ui.rtextfilechooser.FileSystemTree;
import org.fife.ui.search.MatchData;
import org.fife.ui.search.ResultsComponent;

public class FindInFilesTable
extends JTable
implements ResultsComponent,
FileSelector {
    private FileExplorerTableModel sorter;
    private DefaultTableModel tableModel;
    private List<MatchData> matchDatas;
    private JPopupMenu contextMenu;
    private StandardCellRenderer defaultRenderer;
    private VerboseCellRenderer verboseRenderer;
    private static final String MSG = "org.fife.ui.search.FindInFilesTable";

    public FindInFilesTable() {
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        this.tableModel = this.createTableModel(msg);
        this.sorter = new FileExplorerTableModel((TableModel)this.tableModel);
        this.setModel((TableModel)this.sorter);
        this.sorter.setTable((JTable)this);
        this.setAutoResizeMode(0);
        this.setSelectionModel((ListSelectionModel)new RListSelectionModel());
        this.setRowSelectionAllowed(true);
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        this.initColumnWidths();
        this.matchDatas = new ArrayList<MatchData>();
        this.defaultRenderer = new StandardCellRenderer();
        ToolTipManager.sharedInstance().unregisterComponent(this);
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
    }

    @Override
    public void addMatchData(MatchData matchData, String dirName) {
        int pos;
        String fileName = matchData.getFileName().toLowerCase();
        dirName = dirName.toLowerCase();
        int dirNameLength = dirName.length();
        for (pos = 0; pos < dirNameLength && (fileName.charAt(pos) == dirName.charAt(pos) || FindInFilesTable.isFileSeparatorChar(fileName.charAt(pos))); ++pos) {
        }
        if (FindInFilesTable.isFileSeparatorChar(fileName.charAt(pos))) {
            ++pos;
        }
        fileName = matchData.getFileName().substring(pos);
        Vector<String> v = this.createMatchDataVector(fileName, matchData);
        this.tableModel.addRow(v);
        this.matchDatas.add(matchData);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        Component c;
        super.applyComponentOrientation(o);
        TableCellRenderer r = this.getDefaultRenderer(Object.class);
        if (r instanceof Component) {
            c = (Component)((Object)r);
            c.applyComponentOrientation(o);
        }
        if ((r = this.getDefaultRenderer(Number.class)) instanceof Component) {
            c = (Component)((Object)r);
            c.applyComponentOrientation(o);
        }
        if ((r = this.getDefaultRenderer(Boolean.class)) instanceof Component) {
            c = (Component)((Object)r);
            c.applyComponentOrientation(o);
        }
        if (this.getTableHeader() != null) {
            r = this.getTableHeader().getDefaultRenderer();
            if (r instanceof FileExplorerTableModel.SortableHeaderRenderer) {
                ((FileExplorerTableModel.SortableHeaderRenderer)r).applyComponentOrientation(o);
            } else if (r instanceof Component) {
                c = (Component)((Object)r);
                c.applyComponentOrientation(o);
            }
        }
        this.defaultRenderer.applyComponentOrientation(o);
        if (this.verboseRenderer != null) {
            this.verboseRenderer.applyComponentOrientation(o);
        }
    }

    @Override
    public void clear() {
        this.tableModel.setRowCount(0);
        this.matchDatas.clear();
    }

    protected Vector<String> createMatchDataVector(String fileName, MatchData data) {
        Vector<String> v = new Vector<String>(3);
        v.add(fileName);
        v.add(data.getLineNumber());
        v.add(data.getLineText());
        return v;
    }

    protected DefaultTableModel createTableModel(ResourceBundle msg) {
        DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.addColumn(msg.getString("FindInFiles.Column.File"));
        tableModel.addColumn(msg.getString("FindInFiles.Column.Line"));
        tableModel.addColumn(msg.getString("FindInFiles.Column.Text"));
        return tableModel;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        MatchData data = this.getMatchDataForRow(row);
        if (data.isVerboseSearchInfo() || data.isError()) {
            if (this.verboseRenderer == null) {
                this.verboseRenderer = new VerboseCellRenderer();
            }
            return this.verboseRenderer;
        }
        return this.defaultRenderer;
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            ResourceBundle bundle = ResourceBundle.getBundle(FileSystemTree.class.getName());
            this.contextMenu.add((Action)new Actions.CopyAction((FileSelector)this));
            this.contextMenu.add((Action)new Actions.CopyFullPathAction((FileSelector)this));
            this.contextMenu.addSeparator();
            JMenu openInMenu = new JMenu(bundle.getString("PopupMenu.OpenIn"));
            openInMenu.add((Action)new Actions.SystemOpenAction((FileSelector)this, Actions.SystemOpenAction.OpenMethod.EDIT));
            openInMenu.add((Action)new Actions.SystemOpenAction((FileSelector)this, Actions.SystemOpenAction.OpenMethod.OPEN));
            this.contextMenu.add(openInMenu);
            this.contextMenu.addSeparator();
            this.contextMenu.add((Action)new Actions.PropertiesAction((FileSelector)this));
        }
        return this.getSelectedRow() > -1 ? this.contextMenu : null;
    }

    @Override
    public MatchData getMatchDataForRow(int row) {
        row = this.sorter.modelIndex(row);
        return this.matchDatas.get(row);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(100, this.getRowHeight() * 8);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            return parent.getSize().getWidth() > this.getPreferredSize().getWidth();
        }
        return super.getScrollableTracksViewportWidth();
    }

    public File getSelectedFile() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return null;
        }
        MatchData matchData = this.getMatchDataForRow(selectedRow);
        String fileName = matchData.getFileName();
        File file = new File(fileName);
        if (!file.isFile()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return null;
        }
        return file;
    }

    public File[] getSelectedFiles() {
        File[] fileArray;
        File file = this.getSelectedFile();
        if (file != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    protected void initColumnWidths() {
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(80);
        columnModel.getColumn(1).setPreferredWidth(40);
        columnModel.getColumn(2).setPreferredWidth(180);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    private static boolean isFileSeparatorChar(char ch) {
        return ch == '\\' || ch == '/';
    }

    @Override
    public void prettyUp() {
        this.refreshColumnWidths();
        this.revalidate();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int row = this.rowAtPoint(e.getPoint());
            if (row > -1) {
                this.setRowSelectionInterval(row, row);
            } else {
                this.clearSelection();
            }
        }
        super.processMouseEvent(e);
    }

    private void refreshColumnWidths() {
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        for (int j = 0; j < columnCount; ++j) {
            TableColumn column = columnModel.getColumn(j);
            Component c = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            int width = c.getPreferredSize().width;
            for (int i = 0; i < rowCount; ++i) {
                TableCellRenderer renderer = this.getCellRenderer(i, j);
                String value = (String)this.getValueAt(i, j);
                if (rowCount > 3000 && value.startsWith("<html>")) {
                    value = Util.stripHtml((String)value);
                }
                Component comp = renderer.getTableCellRendererComponent(this, value, false, false, i, j);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(width + 20);
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle r) {
        r.x = 0;
        r.width = 0;
        super.scrollRectToVisible(r);
    }

    @Override
    public void updateUI() {
        TableCellRenderer r;
        Container parent = this.getParent();
        if (parent != null && (r = this.getTableHeader().getDefaultRenderer()) instanceof FileExplorerTableModel.SortableHeaderRenderer) {
            FileExplorerTableModel.SortableHeaderRenderer shr = (FileExplorerTableModel.SortableHeaderRenderer)r;
            this.getTableHeader().setDefaultRenderer(shr.getDelegateRenderer());
        }
        super.updateUI();
        if (parent != null) {
            JScrollPane sp = (JScrollPane)parent.getParent();
            sp.setColumnHeaderView(this.getTableHeader());
            sp.revalidate();
            sp.repaint();
        }
        if (this.defaultRenderer != null) {
            this.defaultRenderer.updateUI();
        }
        if (this.verboseRenderer != null) {
            this.verboseRenderer.updateUI();
        }
    }

    private static final class StandardCellRenderer
    extends DefaultTableCellRenderer {
        private StandardCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            String str;
            if (selected && value instanceof String && (str = (String)value).startsWith("<html>")) {
                value = str.replaceAll("color=\"[^\"]+\"", "");
            }
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            return this;
        }
    }

    private final class VerboseCellRenderer
    extends DefaultTableCellRenderer {
        private VerboseCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                MatchData data = FindInFilesTable.this.getMatchDataForRow(row);
                if (data.isVerboseSearchInfo()) {
                    this.setForeground(Color.GRAY);
                } else if (data.isError()) {
                    this.setForeground(Color.RED);
                }
            }
            return this;
        }
    }
}

