/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.search;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.io.UnicodeReader;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.GUIWorkerThread;
import org.fife.ui.OS;
import org.fife.ui.rsyntaxtextarea.FileTypeUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.search.FindInFilesDialog;
import org.fife.ui.search.MatchData;

class FindInFilesThread
extends GUIWorkerThread<Object> {
    protected static final String NO_LINE_NUMBER = "--";
    protected FindInFilesDialog dialog;
    protected File directory;
    private Set<String> folderNamesToSkip;
    private String verboseLabelString;
    private String errorLabelString;
    protected String verboseNoFiltMatchString;
    protected String dontSearchSubfoldersString;
    protected String skipThisFolderString;
    protected String newFilesToExamineString;
    protected String occurrencesString;

    FindInFilesThread(FindInFilesDialog dialog, File directory) {
        this.dialog = dialog;
        this.directory = directory;
        this.folderNamesToSkip = new HashSet<String>();
        String[] tempFoldersToSkip = dialog.getSkipFolders();
        if (tempFoldersToSkip != null) {
            for (String folderName : tempFoldersToSkip) {
                if (!OS.get().isCaseSensitive()) {
                    folderName = folderName.toLowerCase();
                }
                this.folderNamesToSkip.add(folderName);
            }
        }
        this.verboseLabelString = "<html><em>" + dialog.getString2("VerboseLabel") + "</em>";
        this.errorLabelString = "<html><em>" + dialog.getString2("ErrorLabel") + "</em>";
        this.verboseNoFiltMatchString = dialog.getString2("VerboseNoFiltMatch");
        this.dontSearchSubfoldersString = dialog.getString2("SearchSubFoldUnchecked");
        this.skipThisFolderString = dialog.getString2("SkipThisFolder");
        this.newFilesToExamineString = dialog.getString2("NewFilesToExamine");
        this.occurrencesString = dialog.getString2("Occurrences");
    }

    protected MatchData createErrorMatchData(String filePath, String msg) {
        return new MatchData(filePath, NO_LINE_NUMBER, this.errorLabelString + msg, 2);
    }

    protected MatchData createVerboseMatchData(String filePath, String msg) {
        return new MatchData(filePath, NO_LINE_NUMBER, this.verboseLabelString + msg, 1);
    }

    public Object construct() {
        RText parent = (RText)((Object)this.dialog.getOwner());
        AbstractMainView view = parent.getMainView();
        String searchString = this.dialog.getSearchString();
        Pattern[] filterStrings = this.getFilterStrings();
        if (filterStrings == null) {
            this.dialog.searchCompleted("");
            return null;
        }
        this.dialog.clearSearchResults();
        File[] files = this.directory.listFiles();
        ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(files));
        boolean checkSubfolders = this.dialog.getCheckSubfolders();
        boolean matchingLines = this.dialog.getShowMatchingLines();
        boolean matchCase = this.dialog.getMatchCase();
        boolean wholeWord = this.dialog.getMatchWholeWord();
        boolean useRegex = this.dialog.getUseRegEx();
        boolean doVerboseOutput = this.dialog.getDoVerboseOutput();
        String searchingFile = this.dialog.getString2("SearchingFile");
        if (!useRegex && !matchCase) {
            searchString = searchString.toLowerCase();
        }
        RSyntaxTextArea textArea = new RSyntaxTextArea();
        textArea.setSyntaxScheme(parent.getSyntaxScheme());
        long startMillis = System.currentTimeMillis();
        int numFiles = fileList.size();
        for (int i = 0; i < numFiles; ++i) {
            int count;
            MatchData data;
            if (Thread.currentThread().isInterrupted()) {
                this.dialog.searchCompleted(this.dialog.getString2("SearchTerminated"));
                return null;
            }
            File temp = (File)fileList.get(i);
            String fileFullPath = temp.getAbsolutePath();
            if (temp.isFile()) {
                if (FindInFilesThread.isFilteredOut(temp.getName(), filterStrings)) {
                    if (!doVerboseOutput) continue;
                    data = this.createVerboseMatchData(fileFullPath, this.verboseNoFiltMatchString);
                    this.dialog.addMatchData(data);
                    continue;
                }
                this.dialog.setStatusText(searchingFile + i + "/" + numFiles + ": " + fileFullPath);
                try {
                    BufferedReader r = new BufferedReader((Reader)new UnicodeReader(temp));
                    String style = view.getSyntaxStyleForFile(temp.getName());
                    textArea.read((Reader)r, null);
                    textArea.discardAllEdits();
                    if (!style.equals(textArea.getSyntaxEditingStyle())) {
                        textArea.setSyntaxEditingStyle(style);
                    }
                    ((Reader)r).close();
                }
                catch (IOException ioe) {
                    MatchData data2 = this.createErrorMatchData(fileFullPath, "IOException reading file: " + ioe);
                    this.dialog.addMatchData(data2);
                    continue;
                }
                catch (OutOfMemoryError oome) {
                    MatchData data3 = this.createErrorMatchData(fileFullPath, "OutOfMemoryError");
                    this.dialog.addMatchData(data3);
                    this.dialog.searchCompleted(System.currentTimeMillis() - startMillis);
                    return null;
                }
                String buffer = textArea.getText();
                if (buffer == null) continue;
                try {
                    if (useRegex) {
                        this.doSearchRegex(buffer, searchString, textArea, matchCase, wholeWord, matchingLines, fileFullPath);
                        continue;
                    }
                    this.doSearchNoRegex(buffer, searchString, textArea, matchCase, wholeWord, matchingLines, fileFullPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!temp.isDirectory()) continue;
            if (!checkSubfolders) {
                if (!doVerboseOutput) continue;
                data = this.createVerboseMatchData(fileFullPath, this.dontSearchSubfoldersString);
                this.dialog.addMatchData(data);
                continue;
            }
            if (this.shouldSkipFolder(temp)) {
                if (!doVerboseOutput) continue;
                data = this.createVerboseMatchData(fileFullPath, this.skipThisFolderString);
                this.dialog.addMatchData(data);
                continue;
            }
            List<File> moreFilesList = FindInFilesThread.getFilesFromDirectory(temp);
            int n = count = moreFilesList == null ? 0 : moreFilesList.size();
            if (count > 0) {
                fileList.addAll(moreFilesList);
                numFiles += count;
            }
            if (!doVerboseOutput) continue;
            MatchData data4 = this.createVerboseMatchData(fileFullPath, this.newFilesToExamineString + ": " + count);
            this.dialog.addMatchData(data4);
        }
        this.dialog.searchCompleted(System.currentTimeMillis() - startMillis);
        return null;
    }

    private void doSearchNoRegex(String buffer, String searchString, RSyntaxTextArea textArea, boolean matchCase, boolean wholeWord, boolean matchingLines, String fileFullPath) {
        if (!matchCase) {
            buffer = buffer.toLowerCase();
        }
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineCount = map.getElementCount();
        int i = 0;
        int len = searchString.length();
        int numMatches = 0;
        while ((i = buffer.indexOf(searchString, i)) != -1) {
            if (!wholeWord || FindDialog.isWholeWord((CharSequence)buffer, (int)i, (int)len)) {
                ++numMatches;
                if (matchingLines) {
                    int line = map.getElementIndex(i);
                    Element elem = map.getElement(line);
                    int lineEnd = line == lineCount - 1 ? elem.getEndOffset() - 1 : elem.getEndOffset();
                    Token t = textArea.getTokenListForLine(line);
                    String lineText = FindInFilesThread.getHtml(t, textArea);
                    this.dialog.addMatchData(new MatchData(fileFullPath, Integer.toString(line + 1), lineText));
                    i = lineEnd;
                    continue;
                }
                i += len;
                continue;
            }
            ++i;
        }
        if (!matchingLines && numMatches > 0) {
            String text = MessageFormat.format(this.occurrencesString, numMatches);
            MatchData data = new MatchData(fileFullPath, NO_LINE_NUMBER, text);
            this.dialog.addMatchData(data);
        }
    }

    private void doSearchRegex(String buffer, String searchString, RSyntaxTextArea textArea, boolean matchCase, boolean wholeWord, boolean matchingLines, String fileFullPath) {
        Document doc = textArea.getDocument();
        Element map = doc.getDefaultRootElement();
        int numMatches = 0;
        int lastStartLine = -1;
        int flags = matchCase ? 0 : 66;
        Pattern pattern = Pattern.compile(searchString, flags);
        Matcher m = pattern.matcher(buffer);
        while (m.find()) {
            String lineStr;
            int startLine;
            int start = m.start();
            int end = m.end();
            if (wholeWord && !FindDialog.isWholeWord((CharSequence)buffer, (int)start, (int)(end - start))) continue;
            ++numMatches;
            if (!matchingLines || (startLine = map.getElementIndex(start)) == lastStartLine) continue;
            lastStartLine = startLine;
            int endLine = map.getElementIndex(end);
            Token t = textArea.getTokenListForLine(startLine);
            Object text = FindInFilesThread.getHtml(t, textArea);
            boolean oneLine = startLine == endLine;
            String string = lineStr = oneLine ? Integer.toString(startLine + 1) : startLine + 1 + "-" + (endLine + 1);
            if (!oneLine) {
                text = (String)text + " <em>" + this.dialog.getString2("MultiLineMatch") + "</em>";
            }
            MatchData data = new MatchData(fileFullPath, lineStr, (String)text);
            this.dialog.addMatchData(data);
        }
        if (!matchingLines && numMatches > 0) {
            String text = MessageFormat.format(this.occurrencesString, numMatches);
            MatchData data = new MatchData(fileFullPath, NO_LINE_NUMBER, text);
            this.dialog.addMatchData(data);
        }
    }

    protected static List<File> getFilesFromDirectory(File dir) {
        File[] moreFiles = dir.listFiles();
        if (moreFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(moreFiles);
    }

    protected Pattern[] getFilterStrings() {
        String[] tokens = this.dialog.getInFilesPatterns();
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        try {
            return (Pattern[])Arrays.stream(tokens).map(FileTypeUtil::fileFilterToPattern).toArray(Pattern[]::new);
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getHtml(Token t, RSyntaxTextArea textArea) {
        int maxLen = 1280;
        Font font = RTextArea.getDefaultFont();
        String fontFamily = font.getFamily();
        StringBuilder sb = new StringBuilder("<html><nobr><font face=\"" + fontFamily + "\">");
        boolean firstNonWhitespace = false;
        while (t != null && t.isPaintable() && sb.length() < 1280) {
            if (firstNonWhitespace || (firstNonWhitespace |= !t.isWhitespace())) {
                t.appendHTMLRepresentation(sb, textArea, false);
            }
            t = t.getNextToken();
        }
        if (sb.length() >= 1280) {
            sb.append("...");
        }
        return sb.toString();
    }

    protected static boolean isFilteredOut(String file, Pattern[] filters) {
        for (Pattern filter : filters) {
            if (!filter.matcher(file).matches()) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldSkipFolder(File folder) {
        String folderName = folder.getName();
        if (!OS.get().isCaseSensitive()) {
            folderName = folderName.toLowerCase();
        }
        return this.folderNamesToSkip.contains(folderName);
    }
}

