/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.AssistanceIconPanel;
import org.fife.rsta.ui.search.SearchComboBox;
import org.fife.ui.UIUtil;
import org.fife.ui.search.FindInFilesDialog;
import org.fife.ui.search.FindInFilesThread;
import org.fife.ui.search.ReplaceInFilesTable;
import org.fife.ui.search.ReplaceInFilesThread;
import org.fife.ui.search.ResultsComponent;

public class ReplaceInFilesDialog
extends FindInFilesDialog {
    private SearchComboBox replaceCombo;

    public ReplaceInFilesDialog(Frame owner) {
        super(owner);
        this.setTitle(this.getString2("ReplaceInFilesDialogTitle"));
        this.findButton.setText(ReplaceInFilesDialog.getString((String)"Replace"));
        this.findButton.setMnemonic((int)ReplaceInFilesDialog.getString((String)"Replace.Mnemonic").charAt(0));
    }

    @Override
    protected Box createDetailsPanel() {
        Box panel = Box.createVerticalBox();
        panel.add(Box.createVerticalStrut(5));
        this.subfoldersCheckBox = new JCheckBox(this.getString2("SearchSubfolders"));
        this.subfoldersCheckBox.setMnemonic((int)this.getString2("SearchSubfoldersMnemonic").charAt(0));
        panel.add(this.subfoldersCheckBox);
        this.verboseCheckBox = new JCheckBox(this.getString2("Verbose"));
        this.verboseCheckBox.setMnemonic((int)this.getString2("VerboseMnemonic").charAt(0));
        panel.add(this.verboseCheckBox);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    @Override
    protected Box createExtraOptionsPanel() {
        return null;
    }

    @Override
    protected JPanel createInputPanel() {
        JPanel inputPanel = super.createInputPanel();
        this.replaceCombo = new SearchComboBox(null, true);
        ReplaceInFilesDialog.getTextComponent(this.replaceCombo).addFocusListener(new FindInFilesDialog.FindInFilesFocusAdapter());
        JLabel replaceLabel = UIUtil.newLabel((ResourceBundle)this.getBundle(), (String)"ReplaceWith", (Component)this.replaceCombo);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.replaceCombo);
        AssistanceIconPanel aip = new AssistanceIconPanel((JComponent)this.replaceCombo, 12);
        temp.add((Component)aip, "Before");
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        if (orientation.isLeftToRight()) {
            inputPanel.add((Component)replaceLabel, 2);
            inputPanel.add((Component)temp, 3);
        } else {
            inputPanel.add((Component)temp, 2);
            inputPanel.add((Component)replaceLabel, 3);
        }
        UIUtil.makeSpringCompactGrid((Container)inputPanel, (int)5, (int)2, (int)0, (int)0, (int)0, (int)5);
        return inputPanel;
    }

    @Override
    protected ResultsComponent createResultsComponent() {
        ReplaceInFilesTable table = new ReplaceInFilesTable();
        table.addMouseListener(new FindInFilesDialog.FindInFilesDialogMouseListener(table));
        return table;
    }

    @Override
    protected FindInFilesThread createWorkerThread(File directory) {
        return new ReplaceInFilesThread(this, directory);
    }

    protected void escapePressed() {
        if (this.replaceCombo != null && this.replaceCombo.hideAutoCompletePopups()) {
            return;
        }
        super.escapePressed();
    }

    public String getReplaceString() {
        return (String)this.replaceCombo.getSelectedItem();
    }

    protected void handleRegExCheckBoxClicked() {
        super.handleRegExCheckBoxClicked();
        boolean b = this.regexCheckBox.isSelected();
        if (this.replaceCombo != null) {
            this.replaceCombo.setAutoCompleteEnabled(b);
        }
    }

    @Override
    public void setContentAssistImage(Image image) {
        super.setContentAssistImage(image);
        this.replaceCombo.setContentAssistImage(image);
    }

    @Override
    protected void setSearching(boolean searching) {
        super.setSearching(searching);
        boolean enabled = !searching;
        this.replaceCombo.setEnabled(enabled);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            boolean regexEnabled = this.regexCheckBox.isSelected();
            if (this.replaceCombo != null) {
                this.replaceCombo.setAutoCompleteEnabled(regexEnabled);
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        FindInFilesDialog.FindInFilesFocusAdapter focusAdapter = new FindInFilesDialog.FindInFilesFocusAdapter();
        JTextComponent textField = ReplaceInFilesDialog.getTextComponent(this.replaceCombo);
        textField.addFocusListener(focusAdapter);
    }
}

