/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupController;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.session.EntryPanelManager;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcherFactory;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileHandler;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.EditExtrasAccessor;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLBookmarksAction;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLToolsPopUpAction;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateChannel;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.HqlSyntaxHighlightTokenMatcherProxy;
import net.sourceforge.squirrel_sql.plugins.hibernate.ToolsPopupAccessorProxy;
import net.sourceforge.squirrel_sql.plugins.hibernate.ViewInMappedObjectsAction;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLCompleteCodeAction;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HibernateSQLUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HqlQueryErrorUtil;

public class HQLEntryPanelManager
extends EntryPanelManager
implements IFileEditorAPI {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HQLEntryPanelManager.class);
    private final FileHandler _fileHandler;
    private HqlSyntaxHighlightTokenMatcherProxy _hqlSyntaxHighlightTokenMatcherProxy = new HqlSyntaxHighlightTokenMatcherProxy();
    private HibernatePluginResources _resources;
    private HibernateChannel _hibernateChannel;
    private ToolsPopupController _toolsPopupController;

    public HQLEntryPanelManager(ISession session, HibernatePluginResources resources, HibernateChannel hibernateChannel, TitleFilePathHandler titleFileHandler) {
        super(session);
        this._hibernateChannel = hibernateChannel;
        ToolsPopupAccessorProxy tpap = new ToolsPopupAccessorProxy();
        this.init(this.createSyntaxHighlightTokenMatcherFactory(), tpap);
        this._resources = resources;
        this.initToolsPopUp();
        tpap.apply(this);
        this.initCodeCompletion();
        this.initBookmarks();
        this._fileHandler = new FileHandler((IFileEditorAPI)this, titleFileHandler);
        this._fileHandler.replaceSqlFileExtensionFilterBy(new FileExtensionFilter("HQL files", new String[]{".hql"}));
        this.getEntryPanel().addUndoableEditListener(this._fileHandler.createEditListener());
        this.initActions(session);
    }

    private void initActions(final ISession session) {
        String strQuote = s_stringMgr.getString("HQLEntryPanelManager.quoteHQL");
        AbstractAction quoteHql = new AbstractAction(strQuote){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onQuoteHQL();
            }
        };
        quoteHql.putValue("ShortDescription", strQuote);
        this.addToSQLEntryAreaMenu(quoteHql, "quote");
        String strQuoteSb = s_stringMgr.getString("HQLEntryPanelManager.quoteHQLsb");
        AbstractAction quoteSbHql = new AbstractAction(strQuoteSb){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onQuoteHQLSb();
            }
        };
        quoteSbHql.putValue("ShortDescription", strQuoteSb);
        this.addToSQLEntryAreaMenu(quoteSbHql, "quotesb");
        String strUnquote = s_stringMgr.getString("HQLEntryPanelManager.unquoteHQL");
        AbstractAction unquoteHql = new AbstractAction(strUnquote){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onUnquoteHQL();
            }
        };
        unquoteHql.putValue("ShortDescription", strUnquote);
        this.addToSQLEntryAreaMenu(unquoteHql, "unquote");
        String strEscapeDate = s_stringMgr.getString("HQLEntryPanelManager.escapeDate");
        AbstractAction escapeDate = new AbstractAction(strEscapeDate){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onEscapeDate();
            }
        };
        escapeDate.putValue("ShortDescription", strEscapeDate);
        this.addToSQLEntryAreaMenu(escapeDate, "date");
        String strCopySqlToClip = s_stringMgr.getString("HQLEntryPanelManager.copySqlToClip");
        AbstractAction copySqlToClip = new AbstractAction(strCopySqlToClip){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onCopySqlToClip(session);
            }
        };
        copySqlToClip.putValue("ShortDescription", strCopySqlToClip);
        this.addToSQLEntryAreaMenu(copySqlToClip, "sqltoclip");
        ViewInMappedObjectsAction viewInMappedObjectsAction = new ViewInMappedObjectsAction(this._resources, this.getEntryPanel(), this._hibernateChannel);
        JMenuItem mnuViewInMappedObjects = this.addToSQLEntryAreaMenu((Action)((Object)viewInMappedObjectsAction), "viewinmappedobjects");
        this._resources.configureMenuItem((Action)((Object)viewInMappedObjectsAction), mnuViewInMappedObjects);
        this.registerKeyboardAction((Action)((Object)viewInMappedObjectsAction), this._resources.getKeyStroke((Action)((Object)viewInMappedObjectsAction)));
    }

    private void onViewInObjectTree(ISession session) {
        System.out.println("HQLEntryPanelManager.onViewInObjectTree");
    }

    private void onCopySqlToClip(ISession session) {
        try {
            HibernateSQLUtil.copySqlToClipboard(this._hibernateChannel.getHibernateConnection(), this.getEntryPanel().getSQLToBeExecuted(), session);
            session.showMessage(s_stringMgr.getString("HQLEntryPanelManager.copySqlToClipSucceeded"));
        }
        catch (Throwable t) {
            HqlQueryErrorUtil.handleHqlQueryError(t, session, true);
        }
    }

    private void onEscapeDate() {
        String str = EditExtrasAccessor.escapeDate(this.getEntryPanel());
        if (null != str) {
            this.getEntryPanel().replaceSelection(str);
        }
    }

    private void initBookmarks() {
        HQLBookmarksAction hba = new HQLBookmarksAction(this.getSession().getApplication(), (Resources)this._resources, this.getEntryPanel());
        JMenuItem item = this.addToSQLEntryAreaMenu((Action)((Object)hba), "bookmarkselect");
        this._resources.configureMenuItem((Action)((Object)hba), item);
        this.registerKeyboardAction((Action)((Object)hba), this._resources.getKeyStroke((Action)((Object)hba)));
    }

    private void initToolsPopUp() {
        this._toolsPopupController = new ToolsPopupController(this.getSession(), this.getEntryPanel());
        HQLToolsPopUpAction htp = new HQLToolsPopUpAction(this._resources, this._toolsPopupController, this.getSession().getApplication());
        JMenuItem item = this.addToSQLEntryAreaMenu((Action)((Object)htp), null);
        this._resources.configureMenuItem((Action)((Object)htp), item);
        this.registerKeyboardAction((Action)((Object)htp), this._resources.getKeyStroke((Action)((Object)htp)));
    }

    private void initCodeCompletion() {
        HQLCompleteCodeAction hcca = new HQLCompleteCodeAction(this.getSession().getApplication(), this._resources, this, this._hibernateChannel, this._hqlSyntaxHighlightTokenMatcherProxy, this.getSession());
        JMenuItem item = this.addToSQLEntryAreaMenu((Action)((Object)hcca), "complete");
        this._resources.configureMenuItem((Action)((Object)hcca), item);
        this.registerKeyboardAction((Action)((Object)hcca), this._resources.getKeyStroke((Action)((Object)hcca)));
    }

    private ISyntaxHighlightTokenMatcherFactory createSyntaxHighlightTokenMatcherFactory() {
        return new ISyntaxHighlightTokenMatcherFactory(){

            public ISyntaxHighlightTokenMatcher getSyntaxHighlightTokenMatcher(ISession sess, JTextComponent editorPane) {
                HQLEntryPanelManager.this._hqlSyntaxHighlightTokenMatcherProxy.setEditorPane(editorPane);
                return HQLEntryPanelManager.this._hqlSyntaxHighlightTokenMatcherProxy;
            }
        };
    }

    private void onUnquoteHQL() {
        EditExtrasAccessor.unquoteHQL(this.getEntryPanel());
    }

    private void onQuoteHQLSb() {
        EditExtrasAccessor.quoteHQLSb(this.getEntryPanel());
    }

    private void onQuoteHQL() {
        EditExtrasAccessor.quoteHQL(this.getEntryPanel());
    }

    public JMenuItem addToSQLEntryAreaMenu(Action action, String toolsPopupSelectionString) {
        if (null != toolsPopupSelectionString) {
            this._toolsPopupController.addAction(toolsPopupSelectionString, action);
        }
        return this.getEntryPanel().addToSQLEntryAreaMenu(action);
    }

    public void registerKeyboardAction(Action action, KeyStroke keyStroke) {
        JTextArea comp = this.getEntryPanel().getTextComponent();
        comp.registerKeyboardAction(action, keyStroke, 1);
    }

    public void selectWidgetOrTab() {
    }

    public Frame getOwningFrame() {
        return GUIUtils.getOwningFrame((Component)this.getComponent());
    }

    public void appendSQLScript(String sqlScript, boolean select) {
        this.getEntryPanel().appendText(sqlScript, select);
    }

    public void setEntireSQLScript(String sqlScript) {
        this.getEntryPanel().setText(sqlScript);
    }

    public ISession getSession() {
        return super.getSession();
    }

    public String getEntireSQLScript() {
        return this.getEntryPanel().getText();
    }

    public int getCaretPosition() {
        return this.getEntryPanel().getCaretPosition();
    }

    public void setCaretPosition(int caretPos) {
        this.getEntryPanel().setCaretPosition(caretPos);
    }

    public JTextArea getTextComponent() {
        return this.getEntryPanel().getTextComponent();
    }

    public FileHandler getFileHandler() {
        return this._fileHandler;
    }

    public ISQLPanelAPI getSQLPanelAPIOrNull() {
        return null;
    }
}

