/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.rmi.RemoteException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.JdbcConnectionData;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.TimeOutUtil;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.RMISecurityManagerWrappedCall;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateSqlConnectionData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HqlQueryResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ServerMain;

public class HibernateConnection {
    private static final ILogger s_log = LoggerController.createLogger(HibernateConnection.class);
    private final HibernateServerConnection _hibernateServerConnection;
    private final boolean _process;
    private final ServerMain _serverMain;
    private final boolean _endProcessOnDisconnect;
    private ArrayList<MappedClassInfo> _mappedClassInfos;
    private RMISecurityManagerWrappedCall _rmiSecurityManagerWrappedCall = new RMISecurityManagerWrappedCall();

    public HibernateConnection(HibernateServerConnection hibernateServerConnection, boolean process, ServerMain serverMain, boolean endProcessOnDisconnect) {
        this._hibernateServerConnection = hibernateServerConnection;
        this._process = process;
        this._serverMain = serverMain;
        this._endProcessOnDisconnect = endProcessOnDisconnect;
    }

    public String generateSQL(String hqlQuery) {
        try {
            if (this._process) {
                return this._rmiSecurityManagerWrappedCall.call(() -> this._hibernateServerConnection.generateSQL(hqlQuery));
            }
            return this._hibernateServerConnection.generateSQL(hqlQuery);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (this._process) {
            if (this._endProcessOnDisconnect) {
                try {
                    TimeOutUtil.invokeWithTimeout(() -> this._hibernateServerConnection.closeConnection());
                }
                catch (Throwable t) {
                    s_log.error((Object)"Error closing Hibernate connection.", t);
                }
                try {
                    TimeOutUtil.invokeWithTimeout(() -> this._serverMain.exit());
                }
                catch (Throwable t) {}
            }
        } else {
            try {
                TimeOutUtil.invokeWithTimeout(() -> this._hibernateServerConnection.closeConnection());
            }
            catch (Throwable t) {
                s_log.error((Object)"Error closing Hibernate connection.", t);
            }
        }
    }

    public ArrayList<MappedClassInfo> getMappedClassInfos() {
        try {
            if (null == this._mappedClassInfos) {
                this._mappedClassInfos = new ArrayList();
                ArrayList mappedClassInfoData = this._process ? this._rmiSecurityManagerWrappedCall.call(() -> this._hibernateServerConnection.getMappedClassInfoData()) : this._hibernateServerConnection.getMappedClassInfoData();
                for (MappedClassInfoData aMappedClassInfoData : mappedClassInfoData) {
                    this._mappedClassInfos.add(new MappedClassInfo(aMappedClassInfoData));
                }
            }
            return this._mappedClassInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HibernateSqlConnectionData getHibernateSqlConnectionData() {
        try {
            return this._hibernateServerConnection.getHibernateSqlConnectionData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HqlQueryResult createQueryList(String hqlQuery, int sqlNbrRowsToShow, JdbcConnectionData jdbcData) {
        if (this._process) {
            return this._rmiSecurityManagerWrappedCall.call(() -> this.callCreateQueryList(hqlQuery, sqlNbrRowsToShow, jdbcData));
        }
        return this.callCreateQueryList(hqlQuery, sqlNbrRowsToShow, jdbcData);
    }

    private HqlQueryResult callCreateQueryList(String hqlQuery, int sqlNbrRowsToShow, JdbcConnectionData jdbcData) {
        try {
            if (null == jdbcData) {
                return this._hibernateServerConnection.createQueryList(hqlQuery, sqlNbrRowsToShow);
            }
            return this._hibernateServerConnection.createQueryList(hqlQuery, sqlNbrRowsToShow, jdbcData.getDriverClassName(), jdbcData.getUrl(), jdbcData.getUser(), jdbcData.getPassword());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

