/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandlerUtil;
import net.sourceforge.squirrel_sql.client.preferences.GlobalPreferencesSheet;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.ButtonTabComponent;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.plugins.hibernate.ConnectionListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLPanelController;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateChannel;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePrefsListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateTabPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibnerateConnector;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibnerateConnectorListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HqlResultPanelManager;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.HibernateConfigPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedObjectController;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HibernateUtil;

public class HibernateTabController
implements IMainPanelTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HibernateTabController.class);
    private static ILogger s_log = LoggerController.createLogger(HibernateTabController.class);
    private final HibernateChannel _hibernateChannel;
    private HibernateTabPanel _hibernateTabPanel;
    private ISession _session;
    private HibernatePlugin _plugin;
    private static final String PREF_KEY_LAST_SELECTED_CONFIG = "SQuirreL.hibernateplugin.lastSelectedConfig";
    private HibernateConnection _con;
    private HibnerateConnector _hibnerateConnector;
    private HibernatePluginResources _resource;
    private HQLPanelController _hqlPanelController;
    private ArrayList<ConnectionListener> _listeners = new ArrayList();
    private HqlResultPanelManager _hqlResultPanelManager;
    private MappedObjectController _mappedObjectsController;
    private final TitleFilePathHandler _titleFileHandler;

    public HibernateTabController(ISession session, HibernatePlugin plugin, HibernatePluginResources resource) {
        this._resource = resource;
        try {
            this._session = session;
            this._plugin = plugin;
            this._titleFileHandler = new TitleFilePathHandler(() -> this.setSqlTabComponentTitle());
            this._hibernateChannel = new HibernateChannel(this);
            this._hqlPanelController = new HQLPanelController(this._hibernateChannel, this._session, resource, this._titleFileHandler);
            this._hqlResultPanelManager = new HqlResultPanelManager(this._session, resource);
            this._mappedObjectsController = new MappedObjectController(this._hibernateChannel, this._session, resource);
            this._hibernateTabPanel = new HibernateTabPanel(this._mappedObjectsController.getComponent(), this._hqlPanelController.getComponent(), this._hqlResultPanelManager.getComponent(), this._resource);
            this._hibernateTabPanel.btnConnected.setIcon(resource.getIcon("disconnected"));
            HibnerateConnectorListener hibnerateConnectorListener = new HibnerateConnectorListener(){

                @Override
                public void connected(HibernateConnection con, HibernateConfiguration cfg) {
                    HibernateTabController.this.onConnected(con, cfg);
                }

                @Override
                public void connectFailed(Throwable t) {
                    HibernateTabController.this.onConnectFailed(t);
                }
            };
            this._hibnerateConnector = new HibnerateConnector(this._plugin, hibnerateConnectorListener);
            this._hibernateTabPanel.btnConnected.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HibernateTabController.this.onConnect();
                }
            });
            this._hibernateTabPanel.btnOpenConfigs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HibernateTabController.this.onOpenConfigs();
                }
            });
            this._hibernateTabPanel.tabHibernateTabbedPane.addChangeListener(e -> this.onTabChanged());
            this.loadConfigsFromXml();
            this._hqlPanelController.initActions();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void setSqlTabComponentTitle() {
        TitleFilePathHandlerUtil.setTitle((String)this._hibernateTabPanel.getHqlTabTitle(), (TitleFilePathHandler)this._titleFileHandler, (ButtonTabComponent)this._hibernateTabPanel.tabComponentOfHqlTab);
    }

    private void onTabChanged() {
        this._session.getSessionInternalFrame().getSessionPanel().performStateChanged();
    }

    private void onOpenConfigs() {
        this._plugin.setHibernatePrefsListener(new HibernatePrefsListener(){

            @Override
            public void configurationChanged(ArrayList<HibernateConfiguration> changedCfgs) {
                HibernateTabController.this.onConfigurationChanged(changedCfgs);
            }

            @Override
            public HibernateConfiguration getPreselectedCfg() {
                return HibernateTabController.this.onGetPreselectedCfg();
            }
        });
        GlobalPreferencesSheet.showSheet(HibernateConfigPanel.class);
    }

    private HibernateConfiguration onGetPreselectedCfg() {
        return (HibernateConfiguration)this._hibernateTabPanel.cboConfigurations.getSelectedItem();
    }

    private void onConfigurationChanged(ArrayList<HibernateConfiguration> changedCfgs) {
        HibernateConfiguration selCfg = (HibernateConfiguration)this._hibernateTabPanel.cboConfigurations.getSelectedItem();
        if (null != selCfg) {
            this.loadConfigs(changedCfgs, selCfg.getName());
        } else {
            this.loadConfigs(changedCfgs, null);
        }
    }

    private void loadConfigsFromXml() throws IOException, XMLException {
        XMLBeanReader reader = HibernateUtil.createHibernateConfigsReader(this._plugin);
        if (null != reader) {
            this.loadConfigs((Iterable)reader, Props.getString((String)PREF_KEY_LAST_SELECTED_CONFIG, null));
        }
    }

    private void loadConfigs(Iterable reader, String cfgNameToSelect) {
        this._hibernateTabPanel.cboConfigurations.removeAllItems();
        HashMap<String, HibernateConfiguration> cfgByName = new HashMap<String, HibernateConfiguration>();
        for (Object o : reader) {
            HibernateConfiguration cfg = (HibernateConfiguration)o;
            cfgByName.put(cfg.getName(), cfg);
            this._hibernateTabPanel.cboConfigurations.addItem(cfg);
        }
        if (null != cfgNameToSelect) {
            this._hibernateTabPanel.cboConfigurations.setSelectedItem(cfgByName.get(cfgNameToSelect));
        }
    }

    private void onConnect() {
        if (null == this._con) {
            if (null != this._hibernateTabPanel.cboConfigurations.getSelectedItem()) {
                this._hibernateTabPanel.btnConnected.setEnabled(false);
                this._hibernateTabPanel.btnConnected.setDisabledSelectedIcon(this._resource.getIcon("connecting"));
                this._hibernateTabPanel.btnConnected.repaint();
                this._hibnerateConnector.connect((HibernateConfiguration)this._hibernateTabPanel.cboConfigurations.getSelectedItem(), this._session);
            } else {
                this._hibernateTabPanel.btnConnected.setSelected(false);
                int opt = JOptionPane.showConfirmDialog((Component)this._session.getApplication().getMainFrame(), s_stringMgr.getString("HQLTabController.noConfigSelected"));
                if (0 == opt) {
                    GlobalPreferencesSheet.showSheet(HibernateConfigPanel.class);
                }
            }
        } else {
            this._hibernateTabPanel.btnConnected.setIcon(this._resource.getIcon("disconnected"));
            try {
                this.closeConnection();
            }
            catch (Exception e) {
                s_log.error((Object)e);
            }
            finally {
                this._con = null;
                this._hqlPanelController.setConnection(null);
            }
        }
    }

    private void onConnected(HibernateConnection con, HibernateConfiguration cfg) {
        this._con = con;
        this._hibernateTabPanel.btnConnected.setIcon(this._resource.getIcon("connected"));
        this._hibernateTabPanel.btnConnected.setEnabled(true);
        this._hibernateTabPanel.cboConfigurations.setEnabled(false);
        this._hqlPanelController.setConnection(con);
        for (ConnectionListener listener : this._listeners) {
            listener.connectionOpened(con, cfg);
        }
    }

    private void onConnectFailed(Throwable t) {
        this._hibernateTabPanel.btnConnected.setIcon(this._resource.getIcon("disconnected"));
        this._hibernateTabPanel.btnConnected.setEnabled(true);
        this._hibernateTabPanel.btnConnected.setSelected(false);
        this._session.showErrorMessage(t);
        s_log.error((Object)t);
        this._con = null;
        this._hqlPanelController.setConnection(null);
        if (Utilities.getDeepestThrowable((Throwable)t) instanceof StackOverflowError) {
            String warnMessage = s_stringMgr.getString("hibernate.stackOverFlowMessage");
            this._session.showWarningMessage(warnMessage);
            s_log.warn((Object)warnMessage);
        }
    }

    public String getTitle() {
        return s_stringMgr.getString("HQLTabController.title");
    }

    public Component getTabComponent() {
        return null;
    }

    public String getHint() {
        return s_stringMgr.getString("HQLTabController.hint");
    }

    public Component getComponent() {
        return this._hibernateTabPanel;
    }

    public void sessionClosing(ISession session) {
        HibernateConfiguration cfg = (HibernateConfiguration)this._hibernateTabPanel.cboConfigurations.getSelectedItem();
        if (null != cfg) {
            Props.putString((String)PREF_KEY_LAST_SELECTED_CONFIG, (String)cfg.getName());
        }
        this._hibernateTabPanel.closing();
        this._mappedObjectsController.closing();
    }

    public void select() {
        this._hqlPanelController.requestFocus();
    }

    public void setSession(ISession session) {
    }

    public void addToToolbar(AbstractAction action) {
        JButton btn = new JButton(action);
        Dimension size = btn.getPreferredSize();
        size.height = this._hibernateTabPanel.btnConnected.getPreferredSize().height;
        btn.setPreferredSize(size);
        this._hibernateTabPanel.addToToolbar(btn);
    }

    public void displayObjects(HibernateConnection con, String hqlQuery) {
        this._hqlResultPanelManager.displayObjects(con, hqlQuery);
    }

    public void sessionEnding() {
        if (null != this._con) {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        this._con.close();
        this._hibernateTabPanel.cboConfigurations.setEnabled(true);
        for (ConnectionListener listener : this._listeners) {
            listener.connectionClosed();
        }
    }

    public HibernateConnection getHibernateConnection() {
        return this._con;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this._listeners.add(connectionListener);
    }

    public void mouseWheelClickedOnTabComponent() {
    }

    public void rightMouseClickedOnTabComponent(int clickPosX, int clickPosY) {
    }

    public IFileEditorAPI getActiveFileEditorAPIOrNull() {
        if (this.isHqlEditorTabActive()) {
            return this._hqlPanelController.getFileEditorAPIOrNull();
        }
        return null;
    }

    private boolean isHqlEditorTabActive() {
        return this._hibernateTabPanel.tabHibernateTabbedPane.getSelectedComponent() == this._hibernateTabPanel.splitHqlSql;
    }

    public void viewInMappedObjects(String wordAtCursor) {
        if (this._mappedObjectsController.viewInMappedObjects(wordAtCursor)) {
            this._hibernateTabPanel.tabHibernateTabbedPane.setSelectedIndex(0);
        }
    }

    public SQLPanel getSqlPanelOrNull() {
        return null;
    }
}

