/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.completion;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.Completor;
import net.sourceforge.squirrel_sql.fw.completion.CompletorListener;
import net.sourceforge.squirrel_sql.fw.completion.ICompletorModel;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLEntryPanelManager;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateChannel;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.HqlSyntaxHighlightTokenMatcherProxy;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLAliasFinder;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLCodeCompletorModel;

public class HQLCompleteCodeAction
extends SquirrelAction {
    private ISQLEntryPanel _hqlEntryPanel;
    private HibernateChannel _hibernateChannel;
    private Completor _cc;
    private HQLCodeCompletorModel _model;

    public HQLCompleteCodeAction(IApplication app, HibernatePluginResources resources, HQLEntryPanelManager hqlEntryPanelManager, HibernateChannel hibernateChannel, HqlSyntaxHighlightTokenMatcherProxy hqlSyntaxHighlightTokenMatcherProxy, ISession session) {
        super(app, (IResources)resources);
        this._hqlEntryPanel = hqlEntryPanelManager.getEntryPanel();
        this._hibernateChannel = hibernateChannel;
        this._model = new HQLCodeCompletorModel(hibernateChannel, new HQLAliasFinder(this._hqlEntryPanel), hqlSyntaxHighlightTokenMatcherProxy);
        CompletorListener completorListener = new CompletorListener(){

            public void completionSelected(CompletionInfo completion, int replaceBegin, int keyCode, int modifiers) {
                HQLCompleteCodeAction.this.performCompletionSelected(completion, replaceBegin, keyCode, modifiers);
            }
        };
        this._cc = new Completor((JTextComponent)this._hqlEntryPanel.getTextComponent(), (ICompletorModel)this._model, completorListener);
        session.addSimpleSessionListener(new SimpleSessionListener(){

            public void sessionClosed() {
                HQLCompleteCodeAction.this._cc.disposePopup();
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        if (null != this._hibernateChannel.getHibernateConnection()) {
            this._cc.show();
        }
    }

    private void performCompletionSelected(CompletionInfo completion, int replaceBegin, int keyCode, int modifiers) {
        if (32 == keyCode && modifiers == 128) {
            CompletionCandidates completionCandidates = this._model.getCompletionCandidates(this._cc.getTextTillCaret());
            this._hqlEntryPanel.setSelectionStart(replaceBegin);
            this._hqlEntryPanel.setSelectionEnd(this._hqlEntryPanel.getCaretPosition());
            this._hqlEntryPanel.replaceSelection(completionCandidates.getAllCandidatesPrefix(true));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HQLCompleteCodeAction.this._cc.show();
                }
            });
        } else if (9 == keyCode) {
            this._hqlEntryPanel.setSelectionStart(replaceBegin);
            this._hqlEntryPanel.setSelectionEnd(this.getNextWhiteSpacePos(this._hqlEntryPanel.getCaretPosition()));
            this._hqlEntryPanel.replaceSelection(completion.getCompletionString());
        } else {
            this._hqlEntryPanel.setSelectionStart(replaceBegin);
            this._hqlEntryPanel.setSelectionEnd(this._hqlEntryPanel.getCaretPosition());
            this._hqlEntryPanel.replaceSelection(completion.getCompletionString());
        }
    }

    private int getNextWhiteSpacePos(int startPos) {
        int retPos;
        String text = this._hqlEntryPanel.getText();
        for (retPos = startPos; retPos < text.length(); ++retPos) {
            if (!Character.isWhitespace(text.charAt(retPos))) continue;
            return retPos;
        }
        return retPos;
    }
}

