/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ClassPathItem;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ClassPathUtil;

public class ClassPathItemListModel
extends DefaultListModel {
    public String[] getClassPathArray() {
        ClassPathItem[] classPathItems = this.getItemArray();
        return ClassPathUtil.classPathAsStringArray(classPathItems);
    }

    private ClassPathItem[] getItemArray() {
        ClassPathItem[] ret = new ClassPathItem[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            ret[i] = (ClassPathItem)this.get(i);
        }
        return ret;
    }

    public ClassPathItem getClassPathItemAt(int i) {
        return (ClassPathItem)this.get(i);
    }

    public void addJar(String path) {
        this._addEntry(path, false);
    }

    public void addJarDir(String path) {
        this._addEntry(path, true);
    }

    private void _addEntry(String path, boolean jarDir) {
        ClassPathItem item = this.createClassPathItem(path, jarDir);
        super.addElement(item);
    }

    private ClassPathItem createClassPathItem(String path, boolean jarDir) {
        ClassPathItem item = new ClassPathItem();
        item.setPath(path);
        item.setJarDir(jarDir);
        return item;
    }

    public void addElement(Object obj) {
        throw new UnsupportedOperationException("Use addJar() or addJarDir()");
    }

    public void addItem(ClassPathItem item) {
        super.addElement(item);
    }

    public int[] replaceByJarDirs(List<ClassPathItem> toReplaceItems, File[] dirs) {
        List<ClassPathItem> newItems = Arrays.stream(dirs).map(f -> this.createClassPathItem(f.getPath(), true)).collect(Collectors.toList());
        return this.replaceItems(toReplaceItems, newItems);
    }

    public int[] replaceByJars(List<ClassPathItem> toReplaceItems, File[] entries) {
        List<ClassPathItem> newItems = Arrays.stream(entries).map(f -> this.createClassPathItem(f.getPath(), false)).collect(Collectors.toList());
        return this.replaceItems(toReplaceItems, newItems);
    }

    private int[] replaceItems(List<ClassPathItem> toReplaceItems, List<ClassPathItem> newItems) {
        int insertIndex = this.indexOf(toReplaceItems.get(0));
        toReplaceItems.forEach(i -> this.remove(this.indexOf(i)));
        for (int i2 = newItems.size() - 1; i2 > -1; --i2) {
            ClassPathItem classPathItem = newItems.get(i2);
            this.insertElementAt(classPathItem, insertIndex);
        }
        return this.indexesOf(newItems);
    }

    private int[] indexesOf(List<ClassPathItem> items) {
        return items.stream().mapToInt(i -> this.indexOf(i)).toArray();
    }
}

