/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.CopyConfigDlg;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;

public class CopyConfigCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CopyConfigCtrl.class);
    private final CopyConfigDlg _dlg;
    private JComboBox _cboConfigs;
    private String _newName;

    public CopyConfigCtrl(Frame owningFrame, HibernateConfiguration selConfig, JComboBox cboConfigs) {
        this._dlg = new CopyConfigDlg(owningFrame);
        this._cboConfigs = cboConfigs;
        this._dlg.txtNewName.setText(this.suggestCopyName(selConfig));
        this._dlg.btnOk.addActionListener(e -> this.onOk());
        this._dlg.btnCancel.addActionListener(e -> this.onCancel());
        GUIUtils.enableCloseByEscape((JDialog)this._dlg);
        GUIUtils.initLocation((Window)this._dlg, (int)300, (int)150);
        this._dlg.setVisible(true);
    }

    private void onCancel() {
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onOk() {
        if (StringUtilities.isEmpty((String)this._dlg.txtNewName.getText(), (boolean)true)) {
            JOptionPane.showMessageDialog(GUIUtils.getOwningFrame((Component)this._dlg), s_stringMgr.getString("CopyConfigCtrl.copy.config.name.must.not.be.empty"));
            return;
        }
        String newName = this._dlg.txtNewName.getText().trim();
        for (int i = 0; i < this._cboConfigs.getItemCount(); ++i) {
            HibernateConfiguration config = (HibernateConfiguration)this._cboConfigs.getItemAt(i);
            if (!newName.equals(config.getName())) continue;
            JOptionPane.showMessageDialog(GUIUtils.getOwningFrame((Component)this._dlg), s_stringMgr.getString("CopyConfigCtrl.copy.config.name.exists"));
            return;
        }
        this._newName = newName;
        this.close();
    }

    private String suggestCopyName(HibernateConfiguration selConfig) {
        int postFix = 1;
        while (true) {
            String newName = selConfig.getName() + "_" + postFix;
            boolean exists = false;
            for (int i = 0; i < this._cboConfigs.getItemCount(); ++i) {
                HibernateConfiguration config = (HibernateConfiguration)this._cboConfigs.getItemAt(i);
                if (!newName.equals(config.getName())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                return newName;
            }
            ++postFix;
        }
    }

    public String getCopiedConfigName() {
        return this._newName;
    }
}

