/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.io.File;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ServerMainImpl;

public class ProcessDetails {
    private String _command;
    private int _port = 23366;
    private boolean _endProcessOnDisconnect = true;
    private HibernatePlugin _plugin;

    public ProcessDetails(HibernatePlugin plugin) {
        this._plugin = plugin;
        this.initCommandDefault(false);
    }

    private void initCommandDefault(boolean runInConsole) {
        String osName = System.getProperty("os.name");
        this._command = osName.startsWith("Mac OS") ? this.createLinuxCommand(this._plugin, runInConsole) : (osName.startsWith("Windows") ? this.createWindowsCommand(this._plugin, runInConsole) : this.createLinuxCommand(this._plugin, runInConsole));
    }

    private String createWindowsCommand(HibernatePlugin plugin, boolean runInConsole) {
        String consolePrefix = "";
        if (runInConsole) {
            consolePrefix = "cmd.exe /c start ";
        }
        String java = "\"" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java\"";
        String command = consolePrefix + java + " -cp " + this.getPluginJarFilePath(plugin) + " " + ServerMainImpl.class.getName() + " -port:" + this._port;
        return command;
    }

    private String createLinuxCommand(HibernatePlugin plugin, boolean runInConsole) {
        String prefix = "";
        if (runInConsole) {
            prefix = "xterm -hold -e ";
        }
        String java = "\"" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java\"";
        String command = prefix + java + " -cp " + this.getPluginJarFilePath(plugin) + " " + ServerMainImpl.class.getName() + " -port:" + this._port;
        return command;
    }

    private String getPluginJarFilePath(HibernatePlugin plugin) {
        return "\"" + plugin.getPluginJarFilePath() + "\"";
    }

    public void apply(HibernateConfiguration cfg) {
        cfg.setCommand(this._command);
        cfg.setEndProcessOnDisconnect(this._endProcessOnDisconnect);
        cfg.setProcessPort(this._port);
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public void setEndProcessOnDisconnect(boolean endProcessOnDisconnect) {
        this._endProcessOnDisconnect = endProcessOnDisconnect;
    }

    public String getCommand() {
        return this._command;
    }

    public boolean isEndProcessOnDisconnect() {
        return this._endProcessOnDisconnect;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String restoreDefault(boolean runInConsole) {
        this.initCommandDefault(runInConsole);
        return this._command;
    }
}

