/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.mapping;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.hibernate.ConnectionListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateChannel;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.DetailPanelController;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfoTreeWrapper;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedObjectPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedObjectTreeRightMouseHandler;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappingRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappingTreeCellRenderer;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfoTreeWrapper;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import org.apache.commons.lang3.StringUtils;

public class MappedObjectController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MappedObjectController.class);
    private static final String PERF_KEY_OBJ_TAB_CHKSHOWQUALIFIED = "Squirrel.hibernateplugin.chkShowQualified";
    private MappedObjectPanel _panel;
    private HibernateChannel _hibernateChannel;
    private ISession _session;
    private DefaultMutableTreeNode _root;
    private HashMap<String, MappedClassInfo> _mappedClassInfoByClassName;
    private DetailPanelController _detailPanelController;
    private ArrayList<MappedClassInfoTreeWrapper> _mappedClassInfoTreeWrappers;

    public MappedObjectController(HibernateChannel hibernateChannel, ISession session, HibernatePluginResources resource) {
        this._hibernateChannel = hibernateChannel;
        this._session = session;
        this._detailPanelController = new DetailPanelController(this._session);
        this._panel = new MappedObjectPanel(this._detailPanelController.getDetailComponent());
        this._root = new DefaultMutableTreeNode(new MappingRoot());
        this._panel.treMappedObjects.setModel(new DefaultTreeModel(this._root));
        this._panel.treMappedObjects.setCellRenderer(new MappingTreeCellRenderer(resource));
        this.nodeStructurChanged(this._root);
        this._panel.treMappedObjects.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                MappedObjectController.this.onTreeExpanded(event);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this._panel.treMappedObjects.addTreeSelectionListener(e -> this.onTreeSelectionChanged(e));
        this._panel.treMappedObjects.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MappedObjectTreeRightMouseHandler.maybeShowTreePopup(e, MappedObjectController.this._panel.treMappedObjects);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MappedObjectTreeRightMouseHandler.maybeShowTreePopup(e, MappedObjectController.this._panel.treMappedObjects);
            }
        });
        this._hibernateChannel.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionOpened(HibernateConnection con, HibernateConfiguration cfg) {
                MappedObjectController.this.initRoot(con, cfg);
                MappedObjectController.this.initTree(con);
            }

            @Override
            public void connectionClosed() {
                MappedObjectController.this.onConnectionClosed();
            }
        });
        this._panel.chkShowQualified.addActionListener(e -> this.onChkQualified());
        this._panel.chkShowQualified.setSelected(Props.getBoolean((String)PERF_KEY_OBJ_TAB_CHKSHOWQUALIFIED, (boolean)false));
    }

    private void initRoot(HibernateConnection con, HibernateConfiguration cfg) {
        MappingRoot mr = (MappingRoot)this._root.getUserObject();
        mr.init(con, cfg);
    }

    private void onChkQualified() {
        HibernateConnection con = this._hibernateChannel.getHibernateConnection();
        if (null == con) {
            return;
        }
        this._root.removeAllChildren();
        this.initTree(con);
    }

    private void onTreeSelectionChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        if (null != n && null != n.getUserObject()) {
            this._detailPanelController.selectionChanged(n.getUserObject());
        } else {
            this._detailPanelController.clearDetail();
        }
    }

    private void onTreeExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode mappedClassInfoWrapperNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        Object userObject = mappedClassInfoWrapperNode.getUserObject();
        if (userObject instanceof MappedClassInfoTreeWrapper && !((MappedClassInfoTreeWrapper)userObject).isExpanded()) {
            for (int i = 0; i < mappedClassInfoWrapperNode.getChildCount(); ++i) {
                DefaultMutableTreeNode propertyInfoNode = (DefaultMutableTreeNode)mappedClassInfoWrapperNode.getChildAt(i);
                PropertyInfoTreeWrapper propertyInfoTreeWrapper = (PropertyInfoTreeWrapper)propertyInfoNode.getUserObject();
                MappedClassInfo mappedClassInfo = propertyInfoTreeWrapper.getMappedClassInfo();
                this.addMappedClassInfoNode(this.createMappedClassInfoTreeWrapper(mappedClassInfo), propertyInfoNode);
            }
            ((MappedClassInfoTreeWrapper)userObject).setExpanded(true);
            this.nodeStructurChanged(mappedClassInfoWrapperNode);
        }
    }

    private MappedClassInfoTreeWrapper createMappedClassInfoTreeWrapper(MappedClassInfo mappedClassInfo) {
        return new MappedClassInfoTreeWrapper(mappedClassInfo, this._panel.chkShowQualified.isSelected());
    }

    private void onConnectionClosed() {
        MappingRoot mr = (MappingRoot)this._root.getUserObject();
        mr.clear();
        this._root.removeAllChildren();
        this.nodeStructurChanged(this._root);
        this._detailPanelController.clearDetail();
    }

    private void initTree(HibernateConnection con) {
        ArrayList<MappedClassInfo> mappedClassInfos = con.getMappedClassInfos();
        ArrayList<MappedClassInfoTreeWrapper> wrappers = this.initMappedClassInfos(mappedClassInfos);
        for (MappedClassInfoTreeWrapper wrapper : wrappers) {
            this.addMappedClassInfoNode(wrapper, this._root);
        }
        this.nodeStructurChanged(this._root);
    }

    private void nodeStructurChanged(DefaultMutableTreeNode node) {
        ((DefaultTreeModel)this._panel.treMappedObjects.getModel()).nodeStructureChanged(node);
    }

    private void addMappedClassInfoNode(MappedClassInfoTreeWrapper mappedClassInfoTreeWrapper, DefaultMutableTreeNode parent) {
        PropertyInfo[] propertyInfos;
        this._mappedClassInfoTreeWrappers.add(mappedClassInfoTreeWrapper);
        DefaultMutableTreeNode mappedClassInfoNode = new DefaultMutableTreeNode(mappedClassInfoTreeWrapper);
        for (PropertyInfo propertyInfo : propertyInfos = mappedClassInfoTreeWrapper.getMappedClassInfo().getAttributes()) {
            String className = propertyInfo.getHibernatePropertyInfo().getClassName();
            if (!this._mappedClassInfoByClassName.containsKey(className)) continue;
            PropertyInfoTreeWrapper propertyInfoTreeWrapper = new PropertyInfoTreeWrapper(propertyInfo, this._mappedClassInfoByClassName.get(className));
            DefaultMutableTreeNode propertyInfoNode = new DefaultMutableTreeNode(propertyInfoTreeWrapper);
            mappedClassInfoNode.add(propertyInfoNode);
        }
        parent.add(mappedClassInfoNode);
    }

    private ArrayList<MappedClassInfoTreeWrapper> initMappedClassInfos(ArrayList<MappedClassInfo> mappedClassInfos) {
        ArrayList<MappedClassInfoTreeWrapper> ret = new ArrayList<MappedClassInfoTreeWrapper>();
        this._mappedClassInfoByClassName = new HashMap();
        for (MappedClassInfo mappedClassInfo : mappedClassInfos) {
            this._mappedClassInfoByClassName.put(mappedClassInfo.getClassName(), mappedClassInfo);
            ret.add(this.createMappedClassInfoTreeWrapper(mappedClassInfo));
        }
        this._mappedClassInfoTreeWrappers = new ArrayList();
        Collections.sort(ret);
        return ret;
    }

    public JComponent getComponent() {
        return this._panel;
    }

    public void closing() {
        this._panel.closing();
        Props.putBoolean((String)PERF_KEY_OBJ_TAB_CHKSHOWQUALIFIED, (boolean)this._panel.chkShowQualified.isSelected());
    }

    public boolean viewInMappedObjects(String wordAtCursor) {
        for (int i = 0; i < this._root.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this._root.getChildAt(i);
            MappedClassInfoTreeWrapper mappedClassInfoTreeWrapper = (MappedClassInfoTreeWrapper)childNode.getUserObject();
            if (!MappedObjectController.matchesEntityClassName(wordAtCursor, mappedClassInfoTreeWrapper.getMappedClassInfo().getClassName())) continue;
            TreePath selectionPath = new TreePath(childNode.getPath());
            this._panel.treMappedObjects.setSelectionPath(selectionPath);
            this._panel.treMappedObjects.scrollPathToVisible(selectionPath);
            return true;
        }
        if (!StringUtilities.isEmpty((String)wordAtCursor, (boolean)true)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("MappedObjectController.failed.to.locate", new Object[]{wordAtCursor}));
        }
        return false;
    }

    private static boolean matchesEntityClassName(String wordAtCursor, String className) {
        if (StringUtils.contains((CharSequence)wordAtCursor, (CharSequence)".")) {
            return StringUtils.equals((CharSequence)className, (CharSequence)wordAtCursor);
        }
        return StringUtils.endsWith((CharSequence)className, (CharSequence)("." + wordAtCursor));
    }
}

