/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;

public class MappedClassInfoData
implements Serializable {
    private String _mappedClassName;
    private String _tableName;
    private String _simpleMappedClassName;
    private HibernatePropertyInfo _indentifierHibernatePropertyInfo;
    private HibernatePropertyInfo[] _hibernatePropertyInfos;
    private boolean _plainValueArray;

    public MappedClassInfoData(String mappedClassName, String tableName, HibernatePropertyInfo indentifierHibernatePropertyInfo, HibernatePropertyInfo[] hibernatePropertyInfos) {
        this._indentifierHibernatePropertyInfo = indentifierHibernatePropertyInfo;
        this._hibernatePropertyInfos = hibernatePropertyInfos;
        this._mappedClassName = mappedClassName;
        this._tableName = tableName;
        this._simpleMappedClassName = this.extracteSimpleClassName(mappedClassName);
    }

    public String getMappedClassName() {
        return this._mappedClassName;
    }

    public String getSimpleMappedClassName() {
        return this._simpleMappedClassName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public HibernatePropertyInfo getIndentifierHibernatePropertyInfo() {
        return this._indentifierHibernatePropertyInfo;
    }

    public HibernatePropertyInfo[] getHibernatePropertyInfos() {
        return this._hibernatePropertyInfos;
    }

    private String extracteSimpleClassName(String mappedClassName) {
        String[] cpTokens = mappedClassName.split("\\.");
        return cpTokens[cpTokens.length - 1];
    }

    public boolean isPlainValueArray() {
        return this._plainValueArray;
    }

    public void setPlainValueArray(boolean plainValueArray) {
        this._plainValueArray = plainValueArray;
    }
}

