/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.FactoryWrapper;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ReflectionCaller;

public class MappedClassInfoLoader {
    public static HashMap<String, MappedClassInfoData> getMappedClassInfos(FactoryWrapper factoryWrapper, ClassLoader cl, String jpaRootPackage, boolean server) {
        HashMap<String, MappedClassInfoData> infoDataByClassName = new HashMap<String, MappedClassInfoData>();
        Collection<ReflectionCaller> entityTypes = new ReflectionCaller(factoryWrapper.getEntityManagerFactory(), false).callMethod("getMetamodel").callCollectionMethod("getEntities");
        for (ReflectionCaller entityType : entityTypes) {
            if (null == entityType.callMethod("getJavaType").getCallee()) {
                System.out.println("Entity " + entityType.getCallee() + " has no Java type and won't be loaded.");
                continue;
            }
            ReflectionCaller getIdTypeCaller = entityType.callMethod("getIdType");
            if (null == getIdTypeCaller.getCallee()) {
                System.out.println("Entity type " + entityType.callMethod("getJavaType").callMethod("getName").getCallee() + " has no unique ID and won't be loaded.");
                continue;
            }
            ReflectionCaller pkJavaType = getIdTypeCaller.callMethod("getJavaType");
            ReflectionCaller pkSingularAttribute = entityType.callMethod("getId", pkJavaType.getCallee()).setTreatClassCalleeAsType(false);
            String identifierPropertyName = (String)pkSingularAttribute.callMethod("getJavaMember").callMethod("getName").getCallee();
            String identifierPropertyClassName = (String)pkSingularAttribute.callMethod("getJavaType").callMethod("getName").getCallee();
            String tableName = MappedClassInfoLoader.getTableName(cl, jpaRootPackage, entityType);
            String identifierColumnName = MappedClassInfoLoader.getMappedColumnName(cl, jpaRootPackage, entityType, identifierPropertyName);
            HibernatePropertyInfo identifierPropInfo = new HibernatePropertyInfo(identifierPropertyName, identifierPropertyClassName, tableName, new String[]{identifierColumnName});
            identifierPropInfo.setIdentifier(true);
            ArrayList<HibernatePropertyInfo> infos = new ArrayList<HibernatePropertyInfo>();
            for (ReflectionCaller attr : entityType.callCollectionMethod("getAttributes")) {
                String propertyName = (String)attr.callMethod("getJavaMember").callMethod("getName").getCallee();
                Class propertyClass = (Class)attr.callMethod("getJavaType").getCallee();
                String[] propertyColumnNames = new String[]{MappedClassInfoLoader.getMappedColumnName(cl, jpaRootPackage, entityType, propertyName)};
                HibernatePropertyInfo hibernatePropertyInfo = null;
                if (ReflectionCaller.getClassPlain(jpaRootPackage + ".persistence.metamodel.PluralAttribute", cl).isAssignableFrom(attr.getCalleeClass())) {
                    propertyClass = (Class)attr.callMethod("getElementType").callMethod("getJavaType").getCallee();
                    hibernatePropertyInfo = new HibernatePropertyInfo(propertyName, propertyClass.getName(), tableName, propertyColumnNames);
                    hibernatePropertyInfo.setCollectionClassName((String)attr.callMethod("getJavaType").callMethod("getName").getCallee());
                } else if (Boolean.FALSE.equals(attr.callMethod("isId").getCallee())) {
                    hibernatePropertyInfo = new HibernatePropertyInfo(propertyName, propertyClass.getName(), tableName, propertyColumnNames);
                }
                if (null == hibernatePropertyInfo) continue;
                infos.add(hibernatePropertyInfo);
            }
            String entityClassName = (String)entityType.callMethod("getJavaType").callMethod("getName").getCallee();
            infoDataByClassName.put(entityClassName, new MappedClassInfoData(entityClassName, tableName, identifierPropInfo, infos.toArray(new HibernatePropertyInfo[infos.size()])));
        }
        return infoDataByClassName;
    }

    private static String getMappedColumnName(ClassLoader cl, String jpaRootPackage, ReflectionCaller entity, String propertyName) {
        ReflectionCaller columnAnno;
        String columnName;
        Method identifierMethod;
        Class entityClass = (Class)entity.callMethod("getJavaType").getCallee();
        String identifierColumnName = propertyName;
        if (null != MappedClassInfoLoader.getDeclaredField(entityClass, propertyName)) {
            ReflectionCaller columnAnno2;
            String columnName2;
            Field identifiereField = MappedClassInfoLoader.getDeclaredField(entityClass, propertyName);
            if (identifiereField.isAnnotationPresent(ReflectionCaller.getClassPlain(jpaRootPackage + ".persistence.Column", cl)) && null != (columnName2 = (String)(columnAnno2 = new ReflectionCaller(identifiereField.getAnnotation(ReflectionCaller.getClassPlain(jpaRootPackage + ".persistence.Column", cl)), false)).callMethod("name").getCallee())) {
                identifierColumnName = columnName2;
            }
        } else if (null != MappedClassInfoLoader.getDeclaredMethod(entityClass, propertyName) && (identifierMethod = MappedClassInfoLoader.getDeclaredMethod(entityClass, propertyName)).isAnnotationPresent(ReflectionCaller.getClassPlain(jpaRootPackage + ".persistence.Column", cl)) && null != (columnName = (String)(columnAnno = new ReflectionCaller(identifierMethod.getAnnotation(ReflectionCaller.getClassPlain(jpaRootPackage + ".persistence.Column", cl)), false)).callMethod("name").getCallee())) {
            identifierColumnName = columnName;
        }
        return identifierColumnName;
    }

    private static Method getDeclaredMethod(Class entityClass, String identifierPropertyName) {
        try {
            return entityClass.getDeclaredMethod(identifierPropertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Field getDeclaredField(Class entityClass, String identifierPropertyName) {
        try {
            return entityClass.getDeclaredField(identifierPropertyName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static String getTableName(ClassLoader cl, String jpaRootPackage, ReflectionCaller entityType) {
        ReflectionCaller tableAnno;
        String tableName = (String)entityType.callMethod("getName").getCallee();
        Class entityJavaType = (Class)entityType.callMethod("getJavaType").getCallee();
        if (entityJavaType.isAnnotationPresent(ReflectionCaller.getClassPlain(jpaRootPackage + ".persistence.Table", cl)) && null != (tableAnno = new ReflectionCaller(entityJavaType.getAnnotation(ReflectionCaller.getClassPlain(jpaRootPackage + ".persistence.Table", cl)))).callMethod("name")) {
            tableName = (String)tableAnno.callMethod("name").getCallee();
        }
        return tableName;
    }
}

