/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.PlainValue;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.PropertySubstitute;

public class ObjectSubstitute
implements Serializable {
    private HashMap<String, PropertySubstitute> _substituteValueByPropertyName = new HashMap();
    private MappedClassInfoData _mappedClassInfoData;
    private String _toString;
    public static final String PLAIN_VALUES = "<plain values>";
    private boolean _isPrimitiveTypePersistentCollection = false;
    private HashMap<String, PlainValue> _plainValueByPropertyName = new HashMap();

    ObjectSubstitute(MappedClassInfoData mappedClassInfoData, String toString) {
        this._mappedClassInfoData = mappedClassInfoData;
        this._toString = toString;
    }

    ObjectSubstitute(ClassLoader cl, Collection<Object> primitiveOrUnknownObjectCollection) {
        this._isPrimitiveTypePersistentCollection = true;
        this._toString = "<plain values> size=" + primitiveOrUnknownObjectCollection.size() + ", values: " + this.primitiveOrUnknownObjectCollectionAsString(primitiveOrUnknownObjectCollection, cl);
        Optional<Object> any = primitiveOrUnknownObjectCollection.stream().filter(Objects::nonNull).findAny();
        String className = any.isEmpty() ? "<unknown>" : any.get().getClass().getName();
        Object propertyName = "value 1";
        HibernatePropertyInfo indentifierHibernatePropertyInfo = new HibernatePropertyInfo((String)propertyName, className, "<unknown>", new String[]{"<unknown>"});
        this._plainValueByPropertyName.put((String)propertyName, new PlainValue(this.toPrimitiveType(any.orElse(null), cl), indentifierHibernatePropertyInfo));
        HibernatePropertyInfo[] hibernatePropertyInfos = new HibernatePropertyInfo[primitiveOrUnknownObjectCollection.size() - 1];
        ArrayList<Object> primitiveOrUnknownObjectList = new ArrayList<Object>(primitiveOrUnknownObjectCollection);
        for (int i = 1; i < primitiveOrUnknownObjectList.size(); ++i) {
            className = null == primitiveOrUnknownObjectList.get(i) ? "<unknown>" : primitiveOrUnknownObjectList.get(i).getClass().getName();
            propertyName = "value " + (i + 1);
            hibernatePropertyInfos[i - 1] = new HibernatePropertyInfo((String)propertyName, className, "<unknown>", new String[]{"<unknown>"});
            this._plainValueByPropertyName.put((String)propertyName, new PlainValue(this.toPrimitiveType(primitiveOrUnknownObjectList.get(i), cl), hibernatePropertyInfos[i - 1]));
        }
        this._mappedClassInfoData = new MappedClassInfoData(PLAIN_VALUES, "<unknown>", indentifierHibernatePropertyInfo, hibernatePropertyInfos);
        this._mappedClassInfoData.setPlainValueArray(true);
    }

    private String primitiveOrUnknownObjectCollectionAsString(Collection<Object> plainValueCollection, ClassLoader cl) {
        StringBuilder ret = new StringBuilder();
        int count = 0;
        for (Object o : plainValueCollection) {
            if (0 == count) {
                ret.append(this.toPrimitiveType(o, cl));
            } else {
                ret.append(";").append(this.toPrimitiveType(o, cl));
            }
            if (++count <= 20) continue;
            ret.append(" ...");
            break;
        }
        return ret.toString();
    }

    private Object toPrimitiveType(Object o, ClassLoader cl) {
        if (null == o || o.getClass().getName().startsWith("java.")) {
            return o;
        }
        return this.transformToString(o, cl);
    }

    private String transformToString(Object o, ClassLoader cl) {
        StringBuilder sb = new StringBuilder();
        try {
            Field[] declaredFields = o.getClass().getDeclaredFields();
            boolean valueAppended = false;
            for (Field f : declaredFields) {
                if (valueAppended) {
                    sb.append("|");
                    valueAppended = false;
                }
                try {
                    f.setAccessible(true);
                    Object fieldVal = f.get(o);
                    String fieldName = f.getName();
                    if (HibernateServerUtil.isInitialized(cl, fieldVal)) {
                        sb.append(fieldName + "=" + fieldVal);
                        valueAppended = true;
                        continue;
                    }
                    sb.append(fieldName + "=<uninitialized>");
                    valueAppended = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            sb.append("" + o);
        }
        return sb.toString();
    }

    void putSubstituteValueByPropertyName(String propertyName, PropertySubstitute propertySubstitute) {
        if (this._isPrimitiveTypePersistentCollection) {
            throw new IllegalStateException("Should not be called for plain values");
        }
        this._substituteValueByPropertyName.put(propertyName, propertySubstitute);
    }

    public String getClassName() {
        return this._mappedClassInfoData.getMappedClassName();
    }

    public Object getValue(String propertyName) {
        if (!this._isPrimitiveTypePersistentCollection) {
            return this._substituteValueByPropertyName.get(propertyName).getSingleValue();
        }
        return this._plainValueByPropertyName.get(propertyName).getValue();
    }

    public String getTypeName(String propertyName) {
        if (!this._isPrimitiveTypePersistentCollection) {
            return this._substituteValueByPropertyName.get(propertyName).getHibernatePropertyInfo().getClassName();
        }
        return this._plainValueByPropertyName.get(propertyName).getHibernatePropertyInfo().getClassName();
    }

    public boolean wasInitialized(String propertyName) {
        if (!this._isPrimitiveTypePersistentCollection) {
            return this._substituteValueByPropertyName.get(propertyName).isInitialized();
        }
        return true;
    }

    public Collection<? extends ObjectSubstitute> getPersistentCollection(String propertyName) {
        return this._substituteValueByPropertyName.get(propertyName).getObjectSubstituteCollection();
    }

    public boolean isPrimitiveTypePersistentCollection(String propertyName) {
        if (!this._isPrimitiveTypePersistentCollection) {
            return this._substituteValueByPropertyName.get(propertyName).isPersistenCollection();
        }
        return false;
    }

    public boolean isNull(String propertyName) {
        if (!this._isPrimitiveTypePersistentCollection) {
            return this._substituteValueByPropertyName.get(propertyName).isNull();
        }
        return null == this._plainValueByPropertyName.get(propertyName).getValue();
    }

    public HibernatePropertyInfo getHibernatePropertyInfo(String propertyName) {
        if (!this._isPrimitiveTypePersistentCollection) {
            return this._substituteValueByPropertyName.get(propertyName).getHibernatePropertyInfo();
        }
        return this._plainValueByPropertyName.get(propertyName).getHibernatePropertyInfo();
    }

    public String toString() {
        return this._toString;
    }

    public MappedClassInfoData getPrimitiveTypePersistentCollectionClassInfo() {
        if (!this._isPrimitiveTypePersistentCollection) {
            return null;
        }
        return this._mappedClassInfoData;
    }
}

