/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstitute;

public class PropertySubstitute
implements Serializable {
    private HibernatePropertyInfo _hibernatePropertyInfo;
    private ArrayList<ObjectSubstitute> _objectSubstituteCollection;
    private Object _plainValue;
    private ObjectSubstitute _objectSubstitute;
    private boolean _initialized;

    PropertySubstitute(HibernatePropertyInfo hibernatePropertyInfo, ObjectSubstitute objectSubstitute, boolean isInitialized) {
        this._hibernatePropertyInfo = hibernatePropertyInfo;
        this._objectSubstitute = objectSubstitute;
        this._initialized = isInitialized;
    }

    PropertySubstitute(HibernatePropertyInfo hibernatePropertyInfo, ArrayList<ObjectSubstitute> objectSubstituteCollection, boolean isInitialized) {
        this._hibernatePropertyInfo = hibernatePropertyInfo;
        this._objectSubstituteCollection = objectSubstituteCollection;
        this._initialized = isInitialized;
    }

    PropertySubstitute(HibernatePropertyInfo hibernatePropertyInfo, Object plainValue, boolean isInitialized) {
        this._hibernatePropertyInfo = hibernatePropertyInfo;
        this._plainValue = plainValue;
        if (null != plainValue) {
            if (plainValue.getClass().isEnum()) {
                this._plainValue = this.getEnumConstantName(plainValue);
            } else if (!this.isJDKClass(plainValue.getClass())) {
                String plainValueToString;
                try {
                    plainValueToString = "" + plainValue;
                }
                catch (Exception e) {
                    plainValueToString = "<Failed to represent as string>, Error message: " + e;
                }
                this._plainValue = "Type: " + plainValue.getClass().getName() + "; toString: " + plainValueToString;
            }
        }
        this._initialized = isInitialized;
    }

    private boolean isJDKClass(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return true;
        }
        URL classUrl = clazz.getResource(className.replace('.', '/') + ".class");
        if (classUrl == null) {
            return false;
        }
        String classPath = classUrl.toString();
        return classPath.startsWith("jar:file:") && classPath.contains("rt.jar");
    }

    private String getEnumConstantName(Object plainValue) {
        try {
            Class<?> enumClass = plainValue.getClass();
            for (Field declaredField : enumClass.getDeclaredFields()) {
                declaredField.setAccessible(true);
                if (!declaredField.isEnumConstant() || declaredField.get(enumClass) != plainValue) continue;
                return declaredField.getName();
            }
            return "<unknown>";
        }
        catch (Throwable e) {
            return "<unknown> " + e;
        }
    }

    public HibernatePropertyInfo getHibernatePropertyInfo() {
        return this._hibernatePropertyInfo;
    }

    public ArrayList<ObjectSubstitute> getObjectSubstituteCollection() {
        return this._objectSubstituteCollection;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public Object getSingleValue() {
        if (null != this._objectSubstituteCollection) {
            throw new IllegalStateException("Is a collection");
        }
        if (null == this._plainValue) {
            return this._objectSubstitute;
        }
        return this._plainValue;
    }

    public boolean isPersistenCollection() {
        return null != this._objectSubstituteCollection;
    }

    public boolean isNull() {
        return null == this._objectSubstituteCollection && null == this._objectSubstitute && null == this._plainValue;
    }
}

