/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;

public class HibernateUtil {
    private static final ILogger s_log = LoggerController.createLogger(HibernateUtil.class);
    private static FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();
    private static IOUtilities ioutils = new IOUtilitiesImpl();
    public static final String OBJECT_IS_NULL = "<object is null>";
    public static final String UNITIALIZED_PERSISTENT_COLLECTION = "<unitialized persistent collection>";

    public static XMLBeanReader createHibernateConfigsReader(HibernatePlugin plugin) throws IOException, XMLException {
        XMLBeanReader reader = new XMLBeanReader();
        FileWrapper pluginUserSettingsFolder = plugin.getPluginUserSettingsFolder();
        FileWrapper xmlFile = HibernateUtil.getXmlFile(pluginUserSettingsFolder);
        if (!xmlFile.exists()) {
            return null;
        }
        reader.load(xmlFile, ((Object)((Object)plugin)).getClass().getClassLoader());
        return reader;
    }

    private static FileWrapper getXmlFile(FileWrapper pluginUserSettingsFolder) {
        FileReader fr = null;
        BufferedReader br = null;
        FileWriter fw = null;
        PrintWriter pw = null;
        FileWrapper xmlFile = null;
        try {
            FileWrapper xmlFileOld = fileWrapperFactory.create(pluginUserSettingsFolder, "hibernateConfigs.xml");
            xmlFile = fileWrapperFactory.create(pluginUserSettingsFolder, "hibernateConfigs32.xml");
            if (xmlFileOld.exists() && !xmlFile.exists()) {
                fr = xmlFileOld.getFileReader();
                br = new BufferedReader(fr);
                fw = xmlFile.getFileWriter();
                pw = new PrintWriter(fw);
                String line = br.readLine();
                while (null != line) {
                    String s = line.replaceAll("net.sourceforge.squirrel_sql.plugins.hibernate.configuration.HibernateConfiguration", "net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration");
                    pw.println(s);
                    line = br.readLine();
                }
                br.close();
                fr.close();
                pw.flush();
                fw.flush();
                pw.close();
                fw.close();
            }
        }
        catch (Exception e) {
            try {
                s_log.error((Object)("Unexpected exception while attempting to get hibernate config xml file (hibernateConfigs32.xml) from settings directory (" + pluginUserSettingsFolder));
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ioutils.closeReader(br);
                ioutils.closeReader(fr);
                ioutils.flushWriter(pw);
                ioutils.flushWriter(fw);
                ioutils.closeWriter(pw);
                ioutils.closeWriter(fw);
                throw throwable;
            }
        }
        ioutils.closeReader(br);
        ioutils.closeReader(fr);
        ioutils.flushWriter(pw);
        ioutils.flushWriter(fw);
        ioutils.closeWriter(pw);
        ioutils.closeWriter((Writer)fw);
        return xmlFile;
    }

    public static String getSimpleClassName(String mappedClassName) {
        String[] cpTokens = mappedClassName.split("\\.");
        return cpTokens[cpTokens.length - 1];
    }

    public static void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        HibernateUtil.fileWrapperFactory = fileWrapperFactory;
    }
}

