/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.util;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.SquirrelHibernateServerException;

public class HqlQueryErrorUtil {
    private static ILogger s_log = LoggerController.createLogger(HqlQueryErrorUtil.class);

    public static String handleHqlQueryError(Throwable e, ISession sess, boolean showInMessagePanel) {
        Object ret = null;
        Throwable t = Utilities.getDeepestThrowable((Throwable)e);
        ExceptionFormatter formatter = sess.getExceptionFormatter();
        try {
            if (t instanceof SquirrelHibernateServerException) {
                SquirrelHibernateServerException serverException = (SquirrelHibernateServerException)t;
                ret = serverException.getOriginalMessage();
                if (!serverException.getOriginalMessage().equals(serverException.getExceptionToString())) {
                    ret = (String)ret + "\n" + serverException.getExceptionToString();
                }
            } else {
                ret = formatter.format(t);
            }
            if (showInMessagePanel) {
                sess.showErrorMessage((String)ret);
            }
        }
        catch (Exception e1) {
            sess.showErrorMessage((Throwable)e1);
            sess.showErrorMessage(t);
        }
        if (sess.getProperties().getWriteSQLErrorsToLog() || HqlQueryErrorUtil.isHibernateException(t)) {
            s_log.error((Object)t);
        }
        return ret;
    }

    private static boolean isHibernateException(Throwable t) {
        String className = t instanceof SquirrelHibernateServerException ? ((SquirrelHibernateServerException)t).getOriginalExceptionClassName() : t.getClass().getName();
        return -1 == className.toLowerCase().indexOf("hibernate") && -1 == className.toLowerCase().indexOf("antlr");
    }
}

