/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstitute;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.HibernatePropertyReader;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.PersistentCollectionResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class ResultDataSet
implements IDataSet {
    private static final int DISPLAY_WIDTH = 20;
    private int _curIx = -1;
    private ColumnDisplayDefinition[] _columnDisplayDefinitions;
    private SingleType _singleType;

    public ResultDataSet(SingleType singleType) {
        this._singleType = singleType;
        ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions = new ArrayList<ColumnDisplayDefinition>();
        for (PropertyInfo propertyInfo : singleType.getMappedClassInfo().getAttributes()) {
            String propertyName = propertyInfo.getHibernatePropertyInfo().getPropertyName();
            columnDisplayDefinitions.add(new ColumnDisplayDefinition(20, propertyName));
        }
        this._columnDisplayDefinitions = columnDisplayDefinitions.toArray(new ColumnDisplayDefinition[columnDisplayDefinitions.size()]);
    }

    public int getColumnCount() throws DataSetException {
        return this._columnDisplayDefinitions.length;
    }

    public DataSetDefinition getDataSetDefinition() throws DataSetException {
        return new DataSetDefinition(this._columnDisplayDefinitions);
    }

    public boolean next(IMessageHandler msgHandler) throws DataSetException {
        return ++this._curIx < this._singleType.getResults().size();
    }

    public Object get(int columnIndex) throws DataSetException {
        ObjectSubstitute obj = this._singleType.getResults().get(this._curIx).getObject();
        if (null == obj) {
            return "<object is null>";
        }
        HibernatePropertyReader hpr = new HibernatePropertyReader(this._columnDisplayDefinitions[columnIndex].getColumnName(), obj);
        if (hpr.isNull()) {
            return "<null>";
        }
        MappedClassInfo mappedClassInfo = ViewObjectsUtil.findMappedClassInfo(hpr.getTypeName(), this._singleType.getAllMappedClassInfos(), true);
        if (hpr.isPersistenCollection()) {
            if (!hpr.wasInitialized()) {
                return "<unitialized persistent collection>";
            }
            if (null == mappedClassInfo) {
                return ViewObjectsUtil.getPrimitivePersistentCollectionString(hpr);
            }
            PropertyInfo propertyInfo = new PropertyInfo(hpr.getHibernatePropertyInfo(), hpr.getHibernatePropertyInfo().getClassName());
            propertyInfo.setMappedClassInfo(mappedClassInfo);
            return new PersistentCollectionResult(hpr, propertyInfo, this._singleType.getAllMappedClassInfos());
        }
        if (null != mappedClassInfo && !mappedClassInfo.isPlainValueArray()) {
            return new SingleResult((ObjectSubstitute)hpr.getValue(), mappedClassInfo);
        }
        return hpr.getValue();
    }
}

