/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.WaitPanelListener;

public class WaitPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(WaitPanel.class);
    private MultipleLineLabel _label;
    private boolean _isDisplayingError;
    private JButton _btnClose;
    private WaitPanelListener _waitPanelListener;

    public WaitPanel(String hqlQuery, HibernatePluginResources resource, WaitPanelListener waitPanelListener) {
        this._waitPanelListener = waitPanelListener;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createCloseButtonPanel(resource), "North");
        this.add((Component)this.createLabelPanel(hqlQuery), "Center");
        this.setMinimumSize(new Dimension(0, 0));
    }

    private JPanel createLabelPanel(String hqlQuery) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("WaitPanel.hqlLabel")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0);
        this._label = new MultipleLineLabel(hqlQuery);
        ret.add((Component)this._label, gbc);
        return ret;
    }

    private JPanel createCloseButtonPanel(HibernatePluginResources resource) {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)new JPanel(), "Center");
        this._btnClose = new JButton(resource.getIcon("close"));
        this._btnClose.setMargin(new Insets(0, 0, 0, 0));
        this._btnClose.setBorderPainted(false);
        this._btnClose.setVisible(false);
        ret.add((Component)this._btnClose, "East");
        this._btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitPanel.this._waitPanelListener.removeWaitPanel(WaitPanel.this);
            }
        });
        return ret;
    }

    public String getTitle() {
        return s_stringMgr.getString("WaitPanel.title");
    }

    public boolean isDisplayingError() {
        return this._isDisplayingError;
    }

    public void displayError(Throwable t) {
        this.prepareForErrorDisplay();
        this._label.setText(s_stringMgr.getString("WaitPanel.errorOccured", new Object[]{Utilities.getExceptionStringSave((Throwable)t)}));
    }

    public void displayHqlQueryError(String errMsg) {
        this.prepareForErrorDisplay();
        this._label.setText(s_stringMgr.getString("WaitPanel.hqlErrorOccured", new Object[]{errMsg}));
    }

    private void prepareForErrorDisplay() {
        this._label.setBackground(Color.white);
        this._label.setForeground(Color.red);
        this._label.setFont(this._label.getFont().deriveFont(1));
        this._btnClose.setVisible(true);
        this._isDisplayingError = true;
    }
}

