/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.h2;

import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.h2.exp.H2SequenceInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.h2.exp.H2TableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.h2.exp.H2TableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.h2.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.IndexSourceTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.ViewSourceTab;

public class H2Plugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(H2Plugin.class);
    private static final ILogger s_log = LoggerController.createLogger(H2Plugin.class);

    public String getInternalName() {
        return "h2";
    }

    public String getDescriptiveName() {
        return "H2 Plugin";
    }

    public String getVersion() {
        return "0.02";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(session.getSessionInternalFrame().getObjectTreeAPI()));
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                H2Plugin.this.updateTreeApi(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
                H2Plugin.this.updateTreeApi((IObjectTreeAPI)objectTreePanel);
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isH2((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(IObjectTreeAPI objectTreeAPI) {
        IQueryTokenizer qt = objectTreeAPI.getSession().getQueryTokenizer();
        String stmtSep = qt.getSQLStatementSeparator();
        objectTreeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new H2SequenceInodeExpanderFactory(), DatabaseObjectType.SEQUENCE));
        TableWithChildNodesExpander tableExp = new TableWithChildNodesExpander();
        tableExp.setTableIndexExtractor((ITableIndexExtractor)new H2TableIndexExtractorImpl());
        tableExp.setTableTriggerExtractor((ITableTriggerExtractor)new H2TableTriggerExtractorImpl());
        objectTreeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExp);
        objectTreeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep));
        objectTreeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexSourceTab(i18n.SHOW_INDEX_SOURCE, stmtSep));
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailsTab());
    }

    static interface i18n {
        public static final String SHOW_INDEX_SOURCE = s_stringMgr.getString("PostgresPlugin.showIndexSource");
        public static final String SHOW_VIEW_SOURCE = s_stringMgr.getString("PostgresPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = s_stringMgr.getString("PostgresPlugin.showProcedureSource");
    }
}

