/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Substring
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;
    private Expression startLoc;
    private Expression endIndex;

    public F_Substring(Expression expression, Expression expression2, Expression expression3) {
        this.expr = expression;
        this.startLoc = expression2;
        this.endIndex = expression3;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        String string = (String)this.expr.evaluate(tuple);
        if (string == null) {
            return null;
        }
        Object object = this.startLoc.evaluate(tuple);
        int n = 0;
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        }
        if (n < 1) {
            n = 1;
        }
        int n2 = 0;
        int n3 = string.length();
        if (n > n3) {
            return "";
        }
        if (this.endIndex != null) {
            Object object2 = this.endIndex.evaluate(tuple);
            if (object2 == null) {
                return null;
            }
            if (object2 instanceof Number) {
                n2 = ((Number)object2).intValue() - n + 1;
            }
        } else {
            return string.substring(n - 1);
        }
        if (n2 <= 0) {
            return "";
        }
        if (n + n2 - 1 > n3) {
            return string.substring(n - 1);
        }
        return string.substring(n - 1, n + n2 - 1);
    }

    @Override
    public int getReturnType() {
        return 12;
    }

    public static int[] getParamListTypes() {
        return new int[]{12, 4, 4};
    }

    public static String getFunctionName() {
        return "SUBSTRING";
    }

    @Override
    public String toString(Relation relation) {
        if (this.endIndex != null) {
            return "SUBSTRING(" + this.expr.toString(relation) + ", " + this.startLoc.toString(relation) + ", " + this.endIndex.toString(relation) + ")";
        }
        return "SUBSTRING(" + this.expr.toString(relation) + ", " + this.startLoc.toString(relation) + ")";
    }
}

