/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.Expression;
import unity.functions.Interval;
import unity.mapping.DatabaseMapping;
import unity.operators.Operator;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQIntervalExpr
extends LQExprNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private LQExprNode valueExpr;
    private String intervalType;

    public LQIntervalExpr() {
        this.type = 143;
    }

    @Override
    public String generateSQL() {
        this.content = "INTERVAL";
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(this.valueExpr.generateSQL());
        arrayList.add(this.intervalType);
        return DatabaseMapping.convertUnity("INTERVAL", this, arrayList, this);
    }

    @Override
    public String toString() {
        return this.generateSQL();
    }

    public String toTimestampString() {
        if (this.valueExpr == null) {
            return "''";
        }
        return Interval.outputTimestamp(this.valueExpr.generateSQL(), LQIntervalExpr.getTypeCode(this.intervalType));
    }

    public static int getTypeCode(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("YEAR")) {
            n = 10000;
        } else if (string.equalsIgnoreCase("QUARTER")) {
            n = 10001;
        } else if (string.equalsIgnoreCase("MONTH")) {
            n = 10002;
        } else if (string.equalsIgnoreCase("WEEK")) {
            n = 10003;
        } else if (string.equalsIgnoreCase("DAY")) {
            n = 10004;
        } else if (string.equalsIgnoreCase("HOUR")) {
            n = 10005;
        } else if (string.equalsIgnoreCase("MINUTE")) {
            n = 10006;
        } else if (string.equalsIgnoreCase("SECOND")) {
            n = 10007;
        } else if (string.equalsIgnoreCase("MICROSECOND")) {
            n = 10008;
        } else if (string.equalsIgnoreCase("YEAR_MONTH")) {
            n = 10009;
        } else if (string.equalsIgnoreCase("DAY_HOUR")) {
            n = 10010;
        } else if (string.equalsIgnoreCase("DAY_MINUTE")) {
            n = 10011;
        } else if (string.equalsIgnoreCase("DAY_SECOND")) {
            n = 10012;
        } else if (string.equalsIgnoreCase("DAY_MICROSECOND")) {
            n = 10013;
        } else if (string.equalsIgnoreCase("HOUR_MINUTE")) {
            n = 10014;
        } else if (string.equalsIgnoreCase("HOUR_SECOND")) {
            n = 10015;
        } else if (string.equalsIgnoreCase("HOUR_MICROSECOND")) {
            n = 10016;
        } else if (string.equalsIgnoreCase("MINUTE_SECOND")) {
            n = 10017;
        } else if (string.equalsIgnoreCase("MINUTE_MICROSECOND")) {
            n = 10018;
        } else if (string.equalsIgnoreCase("SECOND_MICROSECOND")) {
            n = 10019;
        }
        return n;
    }

    @Override
    public Expression buildExpression(Relation relation, Attribute attribute, GlobalQuery globalQuery, SubQuery subQuery, Operator operator) throws SQLException {
        Expression expression = this.valueExpr.buildExpression(relation, attribute, globalQuery, subQuery, operator);
        int n = LQIntervalExpr.getTypeCode(this.intervalType);
        Interval interval = new Interval(expression, n);
        return interval;
    }

    @Override
    public Object clone() {
        try {
            LQExprNode lQExprNode = (LQExprNode)super.clone();
            if (this.children != null) {
                lQExprNode.children = new ArrayList(this.children.size());
                for (int i = 0; i < this.children.size(); ++i) {
                    lQExprNode.children.add((LQNode)((LQNode)this.children.get(i)).clone());
                }
            } else {
                lQExprNode.children = null;
            }
            return lQExprNode;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        GQDatabaseRef gQDatabaseRef2;
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        int n = DatabaseMapping.isSupported("INTERVAL", gQDatabaseRef, this);
        if (n != 0 && n != 1) {
            hashSet.add(GQDatabaseRef.UNITYJDBC_DBREF);
        }
        if (this.valueExpr != null && (gQDatabaseRef2 = this.valueExpr.setDatabase(gQDatabaseRef, bl)) != null) {
            hashSet.add(gQDatabaseRef2);
        }
        return hashSet;
    }

    public LQExprNode getValueExpr() {
        return this.valueExpr;
    }

    public void setValueExpr(LQExprNode lQExprNode) {
        this.valueExpr = lQExprNode;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(String string) {
        this.intervalType = string;
    }
}

