/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.fonts;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.sourceforge.napkinlaf.fonts.MergedFont;
import net.sourceforge.napkinlaf.fonts.MergedGlyphVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedFontGraphics2D
extends Graphics2D {
    private final Graphics2D g2d;
    private boolean isMergedFont;

    private MergedFontGraphics2D(Graphics2D g2d) {
        assert (!(g2d instanceof MergedFontGraphics2D)) : "double delegation";
        this.g2d = g2d;
        this.setFont(g2d.getFont());
    }

    @Override
    public void setFont(Font font) {
        this.isMergedFont = font instanceof MergedFont;
        this.g2d.setFont(font);
    }

    public static MergedFontGraphics2D wrap(Graphics2D g2d) {
        return g2d instanceof MergedFontGraphics2D ? (MergedFontGraphics2D)g2d : new MergedFontGraphics2D(g2d);
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.isMergedFont) {
            this.drawString(str, (float)x, (float)y);
        } else {
            this.g2d.drawString(str, x, y);
        }
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (this.isMergedFont) {
            Font font = this.getFont();
            FontRenderContext frc = this.getFontRenderContext();
            GlyphVector gVector = font.createGlyphVector(frc, s);
            this.drawGlyphVector(gVector, x, y);
        } else {
            this.g2d.drawString(s, x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (this.isMergedFont) {
            this.drawString(iterator, (float)x, (float)y);
        } else {
            this.g2d.drawString(iterator, x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.isMergedFont) {
            Font font = this.getFont();
            FontRenderContext frc = this.getFontRenderContext();
            GlyphVector gVector = font.createGlyphVector(frc, iterator);
            this.drawGlyphVector(gVector, x, y);
        } else {
            this.g2d.drawString(iterator, x, y);
        }
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        if (this.isMergedFont) {
            this.drawString(new String(data, offset, length), x, y);
        } else {
            this.g2d.drawBytes(data, offset, length, x, y);
        }
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        if (this.isMergedFont) {
            this.drawString(new String(data, offset, length), x, y);
        } else {
            this.g2d.drawChars(data, offset, length, x, y);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        if (g instanceof MergedGlyphVector) {
            MergedGlyphVector cgv = (MergedGlyphVector)g;
            int glyphIndex = 0;
            for (GlyphVector glyphVector : cgv.split()) {
                Point2D glyphPos = cgv.getGlyphPosition(glyphIndex);
                this.g2d.drawGlyphVector(glyphVector, (float)((double)x + glyphPos.getX()), (float)((double)y + glyphPos.getY()));
                glyphIndex += glyphVector.getNumGlyphs();
            }
        } else {
            this.g2d.drawGlyphVector(g, x, y);
        }
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        return new MergedFontGraphics2D((Graphics2D)this.g2d.create(x, y, width, height));
    }

    @Override
    public void dispose() {
    }

    public boolean equals(Object that) {
        return this == that || that instanceof MergedFontGraphics2D && this.g2d.equals(((MergedFontGraphics2D)that).getGraphics2D());
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.g2d.drawPolygon(p);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.g2d.fillPolygon(p);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return this.g2d.getClipBounds(r);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.g2d.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.g2d.draw3DRect(x, y, width, height, raised);
    }

    public int hashCode() {
        return this.g2d.hashCode();
    }

    @Override
    public String toString() {
        return this.g2d.toString();
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.g2d.drawRect(x, y, width, height);
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.g2d.hitClip(x, y, width, height);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.g2d.getFontMetrics();
    }

    @Override
    @Deprecated
    public Rectangle getClipRect() {
        return this.g2d.getClipRect();
    }

    @Override
    public void draw(Shape s) {
        this.g2d.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.g2d.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.g2d.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.g2d.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.g2d.drawRenderableImage(img, xform);
    }

    @Override
    public void fill(Shape s) {
        this.g2d.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.g2d.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2d.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.g2d.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.g2d.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.g2d.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.g2d.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.g2d.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.g2d.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.g2d.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g2d.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.g2d.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.g2d.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.g2d.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.g2d.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.g2d.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.g2d.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.g2d.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.g2d.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.g2d.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.g2d.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.g2d.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.g2d.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.g2d.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.g2d.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.g2d.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.g2d.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return new MergedFontGraphics2D((Graphics2D)this.g2d.create());
    }

    @Override
    public Color getColor() {
        return this.g2d.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.g2d.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.g2d.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.g2d.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.g2d.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.g2d.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.g2d.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.g2d.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.g2d.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.g2d.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.g2d.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g2d.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g2d.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.g2d.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.g2d.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.g2d.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.g2d.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.g2d.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g2d.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g2d.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.g2d.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.g2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.g2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }
}

