/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.ListIterator;
import net.sourceforge.napkinlaf.sketch.TemplateItem;
import net.sourceforge.napkinlaf.sketch.TemplateReadException;
import net.sourceforge.napkinlaf.sketch.XMLTemplateExtractor;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.util.NapkinUtil;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
implements Cloneable {
    private String title = "";
    private String description = "";
    private Rectangle clippingBounds;
    private int width;
    private int height;
    private LinkedList<TemplateItem> templateItems = new LinkedList();

    public Template(Point origin, Dimension dimensions) {
        this.clippingBounds = new Rectangle(origin, dimensions);
    }

    public Template() {
        this(new Point(), new Dimension());
    }

    public static Template createFromXML(String path) throws TemplateReadException, FileNotFoundException {
        Template template;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(path));
            template = Template.createFromXML(in);
        }
        catch (Throwable throwable) {
            NapkinUtil.tryClose(in);
            throw throwable;
        }
        NapkinUtil.tryClose(in);
        return template;
    }

    public static Template createFromXML(InputStream in) throws TemplateReadException {
        return new XMLTemplateExtractor().createTemplate(in);
    }

    public void add(TemplateItem templateItem) {
        this.templateItems.add(templateItem);
        this.computeWidthAndHeight();
    }

    private void computeWidthAndHeight() {
        int minx = 0;
        int maxx = 0;
        int miny = 0;
        int maxy = 0;
        for (TemplateItem t : this.templateItems) {
            SketchShape s = t.getShape();
            double tminx = s.getBounds2D().getMinX();
            double tmaxx = s.getBounds2D().getMaxX();
            double tminy = s.getBounds2D().getMinY();
            double tmaxy = s.getBounds2D().getMaxY();
            if (tminx < (double)minx) {
                minx = (int)Math.floor(tminx);
            }
            if (tminy < (double)miny) {
                miny = (int)Math.floor(tminy);
            }
            if (tmaxx > (double)maxx) {
                maxx = (int)Math.ceil(tmaxx);
            }
            if (!(tmaxy > (double)maxy)) continue;
            maxy = (int)Math.ceil(tmaxy);
        }
        this.width = maxx - minx;
        this.height = maxy - miny;
    }

    public ListIterator<TemplateItem> getListIterator() {
        return this.templateItems.listIterator();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getClippingBounds() {
        return this.clippingBounds;
    }

    public void setClippingBounds(Rectangle clippingBounds) {
        this.clippingBounds = clippingBounds;
    }

    public String produceXMLString() {
        StringWriter stringWriter = new StringWriter();
        try {
            new XMLOutputter(Format.getPrettyFormat()).output(this.produceXML(), (Writer)stringWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    public Document produceXML() {
        DefaultJDOMFactory f = new DefaultJDOMFactory();
        Element ret = f.element("template");
        for (TemplateItem templateItem : this.templateItems) {
            ret.addContent(templateItem.produceXML());
        }
        return f.document(ret);
    }

    public Template clone() {
        try {
            Template ret = (Template)super.clone();
            ret.templateItems = (LinkedList)this.templateItems.clone();
            ret.templateItems.clear();
            for (TemplateItem item : this.templateItems) {
                ret.templateItems.add(item.clone());
            }
            ret.clippingBounds = (Rectangle)this.clippingBounds.clone();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("cannot clone?", e);
        }
    }
}

