/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import net.sourceforge.napkinlaf.NapkinKnownTheme;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.borders.NapkinBorder;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.borders.NapkinCompoundBorder;
import net.sourceforge.napkinlaf.borders.NapkinWrappedBorder;
import net.sourceforge.napkinlaf.fonts.MergedFontGraphics2D;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnLineHolder;
import net.sourceforge.napkinlaf.util.AlphaColorUIResource;
import net.sourceforge.napkinlaf.util.NapkinBackground;
import net.sourceforge.napkinlaf.util.NapkinConstants;
import net.sourceforge.napkinlaf.util.NapkinDebug;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinRandom;
import net.sourceforge.napkinlaf.util.NapkinSmartListeners;
import net.sourceforge.napkinlaf.util.NapkinTextPainter;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.SmartStickyListener;

public class NapkinUtil {
    private static final Map<Float, Stroke> strokes = new WeakHashMap<Float, Stroke>();
    private static final BufferedImage textureImage;
    private static final float FOCUS_MARK_WIDTH = 1.5f;
    private static final Insets NO_INSETS;
    private static final int CLIP_OFFSET = 10;
    private static final int CLIP_INSET = 20;
    private static final NapkinBorder NAPKIN_NULL_BORDER;
    private static final AlphaComposite ERASURE_COMPOSITE;
    private static final Stack<NapkinTheme> themeStack;
    private static final Stack<Component> paperStack;
    private static SoftReference<BufferedImage> erasureBuffer;
    private static final DrawnLineHolder highLightLongLine;
    private static final DrawnLineHolder highLightShortLine;
    private static final Insets ZERO_INSETS;

    public static Object property(ComponentUI ui, String prop) {
        String name = ui.getClass().getName();
        String base = ".Napkin";
        int pos = name.lastIndexOf(base) + base.length();
        String pref = name.substring(pos, name.length() - 2);
        return pref + "." + prop;
    }

    static boolean replaceBackground(Color bgColor) {
        return bgColor == null || !(bgColor instanceof AlphaColorUIResource) && bgColor.getRed() == bgColor.getGreen() && bgColor.getGreen() == bgColor.getBlue();
    }

    static boolean isTranparent(Color bgColor) {
        return bgColor == NapkinConstants.CLEAR || bgColor == NapkinConstants.HIGHLIGHT_CLEAR;
    }

    public static void installUI(JComponent c) {
        if (c.getClientProperty("net.sourceforge.napkinlaf.installed") != Boolean.TRUE) {
            c.putClientProperty("net.sourceforge.napkinlaf.installed", Boolean.TRUE);
            NapkinLookAndFeel.registerComponent(c);
            if (c instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)c;
                c.putClientProperty("net.sourceforge.napkinlaf.wasRolloverEnabled", button.isRolloverEnabled());
                button.setRolloverEnabled(true);
                SmartStickyListener.hookListener(c, new NapkinSmartListeners.RolloverListener());
                Icon icon = button.getIcon();
                SmartStickyListener listener = new NapkinSmartListeners.ButtonIconListener();
                if (listener.shouldRecord(icon)) {
                    c.putClientProperty("net.sourceforge.napkinlaf.buttonIcon", icon);
                }
                listener.overrideValue(c, icon);
                SmartStickyListener.hookListener(c, listener);
                icon = button.getPressedIcon();
                listener = new NapkinSmartListeners.PressedIconListener();
                if (listener.shouldRecord(icon)) {
                    c.putClientProperty("net.sourceforge.napkinlaf.pressedIcon", icon);
                }
                listener.overrideValue(c, icon);
                SmartStickyListener.hookListener(c, listener);
                icon = button.getSelectedIcon();
                listener = new NapkinSmartListeners.SelectedIconListener();
                if (listener.shouldRecord(icon)) {
                    c.putClientProperty("net.sourceforge.napkinlaf.selectedIcon", icon);
                }
                listener.overrideValue(c, icon);
                SmartStickyListener.hookListener(c, listener);
                icon = button.getRolloverIcon();
                listener = new NapkinSmartListeners.RolloverIconListener();
                if (listener.shouldRecord(icon)) {
                    c.putClientProperty("net.sourceforge.napkinlaf.rolloverIcon", icon);
                }
                listener.overrideValue(c, icon);
                SmartStickyListener.hookListener(c, listener);
                icon = button.getRolloverSelectedIcon();
                listener = new NapkinSmartListeners.RolloverSelectedIconListener();
                if (listener.shouldRecord(icon)) {
                    c.putClientProperty("net.sourceforge.napkinlaf.rolloverSelectedIcon", icon);
                }
                listener.overrideValue(c, icon);
                SmartStickyListener.hookListener(c, listener);
                icon = button.getDisabledIcon();
                listener = new NapkinSmartListeners.DisabledIconListener();
                if (listener.shouldRecord(icon)) {
                    c.putClientProperty("net.sourceforge.napkinlaf.disabledIcon", icon);
                }
                listener.overrideValue(c, icon);
                SmartStickyListener.hookListener(c, listener);
                icon = button.getDisabledSelectedIcon();
                listener = new NapkinSmartListeners.DisabledSelectedIconListener();
                if (listener.shouldRecord(icon)) {
                    c.putClientProperty("net.sourceforge.napkinlaf.disabledSelectedIcon", icon);
                }
                listener.overrideValue(c, icon);
                SmartStickyListener.hookListener(c, listener);
            }
            Color bgColor = c.getBackground();
            c.putClientProperty("net.sourceforge.napkinlaf.background", bgColor);
            if (NapkinUtil.replaceBackground(bgColor)) {
                c.setBackground(NapkinConstants.CLEAR);
            }
            SmartStickyListener.hookListener(c, new NapkinSmartListeners.BackgroundListener());
            Border b = c.getBorder();
            Border nb = NapkinUtil.wrapBorder(b);
            if (nb != b) {
                c.putClientProperty("net.sourceforge.napkinlaf.border", b);
                try {
                    c.setBorder(nb);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SmartStickyListener.hookListener(c, new NapkinSmartListeners.BorderListener());
        }
    }

    public static void uninstallUI(JComponent c) {
        if (c.getClientProperty("net.sourceforge.napkinlaf.installed") == Boolean.TRUE) {
            c.putClientProperty("net.sourceforge.napkinlaf.installed", null);
            SmartStickyListener.unhookListeners(c);
            Border border = (Border)c.getClientProperty("net.sourceforge.napkinlaf.border");
            if (border != c.getBorder()) {
                c.setBorder(border);
            }
            c.setBackground((Color)c.getClientProperty("net.sourceforge.napkinlaf.background"));
            if (c instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)c;
                button.setDisabledSelectedIcon((Icon)c.getClientProperty("net.sourceforge.napkinlaf.disabledSelectedIcon"));
                button.setDisabledIcon((Icon)c.getClientProperty("net.sourceforge.napkinlaf.disabledIcon"));
                button.setRolloverSelectedIcon((Icon)c.getClientProperty("net.sourceforge.napkinlaf.rolloverSelectedIcon"));
                button.setRolloverIcon((Icon)c.getClientProperty("net.sourceforge.napkinlaf.rolloverIcon"));
                button.setSelectedIcon((Icon)c.getClientProperty("net.sourceforge.napkinlaf.selectedIcon"));
                button.setPressedIcon((Icon)c.getClientProperty("net.sourceforge.napkinlaf.pressedIcon"));
                button.setIcon((Icon)c.getClientProperty("net.sourceforge.napkinlaf.buttonIcon"));
                button.setRolloverEnabled((Boolean)c.getClientProperty("net.sourceforge.napkinlaf.wasRolloverEnabled"));
            }
            for (String clientProp : NapkinConstants.CLIENT_PROPERTIES) {
                c.putClientProperty(clientProp, null);
            }
        }
    }

    private static boolean isGlassPane(JComponent c) {
        JRootPane rootPane = c.getRootPane();
        return rootPane != null && rootPane.getGlassPane() == c;
    }

    public static double leftRight(double x, boolean left) {
        return left ? x : 100.0 - x;
    }

    public static Graphics2D copy(Graphics g) {
        return (Graphics2D)g.create();
    }

    public static Graphics2D lineGraphics(Graphics orig, float w) {
        return NapkinUtil.lineGraphics((Graphics2D)orig, w);
    }

    public static Graphics2D lineGraphics(Graphics orig, float w, int cap, int join) {
        return NapkinUtil.lineGraphics((Graphics2D)orig, w, cap, join);
    }

    public static Graphics2D lineGraphics(Graphics2D orig, float w) {
        return NapkinUtil.lineGraphics(orig, w, 1, 1);
    }

    public static Graphics2D lineGraphics(Graphics2D orig, float w, int cap, int join) {
        Graphics2D lineG = NapkinUtil.copy(orig);
        Stroke stroke = strokes.get(Float.valueOf(w));
        if (stroke == null) {
            stroke = new BasicStroke(w, cap, join);
            strokes.put(Float.valueOf(w), stroke);
        }
        lineG.setStroke(stroke);
        lineG.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        lineG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return lineG;
    }

    private static boolean canBeDisabled(Component c) {
        return !(c instanceof JTextComponent);
    }

    public static Graphics2D defaultGraphics(Graphics g1, Component c) {
        Graphics2D g = (Graphics2D)g1;
        NapkinUtil.syncWithTheme(g, c);
        boolean enabled = c.isEnabled();
        if (!enabled && NapkinUtil.canBeDisabled(c)) {
            Rectangle r = g.getClipBounds();
            int w = r.width + 20;
            int h = r.height + 20;
            BufferedImage tmp = erasureBuffer.get();
            if (tmp == null || tmp.getWidth() < w || tmp.getHeight() < h) {
                tmp = new BufferedImage(w, h, 2);
                erasureBuffer = new SoftReference<BufferedImage>(tmp);
            }
            Graphics2D tg = tmp.createGraphics();
            Composite origComp = tg.getComposite();
            tg.setComposite(AlphaComposite.Clear);
            tg.fillRect(0, 0, w, h);
            tg.setComposite(origComp);
            int offX = -r.x + 10;
            int offY = -r.y + 10;
            tg.translate(offX, offY);
            tg.setBackground(g.getBackground());
            tg.setClip(g.getClip());
            tg.setColor(g.getColor());
            tg.setComposite(g.getComposite());
            tg.setFont(g.getFont());
            tg.setPaint(g.getPaint());
            tg.setRenderingHints(g.getRenderingHints());
            tg.setStroke(g.getStroke());
            JComponent jc = (JComponent)c;
            DisabledMark mark = new DisabledMark(g, tmp, offX, offY);
            jc.putClientProperty("net.sourceforge.napkinlaf.disabledMark", mark);
            g = tg;
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g;
    }

    public static void syncWithTheme(Graphics2D g, Component c) {
        if (NapkinUtil.isPaper(c)) {
            paperStack.push(c);
            themeStack.push((NapkinTheme)((JComponent)c).getClientProperty("net.sourceforge.napkinlaf.theme"));
            NapkinUtil.dumpStacks();
        }
        NapkinTheme theme = NapkinUtil.currentTheme(c);
        Color themePen = theme.getPenColor();
        Color fgColor = NapkinUtil.ifReplace(c.getForeground(), themePen);
        if (!fgColor.equals(c.getForeground())) {
            c.setForeground(fgColor);
            if (g != null) {
                g.setColor(fgColor);
            }
        }
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            Color selColor = NapkinUtil.ifReplace(tc.getSelectedTextColor(), themePen);
            tc.setSelectedTextColor(selColor);
        }
    }

    public static void syncWithTheme(Border border, Component c) {
        if (border instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)border;
            Color pen = NapkinUtil.currentTheme(c).getPenColor();
            tb.setTitleColor(NapkinUtil.ifReplace(tb.getTitleColor(), pen));
        } else if (border instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)border;
            NapkinUtil.syncWithTheme(cb.getInsideBorder(), c);
            NapkinUtil.syncWithTheme(cb.getOutsideBorder(), c);
        }
    }

    public static NapkinTheme currentTheme(Component c) {
        return themeStack.isEmpty() ? (NapkinTheme)NapkinUtil.themeTopFor(c).getClientProperty("net.sourceforge.napkinlaf.theme") : themeStack.peek();
    }

    public static Component currentPaper(Component c) {
        return paperStack.isEmpty() ? NapkinUtil.themeTopFor(c) : paperStack.peek();
    }

    public static void finishGraphics(Graphics g1, Component c) {
        if (c == NapkinUtil.currentPaper(c)) {
            if (!paperStack.isEmpty()) {
                paperStack.pop();
            }
            if (!themeStack.isEmpty()) {
                themeStack.pop();
            }
            NapkinUtil.dumpStacks();
        }
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            DisabledMark mark = (DisabledMark)jc.getClientProperty("net.sourceforge.napkinlaf.disabledMark");
            if (mark == null) {
                Color bgColor = (Color)jc.getClientProperty("net.sourceforge.napkinlaf.bgWhenEnabled");
                if (bgColor != null) {
                    jc.putClientProperty("net.sourceforge.napkinlaf.bgWhenEnabled", null);
                    jc.setBackground(bgColor);
                }
            } else {
                jc.putClientProperty("net.sourceforge.napkinlaf.disabledMark", null);
                Color bgColor = jc.getBackground();
                if (jc.getClientProperty("net.sourceforge.napkinlaf.bgWhenEnabled") == null) {
                    jc.putClientProperty("net.sourceforge.napkinlaf.bgWhenEnabled", bgColor == null ? NapkinConstants.CLEAR : bgColor);
                    jc.setBackground(new AlphaColorUIResource(jc.getForeground().getRGB() & 0xFFFFFF));
                }
                Graphics2D tg = (Graphics2D)g1;
                tg.setComposite(ERASURE_COMPOSITE);
                Point start = NapkinUtil.getStart(jc, null);
                int w = textureImage.getWidth();
                int h = textureImage.getHeight();
                Rectangle anchor = new Rectangle(w - start.x, h - start.y, w, h);
                tg.setPaint(new TexturePaint(textureImage, anchor));
                tg.fillRect(0, 0, mark.image.getWidth(), mark.image.getHeight());
                mark.graphics.drawImage((Image)mark.image, -mark.offX, -mark.offY, jc);
                tg.dispose();
            }
        }
    }

    static Border wrapBorder(Border b) {
        if (!(b instanceof NapkinBorder)) {
            if (b instanceof BevelBorder) {
                b = new NapkinBoxBorder();
            } else if (b instanceof EtchedBorder) {
                b = new NapkinBoxBorder();
            } else if (b instanceof CompoundBorder) {
                CompoundBorder cb = (CompoundBorder)b;
                Border outside = cb.getOutsideBorder();
                Border inside = cb.getInsideBorder();
                if (inside instanceof NapkinBorder || outside instanceof NapkinBorder) {
                    b = new NapkinWrappedBorder(b);
                } else {
                    Border newOutside = NapkinUtil.wrapBorder(outside);
                    Border newInside = NapkinUtil.wrapBorder(inside);
                    b = outside == newOutside && inside == newInside ? new NapkinWrappedBorder(b) : new NapkinCompoundBorder(outside, inside);
                }
            } else {
                b = b == null ? NAPKIN_NULL_BORDER : new NapkinWrappedBorder(b);
            }
        }
        return b;
    }

    static AffineTransform scaleMat(double scale) {
        AffineTransform mat = new AffineTransform();
        mat.scale(scale, scale);
        return mat;
    }

    public static JButton createArrowButton(int pointTowards) {
        int size = 10;
        return NapkinUtil.createArrowButton(pointTowards, size);
    }

    public static JButton createArrowButton(int pointTowards, int size) {
        Icon arrow = NapkinIconFactory.createArrowIcon(pointTowards, size);
        JButton button = new JButton(arrow);
        button.setBorderPainted(false);
        Dimension dim = new Dimension(size + 3, size + 3);
        button.setPreferredSize(dim);
        button.setMinimumSize(dim);
        button.putClientProperty("net.sourceforge.napkinlaf.noRollover", Boolean.TRUE);
        return button;
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public static DrawnLineHolder paintLine(Graphics g, boolean vertical, DrawnLineHolder holder, Rectangle bounds) {
        if (holder == null) {
            holder = new DrawnLineHolder((AbstractDrawnGenerator)DrawnCubicLineGenerator.INSTANCE, vertical);
        }
        holder.shapeUpToDate(bounds, null);
        Graphics2D lineG = NapkinUtil.copy(g);
        if (vertical) {
            lineG.translate(bounds.x + bounds.width / 2, 0);
        } else {
            lineG.translate(0, bounds.y + bounds.height / 2);
        }
        holder.draw(lineG);
        return holder;
    }

    public static void printPair(Logger logger, Level level, String label, double x, double y) {
        logger.log(level, label + ": " + x + ", " + y);
    }

    public static void setupPaper(JComponent c, NapkinKnownTheme theme) {
        c.setOpaque(true);
        NapkinTheme baseTheme = NapkinTheme.Manager.getCurrentTheme();
        c.putClientProperty("net.sourceforge.napkinlaf.theme", baseTheme.getTheme(theme));
    }

    public static void paintBackground(Graphics g1, Component c, Rectangle clip) {
        if (!c.isOpaque()) {
            return;
        }
        if (c instanceof JComponent && NapkinUtil.isGlassPane((JComponent)c)) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        NapkinTheme theme = NapkinUtil.currentTheme(c);
        NapkinBackground bg = theme.getPaper();
        Rectangle pRect = NapkinUtil.bounds(NapkinUtil.currentPaper(c));
        Rectangle cRect = clip != null ? clip : NapkinUtil.bounds(c);
        bg.paint(c, g, pRect, cRect, clip != null ? ZERO_INSETS : NapkinUtil.insets(c));
        if (c.isEnabled() && c instanceof JComponent) {
            NapkinUtil.paintHighlights(g, theme, (JComponent)c);
        }
    }

    private static void paintHighlights(Graphics2D g, NapkinTheme theme, JComponent jc) {
        boolean shouldHighlight = jc.getBackground() == NapkinConstants.HIGHLIGHT_CLEAR || NapkinUtil.getBooleanProprty(jc, "net.sourceforge.napkinlaf.highlighted");
        boolean isRolledOver = NapkinUtil.getBooleanProprty(jc, "net.sourceforge.napkinlaf.rollovered");
        if (shouldHighlight || isRolledOver) {
            Rectangle rect = g.getClipBounds();
            if ((float)rect.width > 20.0f) {
                rect.x = (int)((double)rect.x + NapkinRandom.nextDouble(5.0));
                rect.width = (int)((double)rect.width - NapkinRandom.nextDouble(10.0));
            }
            DrawnLineHolder highLightLine = rect.width > 50 ? highLightLongLine : highLightShortLine;
            highLightLine.setCap(0);
            float lineWidth = rect.height;
            if (lineWidth > 10.0f) {
                lineWidth *= 0.8f;
            }
            if (lineWidth >= 0.0f) {
                Color fColor = g.getColor();
                if (shouldHighlight && isRolledOver) {
                    highLightLine.setWidth(lineWidth *= 0.5f);
                    rect.y = (int)((float)rect.y + (float)rect.height * 0.3f);
                    highLightLine.shapeUpToDate(rect, null);
                    g.setColor(theme.getHighlightColor());
                    highLightLine.draw(g);
                    rect.y = (int)((float)rect.y + (float)rect.height * 0.5f);
                    highLightLine.shapeUpToDate(rect, null);
                    g.setColor(theme.getRolloverColor());
                    highLightLine.draw(g);
                } else {
                    highLightLine.setWidth(lineWidth);
                    rect.y = (int)((float)rect.y + (float)rect.height * 0.6f);
                    highLightLine.shapeUpToDate(rect, null);
                    g.setColor(isRolledOver ? theme.getRolloverColor() : theme.getHighlightColor());
                    highLightLine.draw(g);
                }
                g.setColor(fColor);
            }
        }
    }

    private static boolean getBooleanProprty(JComponent jc, String key) {
        Boolean prop = (Boolean)jc.getClientProperty(key);
        return prop != null && prop != false;
    }

    private static Rectangle bounds(Component c) {
        Insets in = NapkinUtil.insets(c);
        Point start = NapkinUtil.getStart(c, in);
        int x = start.x;
        int y = start.y;
        int width = c.getWidth() + in.left + in.right;
        int height = c.getHeight() + in.top + in.bottom;
        return new Rectangle(x, y, width, height);
    }

    private static Insets insets(Component c) {
        return c instanceof Container ? ((Container)c).getInsets() : NO_INSETS;
    }

    public static JComponent themeTopFor(Component c) {
        JComponent result = null;
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            if (jc.getClientProperty("net.sourceforge.napkinlaf.theme") == null) {
                result = NapkinUtil.themeTopFor(jc.getParent());
                if (result == null) {
                    NapkinUtil.setupPaper(jc, NapkinKnownTheme.BASIC_THEME);
                    result = jc;
                }
            } else {
                result = jc;
            }
        } else if (c != null) {
            result = NapkinUtil.themeTopFor(c.getParent());
        }
        return result;
    }

    private static Point getStart(Component c, Insets insets) {
        Point start = new Point();
        if (insets != null) {
            start.setLocation(-insets.left, -insets.top);
        }
        Component paper = NapkinUtil.currentPaper(c);
        while (c != null && c != paper) {
            start.x += c.getX();
            start.y += c.getY();
            c = c.getParent();
        }
        return start;
    }

    private static boolean isPaper(Component c) {
        return c instanceof JComponent && ((JComponent)c).getClientProperty("net.sourceforge.napkinlaf.theme") != null;
    }

    public static void paintButtonText(Graphics g, JComponent c, Rectangle textRect, String text, int textOffset, DrawnLineHolder line, boolean isDefault, NapkinTextPainter helper) {
        AbstractButton button;
        ButtonModel model;
        if (isDefault) {
            if (line == null) {
                line = new DrawnLineHolder(new DrawnCubicLineGenerator());
            }
            Graphics2D ulG = NapkinUtil.copy(g);
            FontMetrics fm = ulG.getFontMetrics();
            line.shapeUpToDate(textRect, fm);
            ulG.translate(textOffset, textOffset);
            ulG.setColor(NapkinUtil.currentTheme(c).getCheckColor());
            line.setWidth(1.5f);
            line.draw(ulG);
        }
        Color textColor = c.getForeground();
        if (c instanceof AbstractButton && ((model = (button = (AbstractButton)c).getModel()).isArmed() || c instanceof JMenu && model.isSelected())) {
            textColor = NapkinUtil.currentTheme(c).getSelectionColor();
        }
        Color oldColor = g.getColor();
        g.setColor(textColor);
        helper.superPaintText(g, c, textRect, text);
        g.setColor(oldColor);
    }

    public static Object getProperty(JComponent c, String key, PropertyFactory factory) {
        Object value = c.getClientProperty(key);
        if (value == null) {
            value = factory.createPropertyValue();
            c.putClientProperty(key, value);
        }
        return value;
    }

    public static boolean replace(Object current, Object candidate) {
        return current == null || !current.equals(candidate) && current instanceof UIResource;
    }

    public static Color ifReplace(Color current, Color candidate) {
        return NapkinUtil.replace(current, candidate) ? candidate : current;
    }

    public static void drawStroke(GeneralPath path, AffineTransform matrix, double x1, double y1, double x2, double y2, double baseAngle, AbstractDrawnGenerator lineGen) {
        if (matrix == null) {
            matrix = new AffineTransform();
        }
        double xDelta = x1 - x2;
        double yDelta = y1 - y2;
        double angle = Math.atan2(xDelta, yDelta);
        AffineTransform mat = (AffineTransform)matrix.clone();
        mat.translate(x1, y1);
        mat.rotate(baseAngle + angle);
        double len = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
        mat.scale(len / 100.0, 1.0);
        AbstractDrawnGenerator.addLine(path, mat, lineGen);
    }

    public static void update(Graphics g, JComponent c, NapkinPainter painter) {
        if ((c instanceof JButton || c instanceof JLabel) && !Boolean.TRUE.equals(c.getClientProperty("net.sourceforge.napkinlaf.revalidated"))) {
            c.putClientProperty("net.sourceforge.napkinlaf.revalidated", true);
            c.revalidate();
        }
        if (c instanceof AbstractButton && !Boolean.TRUE.equals(c.getClientProperty("net.sourceforge.napkinlaf.noRollover"))) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            button.putClientProperty("net.sourceforge.napkinlaf.rollovered", button.isRolloverEnabled() && model.isRollover());
        }
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinUtil.paintBackground(g, c, null);
        MergedFontGraphics2D mfg = MergedFontGraphics2D.wrap((Graphics2D)g);
        painter.superPaint(mfg, c);
        mfg.dispose();
        NapkinUtil.finishGraphics(g, c);
    }

    public static boolean isNapkinInstalled(Component c) {
        return c instanceof JComponent && ((JComponent)c).getClientProperty("net.sourceforge.napkinlaf.installed") == Boolean.TRUE;
    }

    private static void dumpStacks() {
        if (Logs.paper.isLoggable(Level.FINER)) {
            if (themeStack.size() != paperStack.size()) {
                System.out.println("!!!");
            }
            StringBuilder dump = new StringBuilder(NapkinDebug.count).append(":\t");
            ++NapkinDebug.count;
            for (int i = 0; i < paperStack.size(); ++i) {
                dump.append(". ");
            }
            if (!themeStack.isEmpty()) {
                dump.append(themeStack.peek()).append(" / ").append(NapkinDebug.descFor(paperStack.peek()));
            }
            Logs.paper.log(Level.FINER, dump.toString());
        }
    }

    public static IOException tryClose(Closeable fonts) {
        IOException result = null;
        try {
            fonts.close();
        }
        catch (IOException e) {
            result = e;
        }
        return result;
    }

    static {
        NO_INSETS = new Insets(0, 0, 0, 0);
        NAPKIN_NULL_BORDER = new NapkinWrappedBorder(new EmptyBorder(NO_INSETS));
        ERASURE_COMPOSITE = AlphaComposite.getInstance(8, 0.9f);
        themeStack = new Stack();
        paperStack = new Stack();
        erasureBuffer = new SoftReference<Object>(null);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        ImageIcon icon = theme.getErasureMask().getIcon();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        textureImage = new BufferedImage(w, h, 2);
        Graphics2D gi = textureImage.createGraphics();
        gi.setColor(new Color(0, 0, 0, 0));
        gi.fillRect(0, 0, w, h);
        gi.drawImage(icon.getImage(), 0, 0, icon.getImageObserver());
        ZERO_INSETS = new Insets(0, 0, 0, 0);
        DrawnCubicLineGenerator lineGen = new DrawnCubicLineGenerator();
        RandomValue rVal = lineGen.getLeft().getY();
        rVal.setRange(rVal.getRange() * 2.5);
        rVal = lineGen.getRight().getY();
        rVal.setRange(rVal.getRange() * 2.5);
        highLightLongLine = new DrawnLineHolder(lineGen);
        lineGen = new DrawnCubicLineGenerator();
        highLightShortLine = new DrawnLineHolder(lineGen);
    }

    public static interface Logs {
        public static final Logger paper = Logger.getLogger("net.sourceforge.napkinlaf.paper");
    }

    public static class DisabledMark {
        public final BufferedImage image;
        public final int offX;
        public final int offY;
        public final Graphics2D graphics;

        public DisabledMark(Graphics2D graphics, BufferedImage image, int offX, int offY) {
            this.graphics = NapkinUtil.copy(graphics);
            this.image = image;
            this.offX = offX;
            this.offY = offY;
        }
    }

    public static interface PropertyFactory {
        public Object createPropertyValue();
    }
}

