/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.i18n;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nProps;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nUtils;

public class I18nBundle
implements Comparable<I18nBundle> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(I18nProps.class);
    private I18nProps _defaultProps;
    private Locale _locale;
    private File _workDir;
    private URL[] _sourceUrls;
    private Integer _missingTranslationsCount;
    private static final String PREF_KEY_INCLUDE_TIMESTAMP = "SquirrelSQL.i18n.includeTimestamp";
    private I18nProps _localizedProps;

    public I18nBundle(I18nProps defaultProps, Locale locale, File workDir, URL[] sourceUrls) {
        this._defaultProps = defaultProps;
        this._locale = locale;
        this._workDir = workDir;
        this._sourceUrls = sourceUrls;
    }

    private void initMissingTranslationsCount() {
        File pathInWorkDir;
        if (null != this._missingTranslationsCount) {
            return;
        }
        Properties buf = this._defaultProps.getTranslateableProperties();
        if (null != this._localizedProps) {
            this._localizedProps.removeProps(buf);
        }
        if (null != this._workDir && (pathInWorkDir = this.getPathRelativeTo(this._workDir)).exists()) {
            new I18nProps(pathInWorkDir, this._sourceUrls).removeProps(buf);
        }
        this._missingTranslationsCount = buf.size();
    }

    public void setLocalizedProp(I18nProps localizedProps) {
        this._localizedProps = localizedProps;
    }

    public String toString() {
        return this._defaultProps.getPath();
    }

    public String getName() {
        return this._defaultProps.getName();
    }

    public Integer getMissingTranslationsCount() {
        this.initMissingTranslationsCount();
        return this._missingTranslationsCount;
    }

    public void writeMissingProps(IApplication app, File workDir) {
        try {
            Properties propsToAppend = this._defaultProps.getTranslateableProperties();
            File toAppendTo = this.getPathRelativeTo(workDir);
            if (toAppendTo.exists()) {
                new I18nProps(toAppendTo, this._sourceUrls).removeProps(propsToAppend);
            } else {
                toAppendTo.getParentFile().mkdirs();
                if (null != this._localizedProps) {
                    this._localizedProps.copyTo(toAppendTo);
                    Object[] params = new Object[]{this._localizedProps.getPath(), toAppendTo.getPath()};
                    app.getMessageHandler().showMessage(s_stringMgr.getString("I18n.PropsCopyMsg", params));
                    new I18nProps(toAppendTo, this._sourceUrls).removeProps(propsToAppend);
                }
            }
            FileOutputStream fos = new FileOutputStream(toAppendTo, true);
            PrintWriter pw = new PrintWriter(fos);
            String includeTimestamp = Props.getString((String)PREF_KEY_INCLUDE_TIMESTAMP, (String)"true");
            if (includeTimestamp.equals("true")) {
                String msg = s_stringMgr.getString("I18n.TranlationsGenerationMessage", new Object[]{new Date()});
                pw.println(msg);
            }
            Object[] keys = propsToAppend.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                String val = propsToAppend.getProperty((String)keys[i]);
                pw.println();
                pw.println("#" + (String)keys[i] + "=" + I18nUtils.normalizePropVal(val));
                pw.println("#" + (String)keys[i] + "=");
            }
            pw.flush();
            fos.flush();
            pw.close();
            fos.close();
            Object[] params = new Object[]{propsToAppend.size(), toAppendTo.getPath()};
            app.getMessageHandler().showMessage(s_stringMgr.getString("I18n.TranslationsGenerationCount", params));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    File getPathRelativeTo(File parentDir) {
        File toAppendTo = new File(parentDir.getPath() + File.separator + this.getName());
        String localizedFileName = this._defaultProps.getLocalizedFileName(this._locale);
        toAppendTo = new File(toAppendTo.getParent() + File.separator + localizedFileName);
        return toAppendTo;
    }

    @Override
    public int compareTo(I18nBundle other) {
        return this.getName().toLowerCase().compareTo(other.getName().toLowerCase());
    }
}

