/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql;

import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.mysql.ObjectTypes;
import net.sourceforge.squirrel_sql.plugins.mysql.action.AlterTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.AnalyzeTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.CheckTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.CopyTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.CreateDatabaseAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.CreateMysqlTableScriptAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.DropDatabaseAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.ExplainSelectTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.ExplainTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.OptimizeTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.action.RenameTableAction;
import net.sourceforge.squirrel_sql.plugins.mysql.expander.MysqlTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.mysql.expander.SessionExpander;
import net.sourceforge.squirrel_sql.plugins.mysql.expander.UserParentExpander;
import net.sourceforge.squirrel_sql.plugins.mysql.prefs.MysqlPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.DatabaseStatusTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.MysqlProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.MysqlTriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.MysqlTriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.MysqlViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.OpenTablesTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ProcessesTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ShowColumnsTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ShowIndexesTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ShowLogsTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ShowMasterLogsTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ShowMasterStatusTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ShowSlaveStatusTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.ShowVariablesTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.TableStatusTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.UserGrantsTab;
import net.sourceforge.squirrel_sql.plugins.mysql.tokenizer.MysqlQueryTokenizer;
import net.sourceforge.squirrel_sql.plugins.mysql.types.MySQL5ByteTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.types.MySQLByteTypeDataTypeComponentFactory;

public class MysqlPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MysqlPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(MysqlPlugin.class);
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private JMenu _mySQLMenu;
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;
    private ObjectTypes _objectTypes;

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "mysql";
    }

    public String getDescriptiveName() {
        return "MySQL Plugin";
    }

    public String getVersion() {
        return "0.33";
    }

    public String getAuthor() {
        return "Colin Bell";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
        this._resources = this._resourcesFactory.createResource(((Object)((Object)this)).getClass().getName(), (IPlugin)this);
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        PluginQueryTokenizerPreferencesPanel _prefsPanel = new PluginQueryTokenizerPreferencesPanel(this._prefsManager, "MySQL");
        PluginGlobalPreferencesTab tab = new PluginGlobalPreferencesTab(_prefsPanel);
        tab.setHint(i18n.hint);
        tab.setTitle(i18n.title);
        return new IGlobalPreferencesPanel[]{tab};
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        this._objectTypes = new ObjectTypes(this._resources);
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new AnalyzeTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new CreateMysqlTableScriptAction(app, this._resources, this)));
        coll.add((Action)((Object)new CheckTableAction.ChangedCheckTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new CheckTableAction.ExtendedCheckTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new CheckTableAction.FastCheckTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new CheckTableAction.MediumCheckTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new CheckTableAction.QuickCheckTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new ExplainSelectTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new ExplainTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new OptimizeTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new RenameTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new CreateDatabaseAction(app, this._resources, this)));
        coll.add((Action)((Object)new DropDatabaseAction(app, this._resources, this)));
        coll.add((Action)((Object)new AlterTableAction(app, this._resources, this)));
        coll.add((Action)((Object)new CopyTableAction(app, this._resources, this)));
        this._mySQLMenu = this.createFullMysqlMenu();
        app.addToMenu(2, this._mySQLMenu);
        super.registerSessionMenu(this._mySQLMenu);
        this._prefsManager = new PluginQueryTokenizerPreferencesManager();
        this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new MysqlPreferenceBean());
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new MySQLByteTypeDataTypeComponentFactory());
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new MySQL5ByteTypeDataTypeComponentFactory());
    }

    public void unload() {
        super.unload();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(session.getSessionInternalFrame().getObjectTreeAPI()));
        this.installMysqlQueryTokenizer(session);
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                MysqlPlugin.this.updateTreeApi(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
                MysqlPlugin.this.updateTreeApi((IObjectTreeAPI)objectTreePanel);
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isMySQL((ISQLDatabaseMetaData)session.getMetaData()) || DialectFactory.isMySQL5((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void installMysqlQueryTokenizer(ISession session) {
        IQueryTokenizerPreferenceBean _prefs = this._prefsManager.getPreferences();
        if (_prefs.isInstallCustomQueryTokenizer()) {
            session.setQueryTokenizer((IQueryTokenizer)new MysqlQueryTokenizer(_prefs));
        }
    }

    private void updateTreeApi(IObjectTreeAPI objectTreeAPI) {
        ActionCollection coll = this.getApplication().getActionCollection();
        objectTreeAPI.addExpander(DatabaseObjectType.SESSION, (INodeExpander)new SessionExpander(this._objectTypes));
        objectTreeAPI.addExpander(this._objectTypes.getUserParent(), (INodeExpander)new UserParentExpander(this));
        objectTreeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new DatabaseStatusTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ProcessesTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ShowVariablesTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ShowLogsTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ShowMasterStatusTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ShowMasterLogsTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ShowSlaveStatusTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.CATALOG, (IObjectTab)new OpenTablesTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.CATALOG, (IObjectTab)new TableStatusTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new ShowColumnsTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new ShowIndexesTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.USER, (IObjectTab)new UserGrantsTab());
        objectTreeAPI.addToPopup(coll.get(CreateDatabaseAction.class));
        objectTreeAPI.addToPopup(DatabaseObjectType.CATALOG, coll.get(DropDatabaseAction.class));
        objectTreeAPI.addToPopup(DatabaseObjectType.TABLE, this.createMysqlTableMenu());
        this.updateTreeApiForMysql5(objectTreeAPI);
        objectTreeAPI.refreshTree();
    }

    private void updateTreeApiForMysql5(IObjectTreeAPI objectTreeAPI) {
        if (!DialectFactory.isMySQL5((ISQLDatabaseMetaData)objectTreeAPI.getSession().getMetaData())) {
            return;
        }
        String stmtSep = objectTreeAPI.getSession().getQueryTokenizer().getSQLStatementSeparator();
        MysqlProcedureSourceTab procSourceTab = new MysqlProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE);
        objectTreeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)procSourceTab);
        MysqlViewSourceTab viewSourceTab = new MysqlViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep);
        objectTreeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)viewSourceTab);
        TableWithChildNodesExpander trigExp = new TableWithChildNodesExpander();
        trigExp.setTableTriggerExtractor((ITableTriggerExtractor)new MysqlTableTriggerExtractorImpl());
        objectTreeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)trigExp);
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new MysqlTriggerDetailsTab());
        MysqlTriggerSourceTab trigSourceTab = new MysqlTriggerSourceTab(i18n.SHOW_TRIGGER_SOURCE, stmtSep);
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)trigSourceTab);
    }

    private JMenu createMysqlTableMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu mysqlMenu = this._resources.createMenu("mysql");
        this._resources.addToMenu(coll.get(CreateMysqlTableScriptAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(AnalyzeTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(ExplainTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(ExplainSelectTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(OptimizeTableAction.class), mysqlMenu);
        JMenu checkTableMenu = this._resources.createMenu("checktable");
        this._resources.addToMenu(coll.get(CheckTableAction.ChangedCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.ExtendedCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.FastCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.MediumCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.QuickCheckTableAction.class), checkTableMenu);
        mysqlMenu.add(checkTableMenu);
        this._resources.addToMenu(coll.get(AlterTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(CopyTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(RenameTableAction.class), mysqlMenu);
        return mysqlMenu;
    }

    private JMenu createFullMysqlMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu mysqlMenu = this._resources.createMenu("mysql");
        this._resources.addToMenu(coll.get(CreateDatabaseAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(CreateMysqlTableScriptAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(AnalyzeTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(ExplainTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(ExplainSelectTableAction.class), mysqlMenu);
        this._resources.addToMenu(coll.get(OptimizeTableAction.class), mysqlMenu);
        JMenu checkTableMenu = this._resources.createMenu("checktable");
        this._resources.addToMenu(coll.get(CheckTableAction.ChangedCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.ExtendedCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.FastCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.MediumCheckTableAction.class), checkTableMenu);
        this._resources.addToMenu(coll.get(CheckTableAction.QuickCheckTableAction.class), checkTableMenu);
        mysqlMenu.add(checkTableMenu);
        return mysqlMenu;
    }

    static interface i18n {
        public static final String title = s_stringMgr.getString("MysqlPlugin.title");
        public static final String hint = s_stringMgr.getString("MysqlPlugin.hint");
        public static final String SHOW_PROCEDURE_SOURCE = s_stringMgr.getString("MysqlPlugin.showProcedureSource");
        public static final String SHOW_TRIGGER_SOURCE = s_stringMgr.getString("MysqlPlugin.showTriggerSource");
        public static final String SHOW_VIEW_SOURCE = s_stringMgr.getString("MysqlPlugin.showViewSource");
    }

    public static interface IKeys {
        public static final String USERS_IMAGE = "users";
    }

    public static interface IMenuResourceKeys {
        public static final String CHECK_TABLE = "checktable";
        public static final String MYSQL = "mysql";
    }
}

