/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mysql.action.CheckTableCommand;

public class CheckTableAction
extends SquirrelAction
implements ISessionAction {
    private transient ISession _session;
    private final transient MysqlPlugin _plugin;
    private int _checkType;

    private CheckTableAction(IApplication app, IResources resources, MysqlPlugin plugin, int checkType) {
        super(app, resources);
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (resources == null) {
            throw new IllegalArgumentException("Resources == null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("MysqlPlugin == null");
        }
        if (checkType < 0 || checkType > 4) {
            throw new IllegalArgumentException("Invalid checkType of " + checkType);
        }
        this._plugin = plugin;
        this._checkType = checkType;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            try {
                new CheckTableCommand(this._session, this._plugin, this._checkType).execute();
            }
            catch (Throwable th) {
                this._session.showErrorMessage(th);
            }
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }

    public static final class QuickCheckTableAction
    extends CheckTableAction {
        public QuickCheckTableAction(IApplication app, IResources resources, MysqlPlugin plugin) {
            super(app, resources, plugin, 0);
        }
    }

    public static final class MediumCheckTableAction
    extends CheckTableAction {
        public MediumCheckTableAction(IApplication app, IResources resources, MysqlPlugin plugin) {
            super(app, resources, plugin, 2);
        }
    }

    public static final class FastCheckTableAction
    extends CheckTableAction {
        public FastCheckTableAction(IApplication app, IResources resources, MysqlPlugin plugin) {
            super(app, resources, plugin, 1);
        }
    }

    public static final class ExtendedCheckTableAction
    extends CheckTableAction {
        public ExtendedCheckTableAction(IApplication app, IResources resources, MysqlPlugin plugin) {
            super(app, resources, plugin, 3);
        }
    }

    public static final class ChangedCheckTableAction
    extends CheckTableAction {
        public ChangedCheckTableAction(IApplication app, IResources resources, MysqlPlugin plugin) {
            super(app, resources, plugin, 4);
        }
    }

    static interface ICheckTypes {
        public static final int QUICK = 0;
        public static final int FAST = 1;
        public static final int MEDIUM = 2;
        public static final int EXTENDED = 3;
        public static final int CHANGED = 4;
    }
}

