/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mysql.util.DBUtils;

public class CopyTableCommand
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CopyTableCommand.class);
    private JCheckBox chAllFields;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JLabel lbCopyToNewTable;
    private JList listFields;
    private JRadioButton rdStructure;
    private JRadioButton rdStructureData;
    private JTextField tfTableName;
    private JDialog jd;
    private DBUtils dbUtils;
    private String[] colNames;
    private ITableInfo oldTableName;
    private String newTableName;
    private String SQLCommandRoot = "";
    private String SQLCommand = "";
    private String SQLQuery = "";
    private boolean isStructure = true;
    private DefaultListModel listModel;
    private boolean isAllFields = true;
    private final ISession _session;
    private final MysqlPlugin _plugin;

    public CopyTableCommand(ISession session, MysqlPlugin plugin) {
        this._session = session;
        this._plugin = plugin;
    }

    public void execute() {
        this.initComponents();
    }

    private void initComponents() {
        this.lbCopyToNewTable = new JLabel();
        this.tfTableName = new JTextField();
        this.rdStructure = new JRadioButton();
        this.rdStructureData = new JRadioButton();
        this.listFields = new JList(new DefaultListModel());
        this.chAllFields = new JCheckBox();
        this.dbUtils = new DBUtils(this._session, this._plugin);
        this.colNames = this.dbUtils.getColumnNames();
        this.oldTableName = this.dbUtils.getTableInfo();
        this.listFields.setSelectionMode(2);
        this.listModel = (DefaultListModel)this.listFields.getModel();
        for (String colName : this.colNames) {
            this.listModel.addElement(colName);
        }
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jd = new JDialog((Frame)this._session.getApplication().getMainFrame(), s_stringMgr.getString("mysql.copyTable"));
        this.jd.getContentPane().setLayout(null);
        this.jd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CopyTableCommand.this.closeDialog(evt);
            }
        });
        this.lbCopyToNewTable.setFont(new Font("Dialog", 0, 12));
        this.lbCopyToNewTable.setText(s_stringMgr.getString("mysql.copyToNewTable"));
        this.jd.getContentPane().add(this.lbCopyToNewTable);
        this.lbCopyToNewTable.setBounds(20, 20, 110, 16);
        this.jd.getContentPane().add(this.tfTableName);
        this.tfTableName.setBounds(20, 40, 350, 20);
        this.rdStructure.setFont(new Font("Dialog", 0, 12));
        this.rdStructure.setText(s_stringMgr.getString("mysql.structure"));
        this.rdStructure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyTableCommand.this.rdStructureActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.rdStructure);
        this.rdStructure.setBounds(220, 90, 74, 24);
        this.rdStructure.setSelected(true);
        this.rdStructureData.setFont(new Font("Dialog", 0, 12));
        this.rdStructureData.setText(s_stringMgr.getString("mysql.structureAndData"));
        this.rdStructureData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyTableCommand.this.rdStructureDataActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.rdStructureData);
        this.rdStructureData.setBounds(220, 130, 130, 24);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdStructure);
        group.add(this.rdStructureData);
        this.jd.getContentPane().add(this.listFields);
        this.listFields.setBounds(30, 90, 130, 170);
        this.listFields.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CopyTableCommand.this.listFieldsValueChanged(evt);
            }
        });
        this.listFields.setEnabled(false);
        this.buttonOk.setFont(new Font("Dialog", 0, 12));
        this.buttonOk.setText(s_stringMgr.getString("mysql.copyOk"));
        this.buttonOk.addActionListener(evt -> this.buttonOkActionPerformed());
        this.jd.getContentPane().add(this.buttonOk);
        this.buttonOk.setBounds(190, 230, 70, 26);
        this.buttonCancel.setFont(new Font("Dialog", 0, 12));
        this.buttonCancel.setText(s_stringMgr.getString("mysql.copyCancel"));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyTableCommand.this.buttonCancelActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.buttonCancel);
        this.buttonCancel.setBounds(280, 230, 73, 26);
        this.chAllFields.setFont(new Font("Dialog", 0, 12));
        this.chAllFields.setText(s_stringMgr.getString("mysql.withAllFields"));
        this.chAllFields.setSelected(true);
        this.chAllFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyTableCommand.this.chAllFieldsActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.chAllFields);
        this.chAllFields.setBounds(20, 60, 110, 24);
        this.jd.pack();
        this.jd.setSize(400, 300);
        this.jd.setLocation(100, 100);
        this.jd.setVisible(true);
    }

    private void listFieldsValueChanged(ListSelectionEvent evt) {
    }

    private void chAllFieldsActionPerformed(ActionEvent evt) {
        if (this.chAllFields.isSelected()) {
            this.listFields.setEnabled(false);
            this.isAllFields = true;
        } else {
            this.listFields.setEnabled(true);
            this.isAllFields = false;
        }
    }

    private void rdStructureDataActionPerformed(ActionEvent evt) {
        this.isStructure = !this.rdStructureData.isSelected();
    }

    private void rdStructureActionPerformed(ActionEvent evt) {
        this.isStructure = this.rdStructure.isSelected();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.jd.setVisible(false);
        this.jd.dispose();
    }

    private void buttonOkActionPerformed() {
        this.newTableName = this.tfTableName.getText();
        Object selectedFields = "";
        Object fields = "";
        List obj = this.listFields.getSelectedValuesList();
        for (int i = 0; i < obj.size(); ++i) {
            selectedFields = (String)selectedFields + obj.get(i);
            if (i >= obj.size() - 1) continue;
            selectedFields = (String)selectedFields + ", ";
        }
        fields = this.isAllFields ? "*" : selectedFields;
        this.SQLCommandRoot = this.isStructure ? this.SQLCommandRoot + "SELECT " + (String)fields + " FROM " + this.oldTableName + " WHERE 1=0 ;" : this.SQLCommandRoot + "SELECT " + (String)fields + " FROM " + this.oldTableName + " ;";
        this.SQLQuery = this.getQuery() + this.SQLCommandRoot;
        this.dbUtils.execute(this.SQLQuery);
        this._session.getSessionInternalFrame().getObjectTreeAPI().refreshTree();
        this.jd.setVisible(false);
        this.jd.dispose();
        JOptionPane.showMessageDialog(null, "Table " + this.newTableName + " created");
    }

    public String getQuery() {
        this.SQLCommand = "CREATE TABLE " + this.newTableName + " ( ";
        String primaryKeyData = this.dbUtils.getPrimaryKeyColumn();
        if (primaryKeyData.length() > 0) {
            this.SQLCommand = this.SQLCommand + "PRIMARY KEY ( " + primaryKeyData + " )";
        }
        this.SQLCommand = this.SQLCommand + " ) ";
        return this.SQLCommand;
    }

    private void closeDialog(WindowEvent evt) {
        this.jd.setVisible(false);
        this.jd.dispose();
    }
}

