/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mysql.util.FieldDetails;

public class CreateTableCommand
extends JDialog
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateTableCommand.class);
    private JButton btAdd;
    private JButton btRemove;
    private JButton btCancel;
    private JButton btCreateTable;
    private JComboBox cbFieldType;
    private JComboBox cbTableType;
    private JCheckBox chAuto;
    private JCheckBox chBinary;
    private JCheckBox chIndex;
    private JCheckBox chNotNull;
    private JCheckBox chPrimary;
    private JCheckBox chUnique;
    private JCheckBox chUnsigned;
    private JCheckBox chZeroFill;
    private JList listFields;
    private JLabel lbDefault;
    private JLabel lbFieldLength;
    private JLabel lbFieldProp;
    private JLabel lbFieldType;
    private JLabel lbFields;
    private JLabel lbTableName;
    private JLabel lbTableType;
    private JTextField tfDefault;
    private JTextField tfFieldLength;
    private JTextField tfFieldName;
    private JTextField tfTableName;
    private JDialog jd;
    protected String SQLCommandRoot = "CREATE TABLE ";
    protected String SQLCommand = "";
    private ISession _session;
    private final MysqlPlugin _plugin;

    public CreateTableCommand(ISession session, MysqlPlugin plugin) {
        this._session = session;
        this._plugin = plugin;
    }

    public void execute() {
        this.initComponents();
    }

    private void initComponents() {
        this.lbTableName = new JLabel();
        this.tfTableName = new JTextField();
        this.lbTableType = new JLabel();
        this.cbTableType = new JComboBox();
        this.lbFields = new JLabel();
        this.tfFieldName = new JTextField();
        this.btAdd = new JButton();
        this.lbFieldProp = new JLabel();
        this.lbFieldType = new JLabel();
        this.cbFieldType = new JComboBox();
        this.lbFieldLength = new JLabel();
        this.tfFieldLength = new JTextField();
        this.lbDefault = new JLabel();
        this.tfDefault = new JTextField();
        this.chPrimary = new JCheckBox();
        this.chIndex = new JCheckBox();
        this.chUnique = new JCheckBox();
        this.chBinary = new JCheckBox();
        this.chNotNull = new JCheckBox();
        this.chUnsigned = new JCheckBox();
        this.chAuto = new JCheckBox();
        this.chZeroFill = new JCheckBox();
        this.listFields = new JList(new DefaultListModel());
        this.btCreateTable = new JButton();
        this.btRemove = new JButton();
        this.btCancel = new JButton();
        this.jd = new JDialog((Frame)this._session.getApplication().getMainFrame(), s_stringMgr.getString("mysql.createTableComm"));
        this.jd.getContentPane().setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CreateTableCommand.this.closeDialog(evt);
            }
        });
        this.lbTableName.setText(s_stringMgr.getString("mysql.tableNamelbl"));
        this.jd.getContentPane().add(this.lbTableName);
        this.lbTableName.setBounds(20, 30, 70, 16);
        this.tfTableName.setText("TableName");
        this.jd.getContentPane().add(this.tfTableName);
        this.tfTableName.setBounds(120, 30, 100, 20);
        this.lbTableType.setFont(new Font("Dialog", 0, 12));
        this.lbTableType.setText("Table Type:");
        this.jd.getContentPane().add(this.lbTableType);
        this.lbTableType.setBounds(20, 60, 70, 16);
        this.cbTableType.setFont(new Font("Dialog", 0, 12));
        this.cbTableType.setModel(new DefaultComboBoxModel<String>(new String[]{"<Automatic>", "ISAM", "MyISAM", "MERGE", "InnoDb", "HEAP", "BDB"}));
        this.jd.getContentPane().add(this.cbTableType);
        this.cbTableType.setBounds(120, 60, 100, 20);
        this.lbFields.setText("Fields:");
        this.lbFields.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jd.getContentPane().add(this.lbFields);
        this.lbFields.setBounds(10, 120, 40, 18);
        this.tfFieldName.setText("FieldName");
        this.tfFieldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CreateTableCommand.this.tfFieldNameFocusGained(evt);
            }
        });
        this.jd.getContentPane().add(this.tfFieldName);
        this.tfFieldName.setBounds(10, 150, 110, 20);
        this.btAdd.setFont(new Font("Dialog", 0, 12));
        this.btAdd.setText(s_stringMgr.getString("mysql.createAdd"));
        this.btAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTableCommand.this.btAddActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.btAdd);
        this.btAdd.setBounds(130, 150, 80, 26);
        this.lbFieldProp.setText(s_stringMgr.getString("mysql.fieldProps"));
        this.lbFieldProp.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jd.getContentPane().add(this.lbFieldProp);
        this.lbFieldProp.setBounds(220, 150, 100, 20);
        this.lbFieldType.setFont(new Font("Dialog", 0, 12));
        this.lbFieldType.setText("Type");
        this.jd.getContentPane().add(this.lbFieldType);
        this.lbFieldType.setBounds(220, 190, 41, 16);
        this.cbFieldType.setFont(new Font("Dialog", 0, 12));
        this.cbFieldType.setModel(new DefaultComboBoxModel<String>(new String[]{"TINYINT", "SMALLINT", "MEDIUMINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "DATE", "DATETIME", "TIMESTAMP", "TIME", "YEAR", "CHAR", "VARCHAR", "TINYBLOB", "TINYTEXT", "TEXT", "BLOB", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT", "ENUM", "SET"}));
        this.cbFieldType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTableCommand.this.cbFieldTypeActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.cbFieldType);
        this.cbFieldType.setBounds(300, 190, 110, 20);
        this.lbFieldLength.setFont(new Font("Dialog", 0, 12));
        this.lbFieldLength.setText(s_stringMgr.getString("mysql.lengtSet"));
        this.jd.getContentPane().add(this.lbFieldLength);
        this.lbFieldLength.setBounds(220, 220, 70, 16);
        this.jd.getContentPane().add(this.tfFieldLength);
        this.tfFieldLength.setBounds(300, 220, 110, 20);
        this.lbDefault.setFont(new Font("Dialog", 0, 12));
        this.lbDefault.setText(s_stringMgr.getString("mysql.defaultValue"));
        this.jd.getContentPane().add(this.lbDefault);
        this.lbDefault.setBounds(220, 250, 80, 16);
        this.jd.getContentPane().add(this.tfDefault);
        this.tfDefault.setBounds(300, 250, 110, 20);
        this.chPrimary.setFont(new Font("Dialog", 0, 12));
        this.chPrimary.setText("Primary");
        this.chPrimary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CreateTableCommand.this.chPrimaryItemStateChanged(evt);
            }
        });
        this.jd.getContentPane().add(this.chPrimary);
        this.chPrimary.setBounds(220, 290, 67, 20);
        this.chIndex.setFont(new Font("Dialog", 0, 12));
        this.chIndex.setText("Index");
        this.jd.getContentPane().add(this.chIndex);
        this.chIndex.setBounds(290, 290, 54, 20);
        this.chUnique.setFont(new Font("Dialog", 0, 12));
        this.chUnique.setText("Unique");
        this.jd.getContentPane().add(this.chUnique);
        this.chUnique.setBounds(350, 290, 65, 20);
        this.chBinary.setFont(new Font("Dialog", 0, 12));
        this.chBinary.setText("Binary");
        this.jd.getContentPane().add(this.chBinary);
        this.chBinary.setBounds(220, 320, 70, 20);
        this.chNotNull.setFont(new Font("Dialog", 0, 12));
        this.chNotNull.setText("Not Null");
        this.jd.getContentPane().add(this.chNotNull);
        this.chNotNull.setBounds(290, 320, 70, 20);
        this.chUnsigned.setFont(new Font("Dialog", 0, 12));
        this.chUnsigned.setText("Unsigned");
        this.jd.getContentPane().add(this.chUnsigned);
        this.chUnsigned.setBounds(360, 320, 80, 20);
        this.chAuto.setFont(new Font("Dialog", 0, 12));
        this.chAuto.setText("Auto Increment");
        this.jd.getContentPane().add(this.chAuto);
        this.chAuto.setBounds(220, 350, 110, 20);
        this.chZeroFill.setFont(new Font("Dialog", 0, 12));
        this.chZeroFill.setText("Zero Fill");
        this.jd.getContentPane().add(this.chZeroFill);
        this.chZeroFill.setBounds(330, 350, 69, 20);
        this.listFields.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CreateTableCommand.this.listFieldsValueChanged(evt);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.listFields);
        this.jd.getContentPane().add(scrollPane);
        scrollPane.setBounds(10, 190, 110, 150);
        this.btCreateTable.setFont(new Font("Dialog", 0, 12));
        this.btCreateTable.setText(s_stringMgr.getString("mysql.createTableBtn"));
        this.btCreateTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTableCommand.this.btCreateTableActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.btCreateTable);
        this.btCreateTable.setBounds(221, 380, 110, 26);
        this.btRemove.setFont(new Font("Dialog", 0, 12));
        this.btRemove.setText(s_stringMgr.getString("mysql.btRemove"));
        this.btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTableCommand.this.btRemoveActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.btRemove);
        this.btRemove.setBounds(130, 190, 80, 26);
        this.btCancel.setFont(new Font("Dialog", 0, 12));
        this.btCancel.setText(s_stringMgr.getString("mysql.btCancel"));
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTableCommand.this.btCancelActionPerformed(evt);
            }
        });
        this.jd.getContentPane().add(this.btCancel);
        this.btCancel.setBounds(340, 380, 73, 26);
        this.jd.pack();
        this.jd.setSize(450, 450);
        this.jd.setLocation(100, 100);
        this.jd.setVisible(true);
    }

    private void btAddActionPerformed(ActionEvent evt) {
        FieldDetails fd = new FieldDetails();
        fd.setFieldName(this.tfFieldName.getText());
        fd.setFieldLength(this.tfFieldLength.getText());
        fd.setFieldType((String)this.cbFieldType.getSelectedItem());
        fd.setDefault(this.tfDefault.getText());
        fd.setPrimary(this.chPrimary.isSelected());
        fd.setUnique(this.chUnique.isSelected());
        fd.setIndex(this.chIndex.isSelected());
        fd.setBinary(this.chBinary.isSelected());
        fd.setNotNull(this.chNotNull.isSelected());
        fd.setUnisigned(this.chUnsigned.isSelected());
        fd.setAutoIncrement(this.chAuto.isSelected());
        fd.setZeroFill(this.chZeroFill.isSelected());
        DefaultListModel listModel = (DefaultListModel)this.listFields.getModel();
        listModel.addElement(fd);
    }

    private void listFieldsValueChanged(ListSelectionEvent evt) {
        int index = this.listFields.getSelectedIndex();
        DefaultListModel listModel = (DefaultListModel)this.listFields.getModel();
        FieldDetails fd = (FieldDetails)listModel.elementAt(index);
        this.tfFieldName.setText(fd.getFieldName());
        this.cbFieldType.setSelectedItem(fd.getFieldType());
        this.tfFieldLength.setText(fd.getFieldLength());
        this.tfDefault.setText(fd.getDefault());
        this.chPrimary.setSelected(fd.IsPrimary());
        this.chUnique.setSelected(fd.IsUnique());
        this.chIndex.setSelected(fd.IsIndex());
        this.chBinary.setSelected(fd.IsBinary());
        this.chNotNull.setSelected(fd.IsNotNull());
        this.chUnsigned.setSelected(fd.IsUnisigned());
        this.chAuto.setSelected(fd.IsAutoIncrement());
        this.chZeroFill.setSelected(fd.IsZeroFill());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btCreateTableActionPerformed(ActionEvent evt) {
        ISQLConnection con = this._session.getSQLConnection();
        String query = this.getQuery();
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(query);
            this._session.getSessionInternalFrame().getObjectTreeAPI().refreshTree();
            this.jd.setVisible(false);
            this.jd.dispose();
            JOptionPane.showMessageDialog(null, s_stringMgr.getString("mysql.msgTableCreated", new Object[]{this.tfTableName.getText()}));
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
        finally {
            SQLUtilities.closeStatement((Statement)stmt);
        }
    }

    private void chPrimaryItemStateChanged(ItemEvent evt) {
        if (this.chPrimary.isSelected()) {
            this.chNotNull.setSelected(true);
        }
    }

    private void cbFieldTypeActionPerformed(ActionEvent evt) {
        this.tfFieldLength.setText("5");
        if (this.cbFieldType.getSelectedItem().equals("VARCHAR")) {
            this.chBinary.setEnabled(true);
            this.chUnsigned.setEnabled(false);
            this.chZeroFill.setEnabled(false);
        } else {
            this.chUnsigned.setEnabled(false);
            this.chZeroFill.setEnabled(false);
        }
        if (this.cbFieldType.getSelectedItem().equals("INT")) {
            this.chBinary.setEnabled(false);
            this.chUnsigned.setEnabled(true);
            this.chZeroFill.setEnabled(true);
        }
    }

    private void tfFieldNameFocusGained(FocusEvent evt) {
        this.cbFieldType.setSelectedIndex(0);
        this.chAuto.setSelected(false);
        this.chBinary.setSelected(false);
        this.chIndex.setSelected(false);
        this.chNotNull.setSelected(false);
        this.chPrimary.setSelected(false);
        this.chUnique.setSelected(false);
        this.chUnsigned.setSelected(false);
        this.chZeroFill.setSelected(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void btRemoveActionPerformed(ActionEvent evt) {
        int index = this.listFields.getSelectedIndex();
        DefaultListModel listModel = (DefaultListModel)this.listFields.getModel();
        listModel.remove(index);
        this.listFields.invalidate();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.jd.setVisible(false);
        this.jd.dispose();
        this.jd.setDefaultCloseOperation(0);
    }

    public String getQuery() {
        int i;
        DefaultListModel listModel = (DefaultListModel)this.listFields.getModel();
        this.SQLCommand = "(";
        String[] rowData = new String[listModel.getSize()];
        for (i = 0; i < rowData.length; ++i) {
            rowData[i] = "";
        }
        for (i = 0; i < rowData.length; ++i) {
            FieldDetails fd = (FieldDetails)listModel.elementAt(i);
            int n = i;
            rowData[n] = rowData[n] + fd.getFieldName();
            int n2 = i;
            rowData[n2] = rowData[n2] + " ";
            int n3 = i;
            rowData[n3] = rowData[n3] + fd.getFieldType();
            int n4 = i;
            rowData[n4] = rowData[n4] + "(";
            int n5 = i;
            rowData[n5] = rowData[n5] + fd.getFieldLength();
            int n6 = i;
            rowData[n6] = rowData[n6] + ")";
            if (fd.IsUnisigned()) {
                int n7 = i;
                rowData[n7] = rowData[n7] + " UNSIGNED ";
            }
            if (fd.IsBinary()) {
                int n8 = i;
                rowData[n8] = rowData[n8] + " BINARY ";
            }
            if (fd.IsZeroFill()) {
                int n9 = i;
                rowData[n9] = rowData[n9] + " ZEROFILL ";
            }
            if (fd.getDefault().length() > 0) {
                int n10 = i;
                rowData[n10] = rowData[n10] + " DEFAULT '" + fd.getDefault() + "'";
            }
            if (fd.IsNotNull()) {
                int n11 = i;
                rowData[n11] = rowData[n11] + " NOT NULL ";
            }
            if (fd.IsAutoIncrement()) {
                int n12 = i;
                rowData[n12] = rowData[n12] + "AUTO_INCREMENT ";
            }
            if (fd.IsPrimary()) {
                int n13 = i;
                rowData[n13] = rowData[n13] + ", PRIMARY KEY(" + fd.getFieldName() + ")";
            }
            if (fd.IsUnique()) {
                int n14 = i;
                rowData[n14] = rowData[n14] + ", UNIQUE(" + fd.getFieldName() + ")";
            }
            if (!fd.IsIndex()) continue;
            int n15 = i;
            rowData[n15] = rowData[n15] + ", INDEX(" + fd.getFieldName() + ")";
        }
        for (i = 0; i < rowData.length; ++i) {
            this.SQLCommand = this.SQLCommand + rowData[i];
            if (i >= rowData.length - 1) continue;
            this.SQLCommand = this.SQLCommand + ", ";
        }
        this.SQLCommand = this.SQLCommand + ")";
        if (this.cbTableType.getSelectedIndex() > 0) {
            this.SQLCommand = this.SQLCommand + " TYPE = " + this.cbTableType.getSelectedItem() + " ;";
        }
        this.SQLCommandRoot = this.SQLCommandRoot + this.tfTableName.getText();
        this.SQLCommand = this.SQLCommandRoot + this.SQLCommand;
        return this.SQLCommand;
    }
}

