/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import net.sourceforge.squirrel_sql.client.session.DefaultSQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;

public class DropDatabaseCommand
implements ICommand {
    private ISession _session;
    private final MysqlPlugin _plugin;
    private final IDatabaseObjectInfo[] _dbs;

    public DropDatabaseCommand(ISession session, MysqlPlugin plugin, IDatabaseObjectInfo[] dbs) {
        if (session == null) {
            throw new IllegalArgumentException("IClientSession == null");
        }
        if (dbs == null) {
            throw new IllegalArgumentException("Databases array is null");
        }
        this._session = session;
        this._plugin = plugin;
        this._dbs = dbs;
    }

    public void execute() {
        if (this._dbs.length > 0) {
            String sqlSep = this._session.getQueryTokenizer().getSQLStatementSeparator();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this._dbs.length; ++i) {
                IDatabaseObjectInfo ti = this._dbs[i];
                buf.append("drop database ").append(ti.getQualifiedName()).append(" ").append(sqlSep).append('\n');
            }
            SQLExecuterTask executer = new SQLExecuterTask(this._session, buf.toString(), (ISQLExecuterHandler)new DefaultSQLExecuterHandler(this._session));
            executer.run();
        }
    }
}

