/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.gui.controls.ColumnsComboBox;
import net.sourceforge.squirrel_sql.client.gui.controls.DataTypesComboBox;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.sql.DataTypeInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.gui.AlterTablePanelBuilder;

class AlterColumnsPanelBuilder {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AlterTablePanelBuilder.class);
    private Map<String, DataTypeInfo> _dataTypesByTypeName;
    private ControlMediator _mediator;
    private ColumnsComboBox _columnsCmb;
    private DataTypesComboBox _dataTypesCmb;
    private IntegerField _columnLengthField;
    private JTextField _defaultvalue;
    private JCheckBox _allowNullChk;
    private JCheckBox _autoIncChk;
    private JCheckBox _unsignedChk;
    private JCheckBox _binaryChk;
    private JCheckBox _zeroFillChk;

    AlterColumnsPanelBuilder() {
    }

    public JPanel buildPanel(ISession session, ITableInfo ti) throws SQLException {
        this.initComponents(session, ti);
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)GUIUtils.createHorizontalSeparatorPanel((String)s_stringMgr.getString("AlterColumnsPanelBuilder.selectcolumn")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("AlterColumnsPanelBuilder.columnname")), gbc);
        gbc = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._columnsCmb, gbc);
        gbc = new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)GUIUtils.createHorizontalSeparatorPanel((String)s_stringMgr.getString("AlterColumnsPanelBuilder.attributes")), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("AlterColumnsPanelBuilder.datatype")), gbc);
        gbc = new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._dataTypesCmb, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("AlterColumnsPanelBuilder.length")), gbc);
        gbc = new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._columnLengthField, gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("AlterColumnsPanelBuilder.default")), gbc);
        gbc = new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._defaultvalue, gbc);
        gbc = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._unsignedChk, gbc);
        gbc = new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._autoIncChk, gbc);
        gbc = new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._binaryChk, gbc);
        gbc = new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._zeroFillChk, gbc);
        gbc = new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)this._allowNullChk, gbc);
        GUIUtils.setPreferredWidth((Component)ret, (int)450);
        return ret;
    }

    private void updateControlStatus() {
        TableColumnInfo tci = this._columnsCmb.getSelectedColumn();
        this._dataTypesCmb.setSelectedItem((Object)this._dataTypesByTypeName.get(tci.getTypeName().toUpperCase()));
        this._columnLengthField.setInt(tci.getColumnSize());
        this._defaultvalue.setText(tci.getDefaultValue());
    }

    private void initComponents(ISession session, ITableInfo ti) throws SQLException {
        this._dataTypesByTypeName = new HashMap<String, DataTypeInfo>();
        this._mediator = new ControlMediator();
        ISQLConnection conn = session.getSQLConnection();
        this._columnsCmb = new ColumnsComboBox(conn, ti);
        this._dataTypesCmb = new DataTypesComboBox(conn);
        int limit = this._dataTypesCmb.getItemCount();
        for (int i = 0; i < limit; ++i) {
            DataTypeInfo dti = this._dataTypesCmb.getDataTypeAt(i);
            this._dataTypesByTypeName.put(dti.getSimpleName().toUpperCase(), dti);
        }
        this._columnLengthField = new IntegerField();
        this._defaultvalue = new JTextField();
        this._allowNullChk = new JCheckBox(s_stringMgr.getString("AlterColumnsPanelBuilder.allownull"));
        this._unsignedChk = new JCheckBox(s_stringMgr.getString("AlterColumnsPanelBuilder.unsigned"));
        this._autoIncChk = new JCheckBox(s_stringMgr.getString("AlterColumnsPanelBuilder.autoinc"));
        this._binaryChk = new JCheckBox(s_stringMgr.getString("AlterColumnsPanelBuilder.binary"));
        this._zeroFillChk = new JCheckBox(s_stringMgr.getString("AlterColumnsPanelBuilder.zerofill"));
        this._columnsCmb.addActionListener((ActionListener)this._mediator);
        this.updateControlStatus();
    }

    private final class ControlMediator
    implements ActionListener {
        private ControlMediator() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AlterColumnsPanelBuilder.this.updateControlStatus();
        }
    }
}

