/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mysql.gui.AlterColumnsPanelBuilder;

public class AlterTableDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AlterTableDialog.class);

    public AlterTableDialog(ISession session, MysqlPlugin plugin, ITableInfo ti) throws SQLException {
        super(AlterTableDialog.ctorHelper(session, plugin, ti), true);
        this.createGUI(session, plugin, ti);
    }

    private void createGUI(ISession session, MysqlPlugin plugin, ITableInfo ti) throws SQLException {
        this.setDefaultCloseOperation(2);
        this.setTitle(s_stringMgr.getString("AlterTableDialog.title", new Object[]{ti.getQualifiedName()}));
        this.setContentPane(this.buildContentPane(session, plugin, ti));
    }

    private JComponent buildContentPane(ISession session, MysqlPlugin plugin, ITableInfo ti) throws SQLException {
        JPanel pnl = new JPanel(new BorderLayout(5, 5));
        pnl.add((Component)this.buildMainPanel(session, ti), "Center");
        pnl.add((Component)this.buildToolBar(), "South");
        pnl.setBorder(BorderFactory.createEtchedBorder());
        return pnl;
    }

    private JTabbedPane buildMainPanel(ISession session, ITableInfo ti) throws SQLException {
        JTabbedPane tabPnl = UIFactory.getInstance().createTabbedPane();
        JPanel pnl = new AlterColumnsPanelBuilder().buildPanel(session, ti);
        tabPnl.addTab(AlterTableDialog.getString("AlterTableDialog.columns"), null, pnl, AlterTableDialog.getString("AlterTableDialog.columnshint"));
        return tabPnl;
    }

    private JPanel buildToolBar() {
        return GUIUtils.createButtonBar((JButton[])new JButton[]{new JButton(s_stringMgr.getString("mysql.alterDlgAlter")), new JButton(s_stringMgr.getString("mysql.alterDlgClose"))});
    }

    private static String getString(String stringMgrKey) {
        return s_stringMgr.getString(stringMgrKey);
    }

    private static Frame ctorHelper(ISession session, MysqlPlugin plugin, ITableInfo ti) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("MysqlPlugin == null");
        }
        if (ti == null) {
            throw new IllegalArgumentException("ITableInfo == null");
        }
        return session.getApplication().getMainFrame();
    }
}

