/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.tab;

import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.tab.BaseSQLTab;

public class UserGrantsTab
extends BaseSQLTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UserGrantsTab.class);

    public UserGrantsTab() {
        super(i18n.TITLE, i18n.HINT);
    }

    @Override
    protected String getSQL() {
        String db = this.getDatabaseObjectInfo().getQualifiedName();
        return "show grants for " + db;
    }

    private static String fixQuotes(String user) {
        String[] parts = user.split("\\@");
        Object first = "";
        first = parts[0].length() > 1 ? parts[0] + "'" : "'%'";
        Object last = "";
        last = parts[1].length() > 1 ? "'" + parts[1] : "'%'";
        return (String)first + "@" + (String)last;
    }

    public static void main(String[] args) {
        String newString = UserGrantsTab.fixQuotes("'root@'");
        System.out.println("fixQuotes(@localhost)=" + newString);
    }

    private static interface i18n {
        public static final String TITLE = s_stringMgr.getString("mysql.grants");
        public static final String HINT = s_stringMgr.getString("mysql.hintGrants");
    }
}

