/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.tokenizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.ITokenizerFactory;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MysqlQueryTokenizer
extends QueryTokenizer
implements IQueryTokenizer {
    private static final ILogger s_log = LoggerController.createLogger(MysqlQueryTokenizer.class);
    private static final String PROCEDURE_PATTERN = "^\\s*CREATE\\s+PROCEDURE.*";
    private static final String FUNCTION_PATTERN = "^\\s*CREATE\\s+FUNCTION.*";
    private static final String TRIGGER_PATTERN = "^\\s*CREATE\\s+TRIGGER.*";
    private Pattern procPattern = Pattern.compile("^\\s*CREATE\\s+PROCEDURE.*", 32);
    private Pattern funcPattern = Pattern.compile("^\\s*CREATE\\s+FUNCTION.*", 32);
    private Pattern triggerPattern = Pattern.compile("^\\s*CREATE\\s+TRIGGER.*", 32);
    private IQueryTokenizerPreferenceBean _prefs = null;

    public MysqlQueryTokenizer(IQueryTokenizerPreferenceBean prefs) {
        super(prefs.getStatementSeparator(), prefs.getLineComment(), prefs.isRemoveMultiLineComments(), prefs.isRemoveLineComments());
        this._prefs = prefs;
    }

    public void setScriptToTokenize(String script) {
        super.setScriptToTokenize(script);
        this.breakApartNewLines();
        this.joinFragments(this.procPattern, false);
        this.joinFragments(this.funcPattern, false);
        this.joinFragments(this.triggerPattern, false);
        this._queryIterator = this._queries.iterator();
    }

    protected void setFactory() {
        this._tokenizerFactory = new ITokenizerFactory(){

            public IQueryTokenizer getTokenizer() {
                return new MysqlQueryTokenizer(MysqlQueryTokenizer.this._prefs);
            }
        };
    }

    private void breakApartNewLines() {
        ArrayList<QueryHolder> tmp = new ArrayList<QueryHolder>();
        String procSep = this._prefs.getProcedureSeparator();
        Iterator iter = this._queries.iterator();
        while (iter.hasNext()) {
            int i;
            String[] parts;
            String next = ((QueryHolder)iter.next()).getQuery();
            if (next.startsWith(procSep)) {
                tmp.add(new QueryHolder(procSep));
                parts = next.split(procSep + "\\n+");
                for (i = 0; i < parts.length; ++i) {
                    if ("".equals(parts[i]) || procSep.equals(parts[i])) continue;
                    tmp.add(new QueryHolder(parts[i]));
                }
                continue;
            }
            if (next.endsWith(procSep)) {
                String chopped = StringUtilities.chop((String)next);
                tmp.add(new QueryHolder(chopped));
                tmp.add(new QueryHolder(procSep));
                continue;
            }
            if (next.indexOf(procSep) != -1) {
                parts = next.split("\\" + procSep);
                for (i = 0; i < parts.length; ++i) {
                    tmp.add(new QueryHolder(parts[i]));
                    if (i >= parts.length - 1) continue;
                    tmp.add(new QueryHolder(procSep));
                }
                continue;
            }
            tmp.add(new QueryHolder(next));
        }
        this._queries = tmp;
    }

    private void joinFragments(Pattern pattern, boolean skipStraySep) {
        boolean inMultiSQLStatement = false;
        StringBuilder collector = null;
        ArrayList<QueryHolder> tmp = new ArrayList<QueryHolder>();
        String procSep = this._prefs.getProcedureSeparator();
        String stmtSep = this._prefs.getStatementSeparator();
        Iterator iter = this._queries.iterator();
        while (iter.hasNext()) {
            String next = ((QueryHolder)iter.next()).getQuery();
            if (next.startsWith("DELIMITER")) {
                String[] parts = StringUtilities.split((String)next, (char)' ', (boolean)true);
                if (parts.length == 2) {
                    procSep = parts[1];
                } else {
                    s_log.error((Object)("Found DELIMITER keyword, followed by " + (parts.length - 1) + " elements; expected only one: " + next + "\nSkipping DELIMITER directive."));
                }
            }
            if (pattern.matcher(next.toUpperCase()).matches()) {
                inMultiSQLStatement = true;
                collector = new StringBuilder(next);
                collector.append(stmtSep);
                continue;
            }
            if (next.startsWith(procSep)) {
                inMultiSQLStatement = false;
                if (collector != null) {
                    tmp.add(new QueryHolder(collector.toString()));
                    collector = null;
                    continue;
                }
                if (skipStraySep) {
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("Detected stray proc separator(" + procSep + "). Skipping"));
                    continue;
                }
                tmp.add(new QueryHolder(next));
                continue;
            }
            if (inMultiSQLStatement) {
                collector.append(next);
                collector.append(stmtSep);
                continue;
            }
            tmp.add(new QueryHolder(next));
        }
        if (collector != null && inMultiSQLStatement) {
            tmp.add(new QueryHolder(collector.toString()));
        }
        this._queries = tmp;
    }

    public TokenizerSessPropsInteractions getTokenizerSessPropsInteractions() {
        if (this._prefs.isInstallCustomQueryTokenizer()) {
            TokenizerSessPropsInteractions ret = new TokenizerSessPropsInteractions();
            ret.setTokenizerDefinesRemoveMultiLineComment(true);
            ret.setTokenizerDefinesRemoveLineComment(true);
            ret.setTokenizerDefinesStartOfLineComment(true);
            ret.setTokenizerDefinesStatementSeparator(true);
            return ret;
        }
        return super.getTokenizerSessPropsInteractions();
    }
}

