/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.preferences.themes.ThemesEnum;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.Completor;
import net.sourceforge.squirrel_sql.fw.completion.CompletorListener;
import net.sourceforge.squirrel_sql.fw.completion.ICompletorModel;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.RunBookmarkCommand;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPlugin;

public class CompleteBookmarkAction
extends SquirrelAction {
    private ISQLEntryPanel _sqlEntryPanel;
    private Completor _cc;
    private SQLBookmarkPlugin _plugin;

    public CompleteBookmarkAction(IApplication app, IResources resources, ISQLEntryPanel sqlEntryPanel, SQLBookmarkPlugin plugin) {
        super(app, resources);
        this._sqlEntryPanel = sqlEntryPanel;
        this._plugin = plugin;
        CompletorListener completorListener = new CompletorListener(){

            public void completionSelected(CompletionInfo completion, int replaceBegin, int keyCode, int modifiers) {
                CompleteBookmarkAction.this.performCompletionSelected(completion);
            }
        };
        this._cc = new Completor((JTextComponent)this._sqlEntryPanel.getTextComponent(), (ICompletorModel)plugin.getBookmarkManager(), completorListener, CompleteBookmarkAction.getBookmarksPopUpBackGround(), true);
        sqlEntryPanel.getSession().addSimpleSessionListener(new SimpleSessionListener(){

            public void sessionClosed() {
                CompleteBookmarkAction.this._cc.disposePopup();
            }
        });
    }

    private static Color getBookmarksPopUpBackGround() {
        switch (ThemesEnum.getCurrentTheme()) {
            case LIGH: {
                return new Color(204, 255, 255);
            }
            case DARK: {
                return new Color(0, 10, 50);
            }
        }
        throw new IllegalStateException("Unknown theme; " + ThemesEnum.getCurrentTheme());
    }

    public void actionPerformed(ActionEvent evt) {
        this._cc.show();
    }

    private void performCompletionSelected(CompletionInfo completion) {
        Bookmark bm = ((BookmarkCompletionInfo)completion).getBookmark();
        new RunBookmarkCommand((Frame)this.getApplication().getMainFrame(), this._sqlEntryPanel.getSession(), bm, this._plugin, this._sqlEntryPanel).execute();
    }
}

