/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookMarksUtil;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkEditController;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkManager;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.DefaultBookmarksFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.RunBookmarkCommand;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.exportimport.BookmarkExportImport;
import org.apache.commons.lang3.ArrayUtils;

public class SQLBookmarkPreferencesController
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLBookmarkPreferencesController.class);
    private SQLBookmarkPreferencesPanel _pnlPrefs;
    protected SQLBookmarkPlugin _plugin;
    private DefaultMutableTreeNode _nodeSquirrelMarks;
    private DefaultMutableTreeNode _nodeUserMarks;

    public SQLBookmarkPreferencesController(SQLBookmarkPlugin plugin) {
        this._plugin = plugin;
    }

    public void initialize(IApplication app) {
        this._pnlPrefs.btnEdit.setText(s_stringMgr.getString("SQLBookmarkPreferencesPanel.sqlbookmark.btnTextEdit"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this._nodeSquirrelMarks = new DefaultMutableTreeNode(s_stringMgr.getString("sqlbookmark.nodeSquirrelMarks"));
        this._nodeUserMarks = new DefaultMutableTreeNode(s_stringMgr.getString("sqlbookmark.nodeUserMarks"));
        root.add(this._nodeUserMarks);
        root.add(this._nodeSquirrelMarks);
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this._pnlPrefs.treBookmarks.setModel(dtm);
        this._pnlPrefs.treBookmarks.setRootVisible(false);
        this._pnlPrefs.treBookmarks.getSelectionModel().setSelectionMode(4);
        Bookmark[] defaultBookmarks = DefaultBookmarksFactory.getDefaultBookmarks();
        for (int i = 0; i < defaultBookmarks.length; ++i) {
            this._nodeSquirrelMarks.add(new DefaultMutableTreeNode(defaultBookmarks[i]));
        }
        Iterator<Bookmark> i = this._plugin.getBookmarkManager().iterator();
        while (i.hasNext()) {
            Bookmark mark = i.next();
            this._nodeUserMarks.add(new DefaultMutableTreeNode(mark));
        }
        this._pnlPrefs.treBookmarks.expandPath(new TreePath(dtm.getPathToRoot(this._nodeUserMarks)));
        String propDefaultMarksInPopup = this._plugin.getBookmarkProperties().getProperty("squirrelMarksInPopup", "false");
        this._pnlPrefs.chkSquirrelMarksInPopup.setSelected(Boolean.valueOf(propDefaultMarksInPopup));
        String useContainsToFilterBookmarks = this._plugin.getBookmarkProperties().getProperty("useContainsToFilterBookmarks", "false");
        this._pnlPrefs.chkUseContainsToFilterBookmarks.setSelected(Boolean.valueOf(useContainsToFilterBookmarks));
        this._pnlPrefs.treBookmarks.getSelectionModel().addTreeSelectionListener(e -> this.updateButtonsEnabled());
        this._pnlPrefs.btnRun.addActionListener(e -> this.onRun());
        this._pnlPrefs.btnAdd.addActionListener(e -> this.onAdd());
        this._pnlPrefs.btnEdit.addActionListener(e -> this.onEdit());
        this._pnlPrefs.btnDel.addActionListener(e -> this.onDelete());
        this._pnlPrefs.btnUp.addActionListener(e -> this.onUp());
        this._pnlPrefs.btnDown.addActionListener(e -> this.onDown());
        this._pnlPrefs.btnExport.addActionListener(e -> BookmarkExportImport.exportBookMarks(this._nodeUserMarks, this._pnlPrefs.treBookmarks));
        this._pnlPrefs.btnImport.addActionListener(e -> BookmarkExportImport.importBookMarks(this._nodeUserMarks, this._pnlPrefs.treBookmarks));
        this.updateButtonsEnabled();
    }

    public void uninitialize(IApplication app) {
        this._plugin.removeALLSQLPanelsAPIListeningForBookmarks();
    }

    public String getTitle() {
        return this._plugin.getResourceString("prefs.title");
    }

    public String getHint() {
        return this._plugin.getResourceString("prefs.hint");
    }

    public void applyChanges() {
        BookmarkManager bookmarks = this._plugin.getBookmarkManager();
        bookmarks.removeAll();
        for (int i = 0; i < this._nodeUserMarks.getChildCount(); ++i) {
            Bookmark bookmark = (Bookmark)((DefaultMutableTreeNode)this._nodeUserMarks.getChildAt(i)).getUserObject();
            bookmarks.add(bookmark);
        }
        this._plugin.rebuildMenu();
        bookmarks.save();
        this._plugin.getBookmarkProperties().put("squirrelMarksInPopup", "" + this._pnlPrefs.chkSquirrelMarksInPopup.isSelected());
        this._plugin.getBookmarkProperties().put("useContainsToFilterBookmarks", "" + this._pnlPrefs.chkUseContainsToFilterBookmarks.isSelected());
        this._plugin.saveBookmarkProperties();
    }

    public Component getPanelComponent() {
        this._pnlPrefs = new SQLBookmarkPreferencesPanel(this._plugin);
        return this._pnlPrefs;
    }

    private void updateButtonsEnabled() {
        TreePath[] selectionPaths = this._pnlPrefs.treBookmarks.getSelectionPaths();
        if (null == selectionPaths || 0 == selectionPaths.length) {
            this._pnlPrefs.btnUp.setEnabled(false);
            this._pnlPrefs.btnDown.setEnabled(false);
            this._pnlPrefs.btnDel.setEnabled(false);
            this._pnlPrefs.btnEdit.setEnabled(false);
            this._pnlPrefs.btnRun.setEnabled(false);
            this._pnlPrefs.btnImport.setEnabled(true);
            this._pnlPrefs.btnExport.setEnabled(true);
            return;
        }
        this._pnlPrefs.btnUp.setEnabled(true);
        this._pnlPrefs.btnDown.setEnabled(true);
        this._pnlPrefs.btnDel.setEnabled(true);
        this._pnlPrefs.btnEdit.setEnabled(true);
        this._pnlPrefs.btnRun.setEnabled(true);
        this._pnlPrefs.btnImport.setEnabled(true);
        this._pnlPrefs.btnExport.setEnabled(true);
        if (1 < selectionPaths.length) {
            this._pnlPrefs.btnRun.setEnabled(false);
            this._pnlPrefs.btnEdit.setEnabled(false);
            if (!BookMarksUtil.areOnlyUserBookmarksSelected(selectionPaths, this._nodeUserMarks)) {
                this._pnlPrefs.btnUp.setEnabled(false);
                this._pnlPrefs.btnDown.setEnabled(false);
                this._pnlPrefs.btnDel.setEnabled(false);
                this._pnlPrefs.btnImport.setEnabled(false);
                this._pnlPrefs.btnExport.setEnabled(false);
            }
        } else {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)selectionPaths[0].getLastPathComponent();
            if (dmtn.getUserObject() instanceof Bookmark) {
                if (dmtn.getParent() == this._nodeSquirrelMarks) {
                    this._pnlPrefs.btnUp.setEnabled(false);
                    this._pnlPrefs.btnDown.setEnabled(false);
                    this._pnlPrefs.btnDel.setEnabled(false);
                    this._pnlPrefs.btnImport.setEnabled(false);
                    this._pnlPrefs.btnExport.setEnabled(false);
                    this._pnlPrefs.btnEdit.setText(s_stringMgr.getString("SQLBookmarkPreferencesPanel.sqlbookmark.btnTextView"));
                } else {
                    this._pnlPrefs.btnEdit.setText(s_stringMgr.getString("SQLBookmarkPreferencesPanel.sqlbookmark.btnTextEdit"));
                }
            } else {
                this._pnlPrefs.btnUp.setEnabled(false);
                this._pnlPrefs.btnDown.setEnabled(false);
                this._pnlPrefs.btnEdit.setEnabled(false);
                this._pnlPrefs.btnDel.setEnabled(false);
                this._pnlPrefs.btnImport.setEnabled(this._nodeUserMarks == dmtn);
                this._pnlPrefs.btnExport.setEnabled(false);
            }
        }
    }

    private void onRun() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark)) {
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("sqlbookmark.noRunSelection"));
            return;
        }
        ISQLPanelAPI[] apis = this._plugin.getSQLPanelAPIsListeningForBookmarks();
        if (0 == apis.length) {
            JOptionPane.showMessageDialog((Component)Main.getApplication().getMainFrame(), s_stringMgr.getString("sqlbookmark.noSQLPanel"));
            return;
        }
        Bookmark bm = (Bookmark)selNode.getUserObject();
        for (int i = 0; i < apis.length; ++i) {
            ISQLPanelAPI api = apis[i];
            new RunBookmarkCommand((Frame)Main.getApplication().getMainFrame(), api.getSession(), bm, this._plugin, api.getSQLEntryPanel()).execute();
        }
    }

    public void onAdd() {
        BookmarkEditController ctrlr = new BookmarkEditController((Frame)Main.getApplication().getMainFrame(), null, true, this._nodeUserMarks);
        if (ctrlr.isCanceled()) {
            return;
        }
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(ctrlr.getBookmark());
        this._nodeUserMarks.add(newChild);
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        this.selectNode(newChild);
    }

    private void selectNode(DefaultMutableTreeNode toSel) {
        Object[] pathToRoot = ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).getPathToRoot(toSel);
        this._pnlPrefs.treBookmarks.setSelectionPath(new TreePath(pathToRoot));
    }

    public void onEdit() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark)) {
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("sqlbookmark.noEditSelection"));
            return;
        }
        boolean editable = selNode.getParent() == this._nodeUserMarks;
        BookmarkEditController ctrlr = new BookmarkEditController((Frame)Main.getApplication().getMainFrame(), (Bookmark)selNode.getUserObject(), editable, this._nodeUserMarks);
        if (ctrlr.isCanceled()) {
            return;
        }
        selNode.setUserObject(ctrlr.getBookmark());
        this.refreshTree(selNode);
    }

    private void refreshTree(DefaultMutableTreeNode selNode) {
        boolean squirrelPathExpanded = this._pnlPrefs.treBookmarks.isExpanded(new TreePath(this._nodeSquirrelMarks.getPath()));
        DefaultTreeModel model = (DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel();
        TreeNode root = (TreeNode)model.getRoot();
        model.setRoot(null);
        model.setRoot(root);
        this._pnlPrefs.treBookmarks.setSelectionPath(new TreePath(selNode.getPath()));
        if (squirrelPathExpanded) {
            this._pnlPrefs.treBookmarks.expandPath(new TreePath(this._nodeSquirrelMarks.getPath()));
        }
    }

    public void onDelete() {
        DefaultMutableTreeNode selNode = null;
        if (null != this._pnlPrefs.treBookmarks.getSelectionPath()) {
            selNode = (DefaultMutableTreeNode)this._pnlPrefs.treBookmarks.getSelectionPath().getLastPathComponent();
        }
        if (null == selNode || !(selNode.getUserObject() instanceof Bookmark)) {
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("sqlbookmark.noDeleteSelection"));
            return;
        }
        int ret = JOptionPane.showConfirmDialog((Component)Main.getApplication().getMainFrame(), s_stringMgr.getString("sqlbookmark.deleteConfirm"));
        if (0 != ret) {
            return;
        }
        DefaultMutableTreeNode nextSel = selNode.getNextSibling();
        if (null == nextSel) {
            nextSel = selNode.getPreviousSibling();
        }
        this._nodeUserMarks.remove(selNode);
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        if (null != nextSel) {
            this.selectNode(nextSel);
        }
    }

    private void onUp() {
        TreePath[] selPaths = this._pnlPrefs.treBookmarks.getSelectionPaths();
        if (null == selPaths || 0 == selPaths.length) {
            return;
        }
        boolean pathsContainTheFirstNode = Arrays.stream(selPaths).anyMatch(p -> null == ((DefaultMutableTreeNode)p.getLastPathComponent()).getPreviousSibling());
        if (pathsContainTheFirstNode) {
            return;
        }
        Arrays.sort(selPaths, Comparator.comparingInt(o -> this._nodeUserMarks.getIndex((DefaultMutableTreeNode)o.getLastPathComponent())));
        for (TreePath selPath : selPaths) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            int selIx = this._nodeUserMarks.getIndex(selNode);
            this._nodeUserMarks.insert(selNode, selIx - 1);
        }
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        this._pnlPrefs.treBookmarks.setSelectionPaths(selPaths);
    }

    private void onDown() {
        Object[] selPaths = this._pnlPrefs.treBookmarks.getSelectionPaths();
        if (null == selPaths || 0 == selPaths.length) {
            return;
        }
        boolean pathsContainTheLastNode = Arrays.stream(selPaths).anyMatch(p -> null == ((DefaultMutableTreeNode)p.getLastPathComponent()).getNextSibling());
        if (pathsContainTheLastNode) {
            return;
        }
        Arrays.sort(selPaths, Comparator.comparingInt(o -> this._nodeUserMarks.getIndex((DefaultMutableTreeNode)o.getLastPathComponent())));
        ArrayUtils.reverse((Object[])selPaths);
        for (Object selPath : selPaths) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)((TreePath)selPath).getLastPathComponent();
            int selIx = this._nodeUserMarks.getIndex(selNode);
            this._nodeUserMarks.insert(selNode, selIx + 1);
        }
        ((DefaultTreeModel)this._pnlPrefs.treBookmarks.getModel()).nodeStructureChanged(this._nodeUserMarks);
        this._pnlPrefs.treBookmarks.setSelectionPaths((TreePath[])selPaths);
    }
}

