/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark.exportimport;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookMarksUtil;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.exportimport.BookmarkImportConflictOption;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.exportimport.ImportDuplicateNameCtrl;

public class BookmarkExportImport {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BookmarkExportImport.class);
    private static final ILogger s_log = LoggerController.createLogger(BookmarkExportImport.class);
    private static final String PREF_LAST_BOOKMARK_EXPORT_IMPORT_FILE_DIR = "BookmarkImportExport.last.bookmark.export.import.file.dir";

    public static void exportBookMarks(DefaultMutableTreeNode nodeUserMarks, JTree treBookmarks) {
        try {
            TreePath[] selectionPaths = treBookmarks.getSelectionPaths();
            if (null == selectionPaths || 0 == selectionPaths.length || !BookMarksUtil.areOnlyUserBookmarksSelected(selectionPaths, nodeUserMarks)) {
                JOptionPane.showMessageDialog(treBookmarks, s_stringMgr.getString("BookmarkImportExport.userbookmarks.only"));
                return;
            }
            JFileChooser exportFC = BookmarkExportImport.createFileChooser();
            exportFC.setDialogTitle(s_stringMgr.getString("BookmarkImportExport.export.file.dialog.title"));
            if (exportFC.showSaveDialog(treBookmarks) != 0) {
                return;
            }
            File exportFile = exportFC.getSelectedFile();
            Props.putString((String)PREF_LAST_BOOKMARK_EXPORT_IMPORT_FILE_DIR, (String)exportFile.getParent());
            if (!exportFile.getName().toLowerCase().endsWith(".xml")) {
                exportFile = new File(exportFile.getAbsolutePath() + ".xml");
            }
            List selectedBookmarks = Arrays.stream(selectionPaths).map(p -> (Bookmark)((DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()).collect(Collectors.toList());
            XMLBeanWriter xmlBeanWriter = new XMLBeanWriter();
            xmlBeanWriter.addIteratorToRoot(selectedBookmarks.iterator());
            xmlBeanWriter.save(exportFile);
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime((Throwable)e);
        }
    }

    public static void importBookMarks(DefaultMutableTreeNode nodeUserMarks, JTree treBookmarks) {
        try {
            JFileChooser importFC = BookmarkExportImport.createFileChooser();
            importFC.setDialogTitle(s_stringMgr.getString("BookmarkImportExport.import.file.dialog.title"));
            if (importFC.showOpenDialog(treBookmarks) != 0) {
                return;
            }
            File importFile = importFC.getSelectedFile();
            Props.putString((String)PREF_LAST_BOOKMARK_EXPORT_IMPORT_FILE_DIR, (String)importFile.getParent());
            List<Bookmark> importBookmarks = BookmarkExportImport.readBookmarks(importFile, treBookmarks);
            if (null == importBookmarks) {
                return;
            }
            ArrayList<Bookmark> conflictingImportBookmarks = new ArrayList<Bookmark>();
            BookmarkImportConflictOption conflictOption = null;
            for (int i = 0; i < nodeUserMarks.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeUserMarks.getChildAt(i);
                Bookmark bookmark = (Bookmark)node.getUserObject();
                for (Bookmark importBookmark : importBookmarks) {
                    if (!StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace((String)bookmark.getName(), (String)importBookmark.getName())) continue;
                    if (null == conflictOption && null == (conflictOption = new ImportDuplicateNameCtrl(GUIUtils.getOwningWindow((Component)treBookmarks)).getChosenOption())) {
                        return;
                    }
                    conflictingImportBookmarks.add(importBookmark);
                }
            }
            List<Bookmark> bookmarksToAdd = BookmarkExportImport.applyConflictOption(nodeUserMarks, importBookmarks, conflictingImportBookmarks, conflictOption);
            BookmarkExportImport.addBookmarks(nodeUserMarks, treBookmarks, bookmarksToAdd);
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime((Throwable)e);
        }
    }

    private static List<Bookmark> applyConflictOption(DefaultMutableTreeNode nodeUserMarks, List<Bookmark> importBookmarks, ArrayList<Bookmark> conflictingImportBookmarks, BookmarkImportConflictOption conflictOption) {
        ArrayList<Bookmark> ret;
        if (null == conflictOption) {
            BookmarkExportImport.messageImport(importBookmarks, false);
            return importBookmarks;
        }
        switch (conflictOption) {
            case COPY: {
                ret = new ArrayList<Bookmark>(importBookmarks);
                block5: for (Bookmark conflictingImportBookmark : conflictingImportBookmarks) {
                    int i = 1;
                    while (true) {
                        String copyName;
                        if (BookmarkExportImport.isNameUnique(copyName = conflictingImportBookmark.getName() + "_" + i, nodeUserMarks, importBookmarks)) {
                            conflictingImportBookmark.setName(copyName);
                            continue block5;
                        }
                        ++i;
                    }
                }
                BookmarkExportImport.messageImport(ret, false);
                break;
            }
            case IGNORE: {
                ret = new ArrayList<Bookmark>(importBookmarks);
                ret.removeAll(conflictingImportBookmarks);
                BookmarkExportImport.messageImport(ret, false);
                break;
            }
            case UPDATE: {
                ret = new ArrayList<Bookmark>(importBookmarks);
                ret.removeAll(conflictingImportBookmarks);
                for (Bookmark conflictingImportBookmark : conflictingImportBookmarks) {
                    DefaultMutableTreeNode node = BookmarkExportImport.findNodeByBookmarkName(nodeUserMarks, conflictingImportBookmark.getName());
                    Bookmark bookmarkToUpdate = (Bookmark)node.getUserObject();
                    bookmarkToUpdate.setDescription(conflictingImportBookmark.getDescription());
                    bookmarkToUpdate.setSql(conflictingImportBookmark.getSql());
                }
                BookmarkExportImport.messageImport(ret, false);
                BookmarkExportImport.messageImport(conflictingImportBookmarks, true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown option " + conflictOption);
            }
        }
        return ret;
    }

    private static void messageImport(List<Bookmark> importBookmarks, boolean updatedExistingBookmarks) {
        String importedBookmarkNames = importBookmarks.stream().map(b -> "\"" + b.getName() + "\"").collect(Collectors.joining(", "));
        if (StringUtilities.isEmpty((String)importedBookmarkNames, (boolean)true)) {
            importedBookmarkNames = s_stringMgr.getString("BookmarkImportExport.none");
        }
        if (updatedExistingBookmarks) {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("BookmarkImportExport.update.bookmarks.list", new Object[]{importedBookmarkNames}));
        } else {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("BookmarkImportExport.imported.bookmarks.list", new Object[]{importedBookmarkNames}));
        }
    }

    private static boolean isNameUnique(String nameToCheck, DefaultMutableTreeNode nodeUserMarks, List<Bookmark> importBookmarks) {
        for (int i = 0; i < nodeUserMarks.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeUserMarks.getChildAt(i);
            Bookmark bookmark = (Bookmark)node.getUserObject();
            if (!StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace((String)bookmark.getName(), (String)nameToCheck)) continue;
            return false;
        }
        for (Bookmark importBookmark : importBookmarks) {
            if (!StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace((String)importBookmark.getName(), (String)nameToCheck)) continue;
            return false;
        }
        return true;
    }

    private static DefaultMutableTreeNode findNodeByBookmarkName(DefaultMutableTreeNode nodeUserMarks, String bookmarkName) {
        for (int i = 0; i < nodeUserMarks.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeUserMarks.getChildAt(i);
            Bookmark bookmark = (Bookmark)node.getUserObject();
            if (!StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace((String)bookmark.getName(), (String)bookmarkName)) continue;
            return node;
        }
        throw new IllegalStateException("Didn't find Bookmark named " + bookmarkName);
    }

    private static void addBookmarks(DefaultMutableTreeNode nodeUserMarks, JTree treBookmarks, List<Bookmark> bookmarksToAdd) {
        ArrayList<DefaultMutableTreeNode> nodesToSelect = new ArrayList<DefaultMutableTreeNode>();
        if (null != treBookmarks.getSelectionPath() && nodeUserMarks.isNodeChild((DefaultMutableTreeNode)treBookmarks.getSelectionPath().getLastPathComponent())) {
            DefaultMutableTreeNode sibling = (DefaultMutableTreeNode)treBookmarks.getSelectionPath().getLastPathComponent();
            int insertIndex = nodeUserMarks.getIndex(sibling) + 1;
            for (Bookmark importBookmark : bookmarksToAdd) {
                DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(importBookmark);
                nodeUserMarks.insert(newChild, insertIndex);
                insertIndex = nodeUserMarks.getIndex(newChild) + 1;
                nodesToSelect.add(newChild);
            }
        } else {
            for (Bookmark importBookmark : bookmarksToAdd) {
                DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(importBookmark);
                nodeUserMarks.add(newChild);
                nodesToSelect.add(newChild);
            }
        }
        ((DefaultTreeModel)treBookmarks.getModel()).nodeStructureChanged(nodeUserMarks);
        List<TreePath> pathsToSelect = nodesToSelect.stream().map(n -> new TreePath(n.getPath())).collect(Collectors.toList());
        treBookmarks.setSelectionPaths(pathsToSelect.toArray(new TreePath[0]));
    }

    private static List<Bookmark> readBookmarks(File importFile, JTree treBookmarks) {
        try {
            XMLBeanReader xmlBeanReader = new XMLBeanReader();
            xmlBeanReader.load(importFile, Bookmark.class.getClassLoader());
            List ret = xmlBeanReader.getBeans();
            if (0 == ret.size()) {
                JOptionPane.showMessageDialog(treBookmarks, s_stringMgr.getString("BookmarkImportExport.bookmark.import.empty.dlg"));
                return null;
            }
            return ret;
        }
        catch (Exception e) {
            s_log.error((Object)s_stringMgr.getString("BookmarkImportExport.bookmark.import.error"), (Throwable)e);
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("BookmarkImportExport.bookmark.import.error"), (Throwable)e);
            JOptionPane.showMessageDialog(treBookmarks, s_stringMgr.getString("BookmarkImportExport.bookmark.import.error.dlg"), s_stringMgr.getString("BookmarkImportExport.bookmark.import.error.dlg.title"), 0);
            return null;
        }
    }

    private static JFileChooser createFileChooser() {
        JFileChooser exportFC = new JFileChooser(Props.getString((String)PREF_LAST_BOOKMARK_EXPORT_IMPORT_FILE_DIR, (String)System.getProperty("user.home")));
        for (FileFilter chooseableFileFilter : exportFC.getChoosableFileFilters()) {
            exportFC.removeChoosableFileFilter(chooseableFileFilter);
        }
        FileExtensionFilter xmlFilter = new FileExtensionFilter("Bookmark XML files", new String[]{".xml"});
        exportFC.addChoosableFileFilter((FileFilter)xmlFilter);
        return exportFC;
    }
}

