/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark.exportimport;

import java.awt.Window;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.exportimport.BookmarkImportConflictOption;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.exportimport.ImportDuplicateNameDlg;

public class ImportDuplicateNameCtrl {
    private static final String PREF_KEY_LAST_IMPORT_OPTION = "BookmarksPugin.ImportDuplicateNameCtrl.last.import.option";
    private BookmarkImportConflictOption _chosenOption;

    public ImportDuplicateNameCtrl(Window owningWindow) {
        ImportDuplicateNameDlg dlg = new ImportDuplicateNameDlg(owningWindow);
        BookmarkImportConflictOption importOption = BookmarkImportConflictOption.valueOf(Props.getString((String)PREF_KEY_LAST_IMPORT_OPTION, (String)BookmarkImportConflictOption.IGNORE.name()));
        switch (importOption) {
            case IGNORE: {
                dlg.radIgnore.setSelected(true);
                break;
            }
            case COPY: {
                dlg.radCopy.setSelected(true);
                break;
            }
            case UPDATE: {
                dlg.radUpdate.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown import option " + importOption);
            }
        }
        dlg.btnOk.addActionListener(e -> this.onOk(dlg));
        dlg.btnCancel.addActionListener(e -> this.close(dlg));
        GUIUtils.enableCloseByEscape((JDialog)dlg);
        GUIUtils.initLocation((Window)dlg, (int)400, (int)220);
        dlg.setVisible(true);
    }

    public BookmarkImportConflictOption getChosenOption() {
        return this._chosenOption;
    }

    private void close(ImportDuplicateNameDlg dlg) {
        dlg.setVisible(false);
        dlg.dispose();
    }

    private void onOk(ImportDuplicateNameDlg dlg) {
        if (dlg.radIgnore.isSelected()) {
            this._chosenOption = BookmarkImportConflictOption.IGNORE;
        } else if (dlg.radCopy.isSelected()) {
            this._chosenOption = BookmarkImportConflictOption.COPY;
        } else if (dlg.radUpdate.isSelected()) {
            this._chosenOption = BookmarkImportConflictOption.UPDATE;
        } else {
            throw new IllegalStateException("Shouldn't get here");
        }
        Props.putString((String)PREF_KEY_LAST_IMPORT_OPTION, (String)this._chosenOption.name());
        this.close(dlg);
    }
}

