/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class KeyManager {
    public static final char[] STOP_AT = new char[]{'.', '(', ')', '\'', '\n', ',', '=', '<', '>'};
    private JTextComponent _textPane;

    public KeyManager(JTextComponent textPane) {
        this._textPane = textPane;
        this._textPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                KeyManager.this.registerKeyStrokes();
            }

            @Override
            public void focusLost(FocusEvent e) {
                KeyManager.this.unregisterKeyStrokes();
            }
        });
    }

    private void unregisterKeyStrokes() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 128);
        this._textPane.getKeymap().removeKeyStrokeBinding(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(39, 192);
        this._textPane.getKeymap().removeKeyStrokeBinding(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(37, 128);
        this._textPane.getKeymap().removeKeyStrokeBinding(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(37, 192);
        this._textPane.getKeymap().removeKeyStrokeBinding(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(8, 128);
        this._textPane.getKeymap().removeKeyStrokeBinding(keyStroke);
    }

    private void registerKeyStrokes() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 128);
        AbstractAction act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyManager.this.onRightCtrl();
            }
        };
        this._textPane.getKeymap().addActionForKeyStroke(keyStroke, act);
        keyStroke = KeyStroke.getKeyStroke(39, 192);
        act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyManager.this.onRightCtrlShift();
            }
        };
        this._textPane.getKeymap().addActionForKeyStroke(keyStroke, act);
        keyStroke = KeyStroke.getKeyStroke(37, 128);
        act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyManager.this.onLeftCtrl();
            }
        };
        this._textPane.getKeymap().addActionForKeyStroke(keyStroke, act);
        keyStroke = KeyStroke.getKeyStroke(37, 192);
        act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyManager.this.onLeftCtrlShift();
            }
        };
        this._textPane.getKeymap().addActionForKeyStroke(keyStroke, act);
        keyStroke = KeyStroke.getKeyStroke(8, 128);
        act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyManager.this.onCtrlBackSpace();
            }
        };
        this._textPane.getKeymap().addActionForKeyStroke(keyStroke, act);
    }

    private void onCtrlBackSpace() {
        this.moveCtrlLeft(true);
        this._textPane.replaceSelection("");
    }

    private void onLeftCtrlShift() {
        this.moveCtrlLeft(true);
    }

    private void onLeftCtrl() {
        this.moveCtrlLeft(false);
    }

    private void moveCtrlLeft(boolean select) {
        String text = this._textPane.getText();
        int pos = this._textPane.getCaretPosition() - 1;
        if (pos < 0) {
            return;
        }
        while (pos > 0 && !this.isToStopAt(text.charAt(pos - 1), text.charAt(pos))) {
            --pos;
        }
        if (select) {
            this._textPane.moveCaretPosition(pos);
        } else {
            this._textPane.setCaretPosition(pos);
        }
    }

    private void onRightCtrlShift() {
        this.moveCtrlRight(true);
    }

    private void onRightCtrl() {
        this.moveCtrlRight(false);
    }

    private void moveCtrlRight(boolean select) {
        String text = this._textPane.getText();
        int pos = this._textPane.getCaretPosition() + 1;
        if (pos > text.length()) {
            return;
        }
        while (pos < text.length() && !this.isToStopAt(text.charAt(pos), text.charAt(pos - 1))) {
            ++pos;
        }
        if (select) {
            this._textPane.moveCaretPosition(pos);
        } else {
            this._textPane.setCaretPosition(pos);
        }
    }

    private boolean isToStopAt(char toCheck, char former) {
        if (this.isInStopAtArray(former) || this.isInStopAtArray(toCheck)) {
            return true;
        }
        return false == Character.isWhitespace(former) && Character.isWhitespace(toCheck) || Character.isWhitespace(former) && false == Character.isWhitespace(toCheck);
    }

    private boolean isInStopAtArray(char toCheck) {
        for (int i = 0; i < STOP_AT.length; ++i) {
            if (toCheck != STOP_AT[i]) continue;
            return true;
        }
        return false;
    }
}

